/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl;

import java.awt.Image;
import java.awt.Toolkit;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.Collections;
import java.util.concurrent.CancellationException;
import javafx.application.Platform;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import org.jackhuang.hmcl.Launcher;
import org.jackhuang.hmcl.Metadata;
import org.jackhuang.hmcl.ui.AwtUtils;
import org.jackhuang.hmcl.ui.SwingUtils;
import org.jackhuang.hmcl.util.FractureiserDetector;
import org.jackhuang.hmcl.util.Lang;
import org.jackhuang.hmcl.util.SelfDependencyPatcher;
import org.jackhuang.hmcl.util.i18n.I18n;
import org.jackhuang.hmcl.util.logging.Logger;
import org.jackhuang.hmcl.util.platform.JavaVersion;
import org.jackhuang.hmcl.util.platform.OperatingSystem;

public final class Main {
    private Main() {
    }

    public static void main(String[] args) {
        System.getProperties().putIfAbsent("java.net.useSystemProxies", "true");
        System.getProperties().putIfAbsent("javafx.autoproxy.disable", "true");
        System.getProperties().putIfAbsent("http.agent", "HMCL/" + Metadata.VERSION);
        Logger.LOG.start(Metadata.HMCL_DIRECTORY.resolve("logs"));
        Main.checkDirectoryPath();
        if (JavaVersion.CURRENT_JAVA.getParsedVersion() < 9) {
            Lang.thread(Main::fixLetsEncrypt, "CA Certificate Check", true);
        }
        if (OperatingSystem.CURRENT_OS == OperatingSystem.OSX) {
            Main.initIcon();
        }
        Main.checkJavaFX();
        Main.verifyJavaFX();
        Main.detectFractureiser();
        Launcher.main(args);
    }

    public static void exit(int exitCode) {
        Logger.LOG.shutdown();
        System.exit(exitCode);
    }

    private static void initIcon() {
        Image image = Toolkit.getDefaultToolkit().getImage(Main.class.getResource("/assets/img/icon@8x.png"));
        AwtUtils.setAppleIcon(image);
    }

    private static void checkDirectoryPath() {
        String currentDirectory = new File("").getAbsolutePath();
        if (currentDirectory.contains("!")) {
            Main.showErrorAndExit("Exclamation mark(!) is not allowed in the path where HMCL is in.\nThe path is " + currentDirectory);
        }
    }

    private static void detectFractureiser() {
        if (FractureiserDetector.detect()) {
            Logger.LOG.error("Detected that this computer is infected by fractureiser");
            Main.showErrorAndExit(I18n.i18n("fatal.fractureiser"));
        }
    }

    private static void checkJavaFX() {
        try {
            SelfDependencyPatcher.patch();
        }
        catch (SelfDependencyPatcher.PatchException e) {
            Logger.LOG.error("unable to patch JVM", e);
            Main.showErrorAndExit(I18n.i18n("fatal.javafx.missing"));
        }
        catch (SelfDependencyPatcher.IncompatibleVersionException e) {
            Logger.LOG.error("unable to patch JVM", e);
            Main.showErrorAndExit(I18n.i18n("fatal.javafx.incompatible"));
        }
        catch (CancellationException e) {
            Logger.LOG.error("User cancels downloading JavaFX", e);
            Main.exit(0);
        }
    }

    private static void verifyJavaFX() {
        try {
            Class.forName("javafx.beans.binding.Binding");
            Class.forName("javafx.stage.Stage");
            Class.forName("javafx.scene.control.Skin");
        }
        catch (Exception e) {
            Main.showErrorAndExit(I18n.i18n("fatal.javafx.incomplete"));
        }
    }

    static void showErrorAndExit(String message) {
        System.err.println(message);
        System.err.println("A fatal error has occurred, forcibly exiting.");
        try {
            if (Platform.isFxApplicationThread()) {
                new Alert(Alert.AlertType.ERROR, message, new ButtonType[0]).showAndWait();
                Main.exit(1);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        SwingUtils.showErrorDialog(message);
        Main.exit(1);
    }

    static void showWarningAndContinue(String message) {
        System.err.println(message);
        System.err.println("Potential issues have been detected.");
        try {
            if (Platform.isFxApplicationThread()) {
                new Alert(Alert.AlertType.WARNING, message, new ButtonType[0]).showAndWait();
                return;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        SwingUtils.showWarningDialog(message);
    }

    private static void fixLetsEncrypt() {
        try {
            KeyStore defaultKeyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            Path ksPath = Paths.get(System.getProperty("java.home"), "lib", "security", "cacerts");
            try (InputStream ksStream = Files.newInputStream(ksPath, new OpenOption[0]);){
                defaultKeyStore.load(ksStream, "changeit".toCharArray());
            }
            KeyStore letsEncryptKeyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            try (InputStream letsEncryptFile = Main.class.getResourceAsStream("/assets/lekeystore.jks");){
                letsEncryptKeyStore.load(letsEncryptFile, "supersecretpassword".toCharArray());
            }
            KeyStore merged = KeyStore.getInstance(KeyStore.getDefaultType());
            merged.load(null, new char[0]);
            for (String alias : Collections.list(letsEncryptKeyStore.aliases())) {
                merged.setCertificateEntry(alias, letsEncryptKeyStore.getCertificate(alias));
            }
            for (String alias : Collections.list(defaultKeyStore.aliases())) {
                merged.setCertificateEntry(alias, defaultKeyStore.getCertificate(alias));
            }
            TrustManagerFactory instance = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            instance.init(merged);
            SSLContext tls = SSLContext.getInstance("TLS");
            tls.init(null, instance.getTrustManagers(), null);
            HttpsURLConnection.setDefaultSSLSocketFactory(tls.getSocketFactory());
            Logger.LOG.info("Added Lets Encrypt root certificates as additional trust");
        }
        catch (IOException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            Logger.LOG.error("Failed to load lets encrypt certificate. Expect problems", e);
        }
    }
}

