/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl;

import java.nio.file.Path;
import java.nio.file.Paths;
import org.jackhuang.hmcl.util.StringUtils;
import org.jackhuang.hmcl.util.io.JarUtils;
import org.jackhuang.hmcl.util.platform.OperatingSystem;

public final class Metadata {
    public static final String NAME = "HMCL";
    public static final String FULL_NAME = "Hello Minecraft! Launcher";
    public static final String VERSION;
    public static final String TITLE;
    public static final String FULL_TITLE;
    public static final String HMCL_UPDATE_URL;
    public static final String CONTACT_URL = "https://docs.hmcl.net/help.html";
    public static final String HELP_URL = "https://docs.hmcl.net";
    public static final String CHANGELOG_URL = "https://docs.hmcl.net/changelog/";
    public static final String PUBLISH_URL = "https://hmcl.huangyuhui.net";
    public static final String EULA_URL = "https://docs.hmcl.net/eula/hmcl.html";
    public static final String BUILD_CHANNEL;
    public static final String GITHUB_SHA;
    public static final Path MINECRAFT_DIRECTORY;
    public static final Path HMCL_DIRECTORY;

    private Metadata() {
    }

    public static boolean isStable() {
        return "stable".equals(BUILD_CHANNEL);
    }

    public static boolean isDev() {
        return "dev".equals(BUILD_CHANNEL);
    }

    public static boolean isNightly() {
        return !Metadata.isStable() && !Metadata.isDev();
    }

    static {
        String xdgData;
        VERSION = System.getProperty("hmcl.version.override", JarUtils.getManifestAttribute("Implementation-Version", "@develop@"));
        TITLE = "HMCL " + VERSION;
        FULL_TITLE = "Hello Minecraft! Launcher v" + VERSION;
        HMCL_UPDATE_URL = System.getProperty("hmcl.update_source.override", "https://hmcl.huangyuhui.net/api/update_link");
        BUILD_CHANNEL = JarUtils.getManifestAttribute("Build-Channel", "nightly");
        GITHUB_SHA = JarUtils.getManifestAttribute("GitHub-SHA", null);
        MINECRAFT_DIRECTORY = OperatingSystem.getWorkingDirectory("minecraft");
        String hmclHome = System.getProperty("hmcl.home");
        HMCL_DIRECTORY = hmclHome == null ? (OperatingSystem.CURRENT_OS.isLinuxOrBSD() ? (StringUtils.isNotBlank(xdgData = System.getenv("XDG_DATA_HOME")) ? Paths.get(xdgData, "hmcl").toAbsolutePath() : Paths.get(System.getProperty("user.home", "."), ".local", "share", "hmcl").toAbsolutePath()) : OperatingSystem.getWorkingDirectory("hmcl")) : Paths.get(hmclHome, new String[0]).toAbsolutePath().normalize();
    }
}

