/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.download.optifine;

import com.google.gson.reflect.TypeToken;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.jackhuang.hmcl.download.VersionList;
import org.jackhuang.hmcl.download.optifine.OptiFineRemoteVersion;
import org.jackhuang.hmcl.download.optifine.OptiFineVersion;
import org.jackhuang.hmcl.util.StringUtils;
import org.jackhuang.hmcl.util.io.HttpRequest;
import org.jackhuang.hmcl.util.versioning.VersionNumber;

public final class OptiFineBMCLVersionList
extends VersionList<OptiFineRemoteVersion> {
    private final String apiRoot;

    public OptiFineBMCLVersionList(String apiRoot) {
        this.apiRoot = apiRoot;
    }

    @Override
    public boolean hasType() {
        return true;
    }

    @Override
    public CompletableFuture<?> refreshAsync() {
        return HttpRequest.GET(this.apiRoot + "/optifine/versionlist").getJsonAsync(new TypeToken<List<OptiFineVersion>>(){}.getType()).thenAcceptAsync(root -> {
            this.lock.writeLock().lock();
            try {
                this.versions.clear();
                HashSet<String> duplicates = new HashSet<String>();
                for (OptiFineVersion element : root) {
                    boolean isPre;
                    String version = element.getType() + "_" + element.getPatch();
                    String mirror = "https://bmclapi2.bangbang93.com/optifine/" + element.getGameVersion() + "/" + element.getType() + "/" + element.getPatch();
                    if (!duplicates.add(mirror)) continue;
                    boolean bl = isPre = element.getPatch() != null && (element.getPatch().startsWith("pre") || element.getPatch().startsWith("alpha"));
                    if (StringUtils.isBlank(element.getGameVersion())) continue;
                    String gameVersion = VersionNumber.normalize(element.getGameVersion());
                    this.versions.put(gameVersion, new OptiFineRemoteVersion(gameVersion, version, Collections.singletonList(mirror), isPre));
                }
            }
            finally {
                this.lock.writeLock().unlock();
            }
        });
    }
}

