/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.download.quilt;

import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.jackhuang.hmcl.download.DownloadProvider;
import org.jackhuang.hmcl.download.VersionList;
import org.jackhuang.hmcl.download.quilt.QuiltRemoteVersion;
import org.jackhuang.hmcl.util.Lang;
import org.jackhuang.hmcl.util.gson.JsonUtils;
import org.jackhuang.hmcl.util.io.NetworkUtils;
import org.jetbrains.annotations.Nullable;

public final class QuiltVersionList
extends VersionList<QuiltRemoteVersion> {
    private final DownloadProvider downloadProvider;
    private static final String LOADER_META_URL = "https://meta.quiltmc.org/v3/versions/loader";
    private static final String GAME_META_URL = "https://meta.quiltmc.org/v3/versions/game";

    public QuiltVersionList(DownloadProvider downloadProvider) {
        this.downloadProvider = downloadProvider;
    }

    @Override
    public boolean hasType() {
        return false;
    }

    @Override
    public CompletableFuture<?> refreshAsync() {
        return CompletableFuture.runAsync(Lang.wrap(() -> {
            List<String> gameVersions = this.getGameVersions(GAME_META_URL);
            List<String> loaderVersions = this.getGameVersions(LOADER_META_URL);
            this.lock.writeLock().lock();
            try {
                for (String gameVersion : gameVersions) {
                    for (String loaderVersion : loaderVersions) {
                        this.versions.put(gameVersion, new QuiltRemoteVersion(gameVersion, loaderVersion, Collections.singletonList(QuiltVersionList.getLaunchMetaUrl(gameVersion, loaderVersion))));
                    }
                }
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }));
    }

    private List<String> getGameVersions(String metaUrl) throws IOException {
        String json = NetworkUtils.doGet(this.downloadProvider.injectURLWithCandidates(metaUrl));
        return ((ArrayList)JsonUtils.GSON.fromJson(json, new TypeToken<ArrayList<GameVersion>>(){}.getType())).stream().map(GameVersion::getVersion).collect(Collectors.toList());
    }

    private static String getLaunchMetaUrl(String gameVersion, String loaderVersion) {
        return String.format("https://meta.quiltmc.org/v3/versions/loader/%s/%s", gameVersion, loaderVersion);
    }

    private static class GameVersion {
        private final String version;
        private final String maven;
        private final boolean stable;

        public GameVersion() {
            this("", null, false);
        }

        public GameVersion(String version, String maven, boolean stable) {
            this.version = version;
            this.maven = maven;
            this.stable = stable;
        }

        public String getVersion() {
            return this.version;
        }

        @Nullable
        public String getMaven() {
            return this.maven;
        }

        public boolean isStable() {
            return this.stable;
        }
    }
}

