/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.game;

import com.google.gson.JsonParseException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jackhuang.hmcl.util.Lang;
import org.jackhuang.hmcl.util.gson.JsonUtils;
import org.jackhuang.hmcl.util.logging.Logger;
import org.jenkinsci.constant_pool_scanner.ConstantPool;
import org.jenkinsci.constant_pool_scanner.ConstantPoolScanner;
import org.jenkinsci.constant_pool_scanner.ConstantType;
import org.jenkinsci.constant_pool_scanner.StringConstant;

final class GameVersion {
    private GameVersion() {
    }

    private static Optional<String> getVersionFromJson(InputStream versionJson) {
        try {
            Map version = JsonUtils.fromNonNullJsonFully(versionJson, Map.class);
            return Lang.tryCast(version.get("id"), String.class);
        }
        catch (JsonParseException | IOException e) {
            Logger.LOG.warning("Failed to parse version.json", e);
            return Optional.empty();
        }
    }

    private static Optional<String> getVersionOfClassMinecraft(InputStream bytecode) throws IOException {
        ConstantPool pool = ConstantPoolScanner.parse(bytecode, ConstantType.STRING);
        return StreamSupport.stream(pool.list(StringConstant.class).spliterator(), false).map(StringConstant::get).filter(s -> s.startsWith("Minecraft Minecraft ")).map(s -> s.substring("Minecraft Minecraft ".length())).findFirst();
    }

    private static Optional<String> getVersionFromClassMinecraftServer(InputStream bytecode) throws IOException {
        int i;
        ConstantPool pool = ConstantPoolScanner.parse(bytecode, ConstantType.STRING);
        List list = StreamSupport.stream(pool.list(StringConstant.class).spliterator(), false).map(StringConstant::get).collect(Collectors.toList());
        int idx = -1;
        for (i = 0; i < list.size(); ++i) {
            if (!((String)list.get(i)).startsWith("Can't keep up!")) continue;
            idx = i;
            break;
        }
        for (i = idx - 1; i >= 0; --i) {
            if (!((String)list.get(i)).matches(".*[0-9].*")) continue;
            return Optional.of((String)list.get(i));
        }
        return Optional.empty();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Optional<String> minecraftVersion(File file) {
        if (file == null) return Optional.empty();
        if (!file.exists()) return Optional.empty();
        if (!file.isFile()) return Optional.empty();
        if (!file.canRead()) {
            return Optional.empty();
        }
        try (ZipFile gameJar = new ZipFile(file);){
            ZipEntry minecraftServer;
            Optional<String> result;
            ZipEntry versionJson = gameJar.getEntry("version.json");
            if (versionJson != null && (result = GameVersion.getVersionFromJson(gameJar.getInputStream(versionJson))).isPresent()) {
                Optional<String> optional = result;
                return optional;
            }
            ZipEntry minecraft = gameJar.getEntry("net/minecraft/client/Minecraft.class");
            if (minecraft != null) {
                try (InputStream is = gameJar.getInputStream(minecraft);){
                    Optional<String> result2 = GameVersion.getVersionOfClassMinecraft(is);
                    if (result2.isPresent()) {
                        String version = result2.get();
                        if (version.startsWith("Beta ")) {
                            result2 = Optional.of("b" + version.substring("Beta ".length()));
                        }
                        Optional<String> optional = result2;
                        return optional;
                    }
                }
            }
            if ((minecraftServer = gameJar.getEntry("net/minecraft/server/MinecraftServer.class")) != null) {
                try (InputStream is = gameJar.getInputStream(minecraftServer);){
                    Optional<String> optional = GameVersion.getVersionFromClassMinecraftServer(is);
                    return optional;
                }
            }
            Optional<String> optional = Optional.empty();
            return optional;
        }
        catch (IOException e) {
            return Optional.empty();
        }
    }
}

