/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.launch;

import java.util.Collection;
import java.util.List;
import java.util.function.BiConsumer;
import org.jackhuang.hmcl.event.EventBus;
import org.jackhuang.hmcl.event.JVMLaunchFailedEvent;
import org.jackhuang.hmcl.event.ProcessExitedAbnormallyEvent;
import org.jackhuang.hmcl.event.ProcessStoppedEvent;
import org.jackhuang.hmcl.launch.ProcessListener;
import org.jackhuang.hmcl.util.Log4jLevel;
import org.jackhuang.hmcl.util.StringUtils;
import org.jackhuang.hmcl.util.platform.ManagedProcess;
import org.jackhuang.hmcl.util.platform.OperatingSystem;

final class ExitWaiter
implements Runnable {
    private final ManagedProcess process;
    private final Collection<Thread> joins;
    private final BiConsumer<Integer, ProcessListener.ExitType> watcher;

    public ExitWaiter(ManagedProcess process, Collection<Thread> joins, BiConsumer<Integer, ProcessListener.ExitType> watcher) {
        this.process = process;
        this.joins = joins;
        this.watcher = watcher;
    }

    @Override
    public void run() {
        try {
            ProcessListener.ExitType exitType;
            int exitCode = this.process.getProcess().waitFor();
            for (Thread thread : this.joins) {
                thread.join();
            }
            List<String> errorLines = this.process.getLines(Log4jLevel::guessLogLineError);
            if (exitCode != 0 && StringUtils.containsOne(errorLines, "Could not create the Java Virtual Machine.", "Error occurred during initialization of VM", "A fatal exception has occurred. Program will exit.")) {
                EventBus.EVENT_BUS.fireEvent(new JVMLaunchFailedEvent(this, this.process));
                exitType = ProcessListener.ExitType.JVM_ERROR;
            } else if (exitCode != 0 || StringUtils.containsOne(errorLines, "Someone is closing me!", "Crash report saved to", "Could not save crash report to", "This crash report has been saved to:", "Unable to launch", "An exception was thrown, the game will display an error screen and halt.")) {
                EventBus.EVENT_BUS.fireEvent(new ProcessExitedAbnormallyEvent(this, this.process));
                exitType = exitCode == 137 && OperatingSystem.CURRENT_OS.isLinuxOrBSD() ? ProcessListener.ExitType.SIGKILL : ProcessListener.ExitType.APPLICATION_ERROR;
            } else {
                exitType = ProcessListener.ExitType.NORMAL;
            }
            EventBus.EVENT_BUS.fireEvent(new ProcessStoppedEvent(this, this.process));
            this.watcher.accept(exitCode, exitType);
        }
        catch (InterruptedException e) {
            this.watcher.accept(1, ProcessListener.ExitType.INTERRUPTED);
        }
    }
}

