/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.mod;

import com.google.gson.JsonParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jackhuang.hmcl.util.Immutable;
import org.jackhuang.hmcl.util.gson.Validation;
import org.jetbrains.annotations.Nullable;

@Immutable
public final class ModpackConfiguration<T>
implements Validation {
    private final T manifest;
    private final String type;
    private final String name;
    private final String version;
    private final List<FileInformation> overrides;

    public ModpackConfiguration() {
        this(null, null, "", null, Collections.emptyList());
    }

    public ModpackConfiguration(T manifest, String type, String name, String version, List<FileInformation> overrides) {
        this.manifest = manifest;
        this.type = type;
        this.name = name;
        this.version = version;
        this.overrides = new ArrayList<FileInformation>(overrides);
    }

    public T getManifest() {
        return this.manifest;
    }

    public String getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    @Nullable
    public String getVersion() {
        return this.version;
    }

    public ModpackConfiguration<T> setManifest(T manifest) {
        return new ModpackConfiguration<T>(manifest, this.type, this.name, this.version, this.overrides);
    }

    public ModpackConfiguration<T> setOverrides(List<FileInformation> overrides) {
        return new ModpackConfiguration<T>(this.manifest, this.type, this.name, this.version, overrides);
    }

    public ModpackConfiguration<T> setVersion(String version) {
        return new ModpackConfiguration<T>(this.manifest, this.type, this.name, version, this.overrides);
    }

    public List<FileInformation> getOverrides() {
        return Collections.unmodifiableList(this.overrides);
    }

    @Override
    public void validate() throws JsonParseException {
        if (this.manifest == null) {
            throw new JsonParseException("MinecraftInstanceConfiguration missing `manifest`");
        }
        if (this.type == null) {
            throw new JsonParseException("MinecraftInstanceConfiguration missing `type`");
        }
    }

    @Immutable
    public static class FileInformation
    implements Validation {
        private final String path;
        private final String hash;
        private final String downloadURL;

        public FileInformation() {
            this(null, null);
        }

        public FileInformation(String path, String hash) {
            this(path, hash, null);
        }

        public FileInformation(String path, String hash, String downloadURL) {
            this.path = path;
            this.hash = hash;
            this.downloadURL = downloadURL;
        }

        public String getPath() {
            return this.path;
        }

        public String getDownloadURL() {
            return this.downloadURL;
        }

        public String getHash() {
            return this.hash;
        }

        @Override
        public void validate() throws JsonParseException {
            if (this.path == null) {
                throw new JsonParseException("FileInformation missing `path`.");
            }
            if (this.hash == null) {
                throw new JsonParseException("FileInformation missing file hash code.");
            }
        }
    }
}

