/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.mod.curse;

import com.google.gson.reflect.TypeToken;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.jackhuang.hmcl.mod.LocalModFile;
import org.jackhuang.hmcl.mod.RemoteMod;
import org.jackhuang.hmcl.mod.RemoteModRepository;
import org.jackhuang.hmcl.mod.curse.CurseAddon;
import org.jackhuang.hmcl.util.Lang;
import org.jackhuang.hmcl.util.MurmurHash2;
import org.jackhuang.hmcl.util.Pair;
import org.jackhuang.hmcl.util.StringUtils;
import org.jackhuang.hmcl.util.io.HttpRequest;
import org.jackhuang.hmcl.util.io.JarUtils;
import org.jetbrains.annotations.Nullable;

public final class CurseForgeRemoteModRepository
implements RemoteModRepository {
    private static final String PREFIX = "https://api.curseforge.com";
    private static final String apiKey = System.getProperty("hmcl.curseforge.apikey", JarUtils.getManifestAttribute("CurseForge-Api-Key", ""));
    private static final int WORD_PERFECT_MATCH_WEIGHT = 5;
    private final RemoteModRepository.Type type;
    private final int section;
    public static final int SECTION_BUKKIT_PLUGIN = 5;
    public static final int SECTION_MOD = 6;
    public static final int SECTION_RESOURCE_PACK = 12;
    public static final int SECTION_WORLD = 17;
    public static final int SECTION_MODPACK = 4471;
    public static final int SECTION_CUSTOMIZATION = 4546;
    public static final int SECTION_ADDONS = 4559;
    public static final int SECTION_UNKNOWN1 = 4944;
    public static final int SECTION_UNKNOWN2 = 4979;
    public static final int SECTION_UNKNOWN3 = 4984;
    public static final CurseForgeRemoteModRepository MODS = new CurseForgeRemoteModRepository(RemoteModRepository.Type.MOD, 6);
    public static final CurseForgeRemoteModRepository MODPACKS = new CurseForgeRemoteModRepository(RemoteModRepository.Type.MODPACK, 4471);
    public static final CurseForgeRemoteModRepository RESOURCE_PACKS = new CurseForgeRemoteModRepository(RemoteModRepository.Type.RESOURCE_PACK, 12);
    public static final CurseForgeRemoteModRepository WORLDS = new CurseForgeRemoteModRepository(RemoteModRepository.Type.WORLD, 17);
    public static final CurseForgeRemoteModRepository CUSTOMIZATIONS = new CurseForgeRemoteModRepository(RemoteModRepository.Type.CUSTOMIZATION, 4546);

    public static boolean isAvailable() {
        return !apiKey.isEmpty();
    }

    public CurseForgeRemoteModRepository(RemoteModRepository.Type type, int section) {
        this.type = type;
        this.section = section;
    }

    @Override
    public RemoteModRepository.Type getType() {
        return this.type;
    }

    private int toModsSearchSortField(RemoteModRepository.SortType sort) {
        switch (sort) {
            case DATE_CREATED: {
                return 1;
            }
            case POPULARITY: {
                return 2;
            }
            case LAST_UPDATED: {
                return 3;
            }
            case NAME: {
                return 4;
            }
            case AUTHOR: {
                return 5;
            }
            case TOTAL_DOWNLOADS: {
                return 6;
            }
        }
        return 8;
    }

    private String toSortOrder(RemoteModRepository.SortOrder sortOrder) {
        switch (sortOrder) {
            case ASC: {
                return "asc";
            }
            case DESC: {
                return "desc";
            }
        }
        return "asc";
    }

    @Override
    public RemoteModRepository.SearchResult search(String gameVersion, @Nullable RemoteModRepository.Category category, int pageOffset, int pageSize, String searchFilter, RemoteModRepository.SortType sortType, RemoteModRepository.SortOrder sortOrder) throws IOException {
        int categoryId = 0;
        if (category != null) {
            categoryId = ((CurseAddon.Category)category.getSelf()).getId();
        }
        Response response = (Response)HttpRequest.GET("https://api.curseforge.com/v1/mods/search", Pair.pair("gameId", "432"), Pair.pair("classId", Integer.toString(this.section)), Pair.pair("categoryId", Integer.toString(categoryId)), Pair.pair("gameVersion", gameVersion), Pair.pair("searchFilter", searchFilter), Pair.pair("sortField", Integer.toString(this.toModsSearchSortField(sortType))), Pair.pair("sortOrder", this.toSortOrder(sortOrder)), Pair.pair("index", Integer.toString(pageOffset * pageSize)), Pair.pair("pageSize", Integer.toString(pageSize))).header("X-API-KEY", apiKey).getJson(new TypeToken<Response<List<CurseAddon>>>(){}.getType());
        if (searchFilter.isEmpty()) {
            return new RemoteModRepository.SearchResult(((List)response.getData()).stream().map(CurseAddon::toMod), (int)Math.ceil((double)response.pagination.totalCount / (double)pageSize));
        }
        String lowerCaseSearchFilter = searchFilter.toLowerCase();
        HashMap<String, Integer> searchFilterWords = new HashMap<String, Integer>();
        for (String s : StringUtils.tokenize(lowerCaseSearchFilter)) {
            searchFilterWords.put(s, searchFilterWords.getOrDefault(s, 0) + 1);
        }
        StringUtils.LevCalculator levCalculator = new StringUtils.LevCalculator();
        return new RemoteModRepository.SearchResult(((List)response.getData()).stream().map(CurseAddon::toMod).map(remoteMod -> {
            String lowerCaseResult = remoteMod.getTitle().toLowerCase();
            int diff = levCalculator.calc(lowerCaseSearchFilter, lowerCaseResult);
            for (String s : StringUtils.tokenize(lowerCaseResult)) {
                if (!searchFilterWords.containsKey(s)) continue;
                diff -= 5 * (Integer)searchFilterWords.get(s) * s.length();
            }
            return Pair.pair(remoteMod, diff);
        }).sorted(Comparator.comparingInt(Pair::getValue)).map(Pair::getKey), ((List)response.getData()).stream().map(CurseAddon::toMod), response.pagination.totalCount);
    }

    @Override
    public Optional<RemoteMod.Version> getRemoteVersionByLocalFile(LocalModFile localModFile, Path file) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (InputStream stream = Files.newInputStream(file, new OpenOption[0]);){
            int len;
            byte[] buf = new byte[1024];
            while ((len = stream.read(buf, 0, buf.length)) != -1) {
                for (int i = 0; i < len; ++i) {
                    byte b = buf[i];
                    if (b == 9 || b == 10 || b == 13 || b == 32) continue;
                    baos.write(b);
                }
            }
        }
        long hash = Integer.toUnsignedLong(MurmurHash2.hash32(baos.toByteArray(), baos.size(), 1));
        Response response = (Response)HttpRequest.POST("https://api.curseforge.com/v1/fingerprints").json(Lang.mapOf(Pair.pair("fingerprints", Collections.singletonList(hash)))).header("X-API-KEY", apiKey).getJson(new TypeToken<Response<FingerprintMatchesResult>>(){}.getType());
        if (((FingerprintMatchesResult)response.getData()).getExactMatches() == null || ((FingerprintMatchesResult)response.getData()).getExactMatches().isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(((FingerprintMatchesResult)response.getData()).getExactMatches().get(0).getFile().toVersion());
    }

    @Override
    public RemoteMod getModById(String id) throws IOException {
        Response response = (Response)HttpRequest.GET("https://api.curseforge.com/v1/mods/" + id).header("X-API-KEY", apiKey).getJson(new TypeToken<Response<CurseAddon>>(){}.getType());
        return ((CurseAddon)response.data).toMod();
    }

    @Override
    public RemoteMod.File getModFile(String modId, String fileId) throws IOException {
        Response response = (Response)HttpRequest.GET(String.format("%s/v1/mods/%s/files/%s", PREFIX, modId, fileId)).header("X-API-KEY", apiKey).getJson(new TypeToken<Response<CurseAddon.LatestFile>>(){}.getType());
        return ((CurseAddon.LatestFile)response.getData()).toVersion().getFile();
    }

    @Override
    public Stream<RemoteMod.Version> getRemoteVersionsById(String id) throws IOException {
        Response response = (Response)HttpRequest.GET("https://api.curseforge.com/v1/mods/" + id + "/files", Pair.pair("pageSize", "10000")).header("X-API-KEY", apiKey).getJson(new TypeToken<Response<List<CurseAddon.LatestFile>>>(){}.getType());
        return ((List)response.getData()).stream().map(CurseAddon.LatestFile::toVersion);
    }

    public List<CurseAddon.Category> getCategoriesImpl() throws IOException {
        Response categories = (Response)HttpRequest.GET("https://api.curseforge.com/v1/categories", Pair.pair("gameId", "432")).header("X-API-KEY", apiKey).getJson(new TypeToken<Response<List<CurseAddon.Category>>>(){}.getType());
        return this.reorganizeCategories((List)categories.getData(), this.section);
    }

    @Override
    public Stream<RemoteModRepository.Category> getCategories() throws IOException {
        return this.getCategoriesImpl().stream().map(CurseAddon.Category::toCategory);
    }

    private List<CurseAddon.Category> reorganizeCategories(List<CurseAddon.Category> categories, int rootId) {
        ArrayList<CurseAddon.Category> result = new ArrayList<CurseAddon.Category>();
        HashMap<Integer, CurseAddon.Category> categoryMap = new HashMap<Integer, CurseAddon.Category>();
        for (CurseAddon.Category category : categories) {
            categoryMap.put(category.getId(), category);
        }
        for (CurseAddon.Category category : categories) {
            if (category.getParentCategoryId() == rootId) {
                result.add(category);
                continue;
            }
            CurseAddon.Category parentCategory = (CurseAddon.Category)categoryMap.get(category.getParentCategoryId());
            if (parentCategory == null) continue;
            parentCategory.getSubcategories().add(category);
        }
        return result;
    }

    public static class Response<T> {
        private final T data;
        private final Pagination pagination;

        public Response(T data, Pagination pagination) {
            this.data = data;
            this.pagination = pagination;
        }

        public T getData() {
            return this.data;
        }

        public Pagination getPagination() {
            return this.pagination;
        }
    }

    public static class Pagination {
        private final int index;
        private final int pageSize;
        private final int resultCount;
        private final int totalCount;

        public Pagination(int index, int pageSize, int resultCount, int totalCount) {
            this.index = index;
            this.pageSize = pageSize;
            this.resultCount = resultCount;
            this.totalCount = totalCount;
        }

        public int getIndex() {
            return this.index;
        }

        public int getPageSize() {
            return this.pageSize;
        }

        public int getResultCount() {
            return this.resultCount;
        }

        public int getTotalCount() {
            return this.totalCount;
        }
    }

    private static class FingerprintMatchesResult {
        private final boolean isCacheBuilt;
        private final List<FingerprintMatch> exactMatches;
        private final List<Long> exactFingerprints;

        public FingerprintMatchesResult(boolean isCacheBuilt, List<FingerprintMatch> exactMatches, List<Long> exactFingerprints) {
            this.isCacheBuilt = isCacheBuilt;
            this.exactMatches = exactMatches;
            this.exactFingerprints = exactFingerprints;
        }

        public boolean isCacheBuilt() {
            return this.isCacheBuilt;
        }

        public List<FingerprintMatch> getExactMatches() {
            return this.exactMatches;
        }

        public List<Long> getExactFingerprints() {
            return this.exactFingerprints;
        }
    }

    private static class FingerprintMatch {
        private final int id;
        private final CurseAddon.LatestFile file;
        private final List<CurseAddon.LatestFile> latestFiles;

        public FingerprintMatch(int id, CurseAddon.LatestFile file, List<CurseAddon.LatestFile> latestFiles) {
            this.id = id;
            this.file = file;
            this.latestFiles = latestFiles;
        }

        public int getId() {
            return this.id;
        }

        public CurseAddon.LatestFile getFile() {
            return this.file;
        }

        public List<CurseAddon.LatestFile> getLatestFiles() {
            return this.latestFiles;
        }
    }
}

