/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.setting;

import com.google.gson.reflect.TypeToken;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javafx.beans.InvalidationListener;
import javafx.beans.property.ObjectProperty;
import javafx.collections.ObservableList;
import javax.net.ssl.SSLException;
import org.jackhuang.hmcl.Metadata;
import org.jackhuang.hmcl.auth.Account;
import org.jackhuang.hmcl.auth.AccountFactory;
import org.jackhuang.hmcl.auth.AuthenticationException;
import org.jackhuang.hmcl.auth.CharacterDeletedException;
import org.jackhuang.hmcl.auth.NoCharacterException;
import org.jackhuang.hmcl.auth.OAuthAccount;
import org.jackhuang.hmcl.auth.ServerDisconnectException;
import org.jackhuang.hmcl.auth.ServerResponseMalformedException;
import org.jackhuang.hmcl.auth.authlibinjector.AuthlibInjectorAccount;
import org.jackhuang.hmcl.auth.authlibinjector.AuthlibInjectorAccountFactory;
import org.jackhuang.hmcl.auth.authlibinjector.AuthlibInjectorArtifactInfo;
import org.jackhuang.hmcl.auth.authlibinjector.AuthlibInjectorArtifactProvider;
import org.jackhuang.hmcl.auth.authlibinjector.AuthlibInjectorDownloadException;
import org.jackhuang.hmcl.auth.authlibinjector.AuthlibInjectorDownloader;
import org.jackhuang.hmcl.auth.authlibinjector.AuthlibInjectorServer;
import org.jackhuang.hmcl.auth.authlibinjector.BoundAuthlibInjectorAccountFactory;
import org.jackhuang.hmcl.auth.authlibinjector.SimpleAuthlibInjectorArtifactProvider;
import org.jackhuang.hmcl.auth.microsoft.MicrosoftAccount;
import org.jackhuang.hmcl.auth.microsoft.MicrosoftAccountFactory;
import org.jackhuang.hmcl.auth.microsoft.MicrosoftService;
import org.jackhuang.hmcl.auth.offline.OfflineAccount;
import org.jackhuang.hmcl.auth.offline.OfflineAccountFactory;
import org.jackhuang.hmcl.auth.yggdrasil.RemoteAuthenticationException;
import org.jackhuang.hmcl.game.OAuthServer;
import org.jackhuang.hmcl.setting.Config;
import org.jackhuang.hmcl.setting.ConfigHolder;
import org.jackhuang.hmcl.setting.DownloadProviders;
import org.jackhuang.hmcl.task.Schedulers;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.util.InvocationDispatcher;
import org.jackhuang.hmcl.util.Lang;
import org.jackhuang.hmcl.util.i18n.I18n;
import org.jackhuang.hmcl.util.io.FileUtils;
import org.jackhuang.hmcl.util.logging.Logger;
import org.jackhuang.hmcl.util.skin.InvalidSkinException;

public final class Accounts {
    private static final AuthlibInjectorArtifactProvider AUTHLIB_INJECTOR_DOWNLOADER;
    public static final OAuthServer.Factory OAUTH_CALLBACK;
    public static final OfflineAccountFactory FACTORY_OFFLINE;
    public static final AuthlibInjectorAccountFactory FACTORY_AUTHLIB_INJECTOR;
    public static final MicrosoftAccountFactory FACTORY_MICROSOFT;
    public static final List<AccountFactory<?>> FACTORIES;
    private static final Map<String, AccountFactory<?>> type2factory;
    private static final Map<AccountFactory<?>, String> factory2type;
    private static final String GLOBAL_PREFIX = "$GLOBAL:";
    private static final ObservableList<Map<Object, Object>> globalAccountStorages;
    private static final ObservableList<Account> accounts;
    private static final ObjectProperty<Account> selectedAccount;
    private static boolean initialized;
    private static final Map<AccountFactory<?>, String> unlocalizedLoginTypeNames;

    private Accounts() {
    }

    private static void triggerAuthlibInjectorUpdateCheck() {
        if (AUTHLIB_INJECTOR_DOWNLOADER instanceof AuthlibInjectorDownloader) {
            Schedulers.io().execute(() -> {
                try {
                    ((AuthlibInjectorDownloader)AUTHLIB_INJECTOR_DOWNLOADER).checkUpdate();
                }
                catch (IOException e) {
                    Logger.LOG.warning("Failed to check update for authlib-injector", e);
                }
            });
        }
    }

    public static String getLoginType(AccountFactory<?> factory) {
        String type = factory2type.get(factory);
        if (type != null) {
            return type;
        }
        if (factory instanceof BoundAuthlibInjectorAccountFactory) {
            return factory2type.get(FACTORY_AUTHLIB_INJECTOR);
        }
        throw new IllegalArgumentException("Unrecognized account factory");
    }

    public static AccountFactory<?> getAccountFactory(String loginType) {
        return Optional.ofNullable(type2factory.get(loginType)).orElseThrow(() -> new IllegalArgumentException("Unrecognized login type"));
    }

    public static BoundAuthlibInjectorAccountFactory getAccountFactoryByAuthlibInjectorServer(AuthlibInjectorServer server) {
        return new BoundAuthlibInjectorAccountFactory(AUTHLIB_INJECTOR_DOWNLOADER, server);
    }

    public static AccountFactory<?> getAccountFactory(Account account) {
        if (account instanceof OfflineAccount) {
            return FACTORY_OFFLINE;
        }
        if (account instanceof AuthlibInjectorAccount) {
            return FACTORY_AUTHLIB_INJECTOR;
        }
        if (account instanceof MicrosoftAccount) {
            return FACTORY_MICROSOFT;
        }
        throw new IllegalArgumentException("Failed to determine account type: " + account);
    }

    private static Map<Object, Object> getAccountStorage(Account account) {
        Map<Object, Object> storage = account.toStorage();
        storage.put("type", Accounts.getLoginType(Accounts.getAccountFactory(account)));
        return storage;
    }

    private static void updateAccountStorages() {
        if (!initialized) {
            return;
        }
        ArrayList<Map<Object, Object>> global = new ArrayList<Map<Object, Object>>();
        ArrayList<Map<Object, Object>> portable = new ArrayList<Map<Object, Object>>();
        for (Account account : accounts) {
            Map<Object, Object> storage = Accounts.getAccountStorage(account);
            if (account.isPortable()) {
                portable.add(storage);
                continue;
            }
            global.add(storage);
        }
        if (!global.equals(globalAccountStorages)) {
            globalAccountStorages.setAll(global);
        }
        if (!portable.equals(ConfigHolder.config().getAccountStorages())) {
            ConfigHolder.config().getAccountStorages().setAll(portable);
        }
    }

    private static void loadGlobalAccountStorages() {
        Path globalAccountsFile = Metadata.HMCL_DIRECTORY.resolve("accounts.json");
        if (Files.exists(globalAccountsFile, new LinkOption[0])) {
            try (BufferedReader reader = Files.newBufferedReader(globalAccountsFile);){
                globalAccountStorages.setAll((Collection)((List)Config.CONFIG_GSON.fromJson((Reader)reader, new TypeToken<List<Map<Object, Object>>>(){}.getType())));
            }
            catch (Throwable e) {
                Logger.LOG.warning("Failed to load global accounts", e);
            }
        }
        InvocationDispatcher<String> dispatcher = InvocationDispatcher.runOn(Lang::thread, json -> {
            Logger.LOG.info("Saving global accounts");
            Path path = globalAccountsFile;
            synchronized (path) {
                try {
                    Path path2 = globalAccountsFile;
                    synchronized (path2) {
                        FileUtils.saveSafely(globalAccountsFile, json);
                    }
                }
                catch (IOException e) {
                    Logger.LOG.error("Failed to save global accounts", e);
                }
            }
        });
        globalAccountStorages.addListener(FXUtils.onInvalidating(() -> dispatcher.accept(Config.CONFIG_GSON.toJson(globalAccountStorages))));
    }

    private static Account parseAccount(Map<Object, Object> storage) {
        AccountFactory<?> factory = type2factory.get(storage.get("type"));
        if (factory == null) {
            Logger.LOG.warning("Unrecognized account type: " + storage);
            return null;
        }
        try {
            return factory.fromStorage(storage);
        }
        catch (Exception e) {
            Logger.LOG.warning("Failed to load account: " + storage, e);
            return null;
        }
    }

    static void init() {
        Object account;
        if (initialized) {
            throw new IllegalStateException("Already initialized");
        }
        if (!ConfigHolder.config().isAddedLittleSkin()) {
            AuthlibInjectorServer littleSkin = new AuthlibInjectorServer("https://littleskin.cn/api/yggdrasil/");
            if (ConfigHolder.config().getAuthlibInjectorServers().stream().noneMatch(it -> littleSkin.getUrl().equals(it.getUrl()))) {
                ConfigHolder.config().getAuthlibInjectorServers().add(0, (Object)littleSkin);
            }
            ConfigHolder.config().setAddedLittleSkin(true);
        }
        Accounts.loadGlobalAccountStorages();
        Object selected = null;
        for (Map storage : ConfigHolder.config().getAccountStorages()) {
            account = Accounts.parseAccount(storage);
            if (account == null) continue;
            ((Account)account).setPortable(true);
            accounts.add(account);
            if (!Boolean.TRUE.equals(storage.get("selected"))) continue;
            selected = account;
        }
        for (Map storage : globalAccountStorages) {
            account = Accounts.parseAccount(storage);
            if (account == null) continue;
            accounts.add(account);
        }
        String selectedAccountIdentifier = ConfigHolder.config().getSelectedAccount();
        if (selected == null && selectedAccountIdentifier != null) {
            boolean portable = true;
            if (selectedAccountIdentifier.startsWith(GLOBAL_PREFIX)) {
                portable = false;
                selectedAccountIdentifier = selectedAccountIdentifier.substring(GLOBAL_PREFIX.length());
            }
            for (Account account2 : accounts) {
                if (!selectedAccountIdentifier.equals(account2.getIdentifier())) continue;
                if (portable == account2.isPortable()) {
                    selected = account2;
                    break;
                }
                if (selected != null) continue;
                selected = account2;
            }
        }
        if (selected == null && !accounts.isEmpty()) {
            selected = (Account)accounts.get(0);
        }
        selectedAccount.set(selected);
        InvalidationListener listener = o -> {
            Account account = (Account)selectedAccount.get();
            if (accounts.isEmpty()) {
                if (account != null) {
                    selectedAccount.set(null);
                }
            } else if (!accounts.contains((Object)account)) {
                selectedAccount.set((Object)((Account)accounts.get(0)));
            }
        };
        selectedAccount.addListener(listener);
        selectedAccount.addListener(FXUtils.onInvalidating(() -> {
            Account account = (Account)selectedAccount.get();
            if (account != null) {
                ConfigHolder.config().setSelectedAccount(account.isPortable() ? account.getIdentifier() : GLOBAL_PREFIX + account.getIdentifier());
            } else {
                ConfigHolder.config().setSelectedAccount(null);
            }
        }));
        accounts.addListener(listener);
        accounts.addListener(FXUtils.onInvalidating(Accounts::updateAccountStorages));
        initialized = true;
        ConfigHolder.config().getAuthlibInjectorServers().addListener(FXUtils.onInvalidating(Accounts::removeDanglingAuthlibInjectorAccounts));
        if (selected != null) {
            Object finalSelected = selected;
            Schedulers.io().execute(() -> Accounts.lambda$init$9((Account)finalSelected));
        }
        Accounts.triggerAuthlibInjectorUpdateCheck();
        for (AuthlibInjectorServer server : ConfigHolder.config().getAuthlibInjectorServers()) {
            if (selected instanceof AuthlibInjectorAccount && ((AuthlibInjectorAccount)selected).getServer() == server) continue;
            Schedulers.io().execute(() -> {
                try {
                    server.fetchMetadataResponse();
                }
                catch (IOException e) {
                    Logger.LOG.warning("Failed to fetch authlib-injector server metdata: " + server, e);
                }
            });
        }
    }

    public static ObservableList<Account> getAccounts() {
        return accounts;
    }

    public static Account getSelectedAccount() {
        return (Account)selectedAccount.get();
    }

    public static void setSelectedAccount(Account selectedAccount) {
        Accounts.selectedAccount.set((Object)selectedAccount);
    }

    public static ObjectProperty<Account> selectedAccountProperty() {
        return selectedAccount;
    }

    private static AuthlibInjectorArtifactProvider createAuthlibInjectorArtifactProvider() {
        String authlibinjectorLocation = System.getProperty("hmcl.authlibinjector.location");
        if (authlibinjectorLocation == null) {
            return new AuthlibInjectorDownloader(Metadata.HMCL_DIRECTORY.resolve("authlib-injector.jar"), DownloadProviders::getDownloadProvider){

                @Override
                public Optional<AuthlibInjectorArtifactInfo> getArtifactInfoImmediately() {
                    Optional<AuthlibInjectorArtifactInfo> local = super.getArtifactInfoImmediately();
                    if (local.isPresent()) {
                        return local;
                    }
                    return 2.parseArtifact(Paths.get("authlib-injector.jar", new String[0]));
                }
            };
        }
        Logger.LOG.info("Using specified authlib-injector: " + authlibinjectorLocation);
        return new SimpleAuthlibInjectorArtifactProvider(Paths.get(authlibinjectorLocation, new String[0]));
    }

    private static AuthlibInjectorServer getOrCreateAuthlibInjectorServer(String url) {
        return ConfigHolder.config().getAuthlibInjectorServers().stream().filter(server -> url.equals(server.getUrl())).findFirst().orElseGet(() -> {
            AuthlibInjectorServer server = new AuthlibInjectorServer(url);
            ConfigHolder.config().getAuthlibInjectorServers().add((Object)server);
            return server;
        });
    }

    private static void removeDanglingAuthlibInjectorAccounts() {
        accounts.stream().filter(AuthlibInjectorAccount.class::isInstance).map(AuthlibInjectorAccount.class::cast).filter(it -> !ConfigHolder.config().getAuthlibInjectorServers().contains((Object)it.getServer())).collect(Collectors.toList()).forEach(arg_0 -> accounts.remove(arg_0));
    }

    public static String getLocalizedLoginTypeName(AccountFactory<?> factory) {
        return I18n.i18n(Optional.ofNullable(unlocalizedLoginTypeNames.get(factory)).orElseThrow(() -> new IllegalArgumentException("Unrecognized account factory")));
    }

    public static String localizeErrorMessage(Exception exception) {
        if (exception instanceof NoCharacterException) {
            return I18n.i18n("account.failed.no_character");
        }
        if (exception instanceof ServerDisconnectException) {
            if (exception.getCause() instanceof SSLException) {
                return I18n.i18n("account.failed.ssl");
            }
            return I18n.i18n("account.failed.connect_authentication_server");
        }
        if (exception instanceof ServerResponseMalformedException) {
            return I18n.i18n("account.failed.server_response_malformed");
        }
        if (exception instanceof RemoteAuthenticationException) {
            RemoteAuthenticationException remoteException = (RemoteAuthenticationException)exception;
            String remoteMessage = remoteException.getRemoteMessage();
            if ("ForbiddenOperationException".equals(remoteException.getRemoteName()) && remoteMessage != null) {
                if (remoteMessage.contains("Invalid credentials")) {
                    return I18n.i18n("account.failed.invalid_credentials");
                }
                if (remoteMessage.contains("Invalid token")) {
                    return I18n.i18n("account.failed.invalid_token");
                }
                if (remoteMessage.contains("Invalid username or password")) {
                    return I18n.i18n("account.failed.invalid_password");
                }
                return remoteMessage;
            }
            if ("ResourceException".equals(remoteException.getRemoteName()) && remoteMessage != null) {
                if (remoteMessage.contains("The requested resource is no longer available")) {
                    return I18n.i18n("account.failed.migration");
                }
                return remoteMessage;
            }
            return exception.getMessage();
        }
        if (exception instanceof AuthlibInjectorDownloadException) {
            return I18n.i18n("account.failed.injector_download_failure");
        }
        if (exception instanceof CharacterDeletedException) {
            return I18n.i18n("account.failed.character_deleted");
        }
        if (exception instanceof InvalidSkinException) {
            return I18n.i18n("account.skin.invalid_skin");
        }
        if (exception instanceof MicrosoftService.XboxAuthorizationException) {
            long errorCode = ((MicrosoftService.XboxAuthorizationException)exception).getErrorCode();
            if (errorCode == 2148916238L) {
                return I18n.i18n("account.methods.microsoft.error.add_family");
            }
            if (errorCode == 2148916235L) {
                return I18n.i18n("account.methods.microsoft.error.country_unavailable");
            }
            if (errorCode == 2148916233L) {
                return I18n.i18n("account.methods.microsoft.error.missing_xbox_account");
            }
            return I18n.i18n("account.methods.microsoft.error.unknown", errorCode);
        }
        if (exception instanceof MicrosoftService.NoMinecraftJavaEditionProfileException) {
            return I18n.i18n("account.methods.microsoft.error.no_character");
        }
        if (exception instanceof MicrosoftService.NoXuiException) {
            return I18n.i18n("account.methods.microsoft.error.add_family_probably");
        }
        if (exception instanceof OAuthServer.MicrosoftAuthenticationNotSupportedException) {
            return I18n.i18n("account.methods.microsoft.snapshot");
        }
        if (exception instanceof OAuthAccount.WrongAccountException) {
            return I18n.i18n("account.failed.wrong_account");
        }
        if (exception.getClass() == AuthenticationException.class) {
            return exception.getLocalizedMessage();
        }
        return exception.getClass().getName() + ": " + exception.getLocalizedMessage();
    }

    private static /* synthetic */ void lambda$init$9(Account finalSelected) {
        try {
            finalSelected.logIn();
        }
        catch (Throwable e) {
            Logger.LOG.warning("Failed to log " + finalSelected + " in", e);
        }
    }

    /*
     * Exception decompiling
     */
    static {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.applyExpressionRewriter(CastExpression.java:128)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriterToArgs(StaticFunctionInvokation.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriter(StaticFunctionInvokation.java:90)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

