/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui;

import com.jfoenix.controls.JFXButton;
import com.jfoenix.controls.JFXCheckBox;
import com.jfoenix.controls.JFXComboBox;
import com.jfoenix.controls.JFXListCell;
import com.jfoenix.controls.JFXPasswordField;
import com.jfoenix.controls.JFXTextField;
import com.jfoenix.controls.JFXToggleButton;
import com.jfoenix.controls.JFXTreeTableColumn;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Desktop;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javafx.animation.Animation;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.property.Property;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WeakChangeListener;
import javafx.beans.value.WritableValue;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.Tooltip;
import javafx.scene.control.TreeTableColumn;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.TransferMode;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Text;
import javafx.scene.text.TextFlow;
import javafx.stage.Stage;
import javafx.util.Callback;
import javafx.util.Duration;
import javafx.util.StringConverter;
import javax.swing.ImageIcon;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.glavo.png.PNGType;
import org.glavo.png.PNGWriter;
import org.glavo.png.javafx.PNGJavaFXUtils;
import org.jackhuang.hmcl.task.Schedulers;
import org.jackhuang.hmcl.task.Task;
import org.jackhuang.hmcl.ui.Controllers;
import org.jackhuang.hmcl.ui.ScrollUtils;
import org.jackhuang.hmcl.ui.SwingUtils;
import org.jackhuang.hmcl.ui.WebStage;
import org.jackhuang.hmcl.ui.animation.AnimationUtils;
import org.jackhuang.hmcl.ui.construct.JFXHyperlink;
import org.jackhuang.hmcl.util.Holder;
import org.jackhuang.hmcl.util.Lang;
import org.jackhuang.hmcl.util.ResourceNotFoundError;
import org.jackhuang.hmcl.util.i18n.I18n;
import org.jackhuang.hmcl.util.io.FileUtils;
import org.jackhuang.hmcl.util.javafx.SafeStringConverter;
import org.jackhuang.hmcl.util.logging.Logger;
import org.jackhuang.hmcl.util.platform.OperatingSystem;
import org.jackhuang.hmcl.util.platform.SystemUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class FXUtils {
    public static final String DEFAULT_MONOSPACE_FONT = OperatingSystem.CURRENT_OS == OperatingSystem.WINDOWS ? "Consolas" : "Monospace";
    private static final Map<String, Image> builtinImageCache = new ConcurrentHashMap<String, Image>();
    private static final Map<String, Path> remoteImageCache = new ConcurrentHashMap<String, Path>();
    private static final String[] linuxBrowsers = new String[]{"xdg-open", "google-chrome", "firefox", "microsoft-edge", "opera", "konqueror", "mozilla"};
    public static final Interpolator SINE = new Interpolator(){

        protected double curve(double t) {
            return Math.sin(t * Math.PI / 2.0);
        }

        public String toString() {
            return "Interpolator.SINE";
        }
    };

    private FXUtils() {
    }

    public static void shutdown() {
        for (Map.Entry<String, Path> entry : remoteImageCache.entrySet()) {
            try {
                Files.deleteIfExists(entry.getValue());
            }
            catch (IOException e) {
                Logger.LOG.warning(String.format("Failed to delete cache file %s.", entry.getValue()), e);
            }
            remoteImageCache.remove(entry.getKey());
        }
        builtinImageCache.clear();
    }

    public static void runInFX(Runnable runnable) {
        if (Platform.isFxApplicationThread()) {
            runnable.run();
        } else {
            Platform.runLater((Runnable)runnable);
        }
    }

    public static void checkFxUserThread() {
        if (!Platform.isFxApplicationThread()) {
            throw new IllegalStateException("Not on FX application thread; currentThread = " + Thread.currentThread().getName());
        }
    }

    public static InvalidationListener onInvalidating(Runnable action) {
        return arg -> action.run();
    }

    public static <T> void onChange(ObservableValue<T> value, Consumer<T> consumer) {
        value.addListener((a, b, c) -> consumer.accept(c));
    }

    public static <T> ChangeListener<T> onWeakChange(ObservableValue<T> value, Consumer<T> consumer) {
        ChangeListener listener = (a, b, c) -> consumer.accept(c);
        value.addListener((ChangeListener)new WeakChangeListener(listener));
        return listener;
    }

    public static <T> void onChangeAndOperate(ObservableValue<T> value, Consumer<T> consumer) {
        consumer.accept(value.getValue());
        FXUtils.onChange(value, consumer);
    }

    public static <T> ChangeListener<T> onWeakChangeAndOperate(ObservableValue<T> value, Consumer<T> consumer) {
        consumer.accept(value.getValue());
        return FXUtils.onWeakChange(value, consumer);
    }

    public static InvalidationListener observeWeak(Runnable runnable, Observable ... observables) {
        InvalidationListener originalListener = observable -> runnable.run();
        WeakInvalidationListener listener = new WeakInvalidationListener(originalListener);
        for (Observable observable2 : observables) {
            observable2.addListener((InvalidationListener)listener);
        }
        runnable.run();
        return originalListener;
    }

    public static void runLaterIf(BooleanSupplier condition, Runnable runnable) {
        if (condition.getAsBoolean()) {
            Platform.runLater(() -> FXUtils.runLaterIf(condition, runnable));
        } else {
            runnable.run();
        }
    }

    public static void limitSize(ImageView imageView, double maxWidth, double maxHeight) {
        imageView.setPreserveRatio(true);
        FXUtils.onChangeAndOperate(imageView.imageProperty(), image -> {
            if (image != null && (image.getWidth() > maxWidth || image.getHeight() > maxHeight)) {
                imageView.setFitHeight(maxHeight);
                imageView.setFitWidth(maxWidth);
            } else {
                imageView.setFitHeight(-1.0);
                imageView.setFitWidth(-1.0);
            }
        });
    }

    public static <T> void addListener(Node node, String key, ObservableValue<T> value, Consumer<? super T> callback) {
        ListenerPair<T> pair = new ListenerPair<T>(value, (a, b, newValue) -> callback.accept(newValue));
        node.getProperties().put((Object)key, pair);
        pair.bind();
    }

    public static void removeListener(Node node, String key) {
        Lang.tryCast(node.getProperties().get((Object)key), ListenerPair.class).ifPresent(info -> {
            info.unbind();
            node.getProperties().remove((Object)key);
        });
    }

    public static <K, T> void setupCellValueFactory(JFXTreeTableColumn<K, T> column, Function<K, ObservableValue<T>> mapper) {
        column.setCellValueFactory(param -> {
            if (column.validateValue((TreeTableColumn.CellDataFeatures)param)) {
                return (ObservableValue)mapper.apply(param.getValue().getValue());
            }
            return column.getComputedValue((TreeTableColumn.CellDataFeatures)param);
        });
    }

    public static Node wrapMargin(Node node, Insets insets) {
        StackPane.setMargin((Node)node, (Insets)insets);
        return new StackPane(new Node[]{node});
    }

    public static void setValidateWhileTextChanged(Node field, boolean validate) {
        if (field instanceof JFXTextField) {
            if (validate) {
                FXUtils.addListener(field, "FXUtils.validation", ((JFXTextField)field).textProperty(), o -> ((JFXTextField)field).validate());
            } else {
                FXUtils.removeListener(field, "FXUtils.validation");
            }
            ((JFXTextField)field).validate();
        } else if (field instanceof JFXPasswordField) {
            if (validate) {
                FXUtils.addListener(field, "FXUtils.validation", ((JFXPasswordField)field).textProperty(), o -> ((JFXPasswordField)field).validate());
            } else {
                FXUtils.removeListener(field, "FXUtils.validation");
            }
            ((JFXPasswordField)field).validate();
        } else {
            throw new IllegalArgumentException("Only JFXTextField and JFXPasswordField allowed");
        }
    }

    public static boolean getValidateWhileTextChanged(Node field) {
        return field.getProperties().containsKey((Object)"FXUtils.validation");
    }

    public static Rectangle setOverflowHidden(Region region) {
        Rectangle rectangle = new Rectangle();
        rectangle.widthProperty().bind((ObservableValue)region.widthProperty());
        rectangle.heightProperty().bind((ObservableValue)region.heightProperty());
        region.setClip((Node)rectangle);
        return rectangle;
    }

    public static Rectangle setOverflowHidden(Region region, double arc) {
        Rectangle rectangle = FXUtils.setOverflowHidden(region);
        rectangle.setArcWidth(arc);
        rectangle.setArcHeight(arc);
        return rectangle;
    }

    public static void setLimitWidth(Region region, double width) {
        region.setMaxWidth(width);
        region.setMinWidth(width);
        region.setPrefWidth(width);
    }

    public static double getLimitWidth(Region region) {
        return region.getMaxWidth();
    }

    public static void setLimitHeight(Region region, double height) {
        region.setMaxHeight(height);
        region.setMinHeight(height);
        region.setPrefHeight(height);
    }

    public static double getLimitHeight(Region region) {
        return region.getMaxHeight();
    }

    public static Node limitingSize(Node node, double width, double height) {
        StackPane pane = new StackPane(new Node[]{node});
        pane.setAlignment(Pos.CENTER);
        FXUtils.setLimitWidth((Region)pane, width);
        FXUtils.setLimitHeight((Region)pane, height);
        return pane;
    }

    public static void smoothScrolling(ScrollPane scrollPane) {
        if (AnimationUtils.isAnimationEnabled()) {
            ScrollUtils.addSmoothScrolling(scrollPane);
        }
    }

    public static void installFastTooltip(Node node, Tooltip tooltip) {
        FXUtils.installTooltip(node, 50.0, 5000.0, 0.0, tooltip);
    }

    public static void installFastTooltip(Node node, String tooltip) {
        FXUtils.installFastTooltip(node, new Tooltip(tooltip));
    }

    public static void installSlowTooltip(Node node, Tooltip tooltip) {
        FXUtils.installTooltip(node, 500.0, 5000.0, 0.0, tooltip);
    }

    public static void installSlowTooltip(Node node, String tooltip) {
        FXUtils.installSlowTooltip(node, new Tooltip(tooltip));
    }

    public static void installTooltip(Node node, double openDelay, double visibleDelay, double closeDelay, Tooltip tooltip) {
        FXUtils.runInFX(() -> {
            try {
                Class<?> behaviorClass = Class.forName("javafx.scene.control.Tooltip$TooltipBehavior");
                Constructor<?> behaviorConstructor = behaviorClass.getDeclaredConstructor(Duration.class, Duration.class, Duration.class, Boolean.TYPE);
                behaviorConstructor.setAccessible(true);
                Object behavior = behaviorConstructor.newInstance(new Duration(openDelay), new Duration(visibleDelay), new Duration(closeDelay), false);
                Method installMethod = behaviorClass.getDeclaredMethod("install", Node.class, Tooltip.class);
                installMethod.setAccessible(true);
                installMethod.invoke(behavior, node, tooltip);
            }
            catch (ReflectiveOperationException e) {
                try {
                    Tooltip.class.getMethod("setShowDelay", Duration.class).invoke((Object)tooltip, new Duration(openDelay));
                    Tooltip.class.getMethod("setShowDuration", Duration.class).invoke((Object)tooltip, new Duration(visibleDelay));
                    Tooltip.class.getMethod("setHideDelay", Duration.class).invoke((Object)tooltip, new Duration(closeDelay));
                }
                catch (ReflectiveOperationException e2) {
                    e.addSuppressed(e2);
                    Logger.LOG.error("Cannot install tooltip", e);
                }
                Tooltip.install((Node)node, (Tooltip)tooltip);
            }
        });
    }

    public static void playAnimation(Node node, String animationKey, Timeline timeline) {
        animationKey = "FXUTILS.ANIMATION." + animationKey;
        Object oldTimeline = node.getProperties().get((Object)animationKey);
        if (timeline != null) {
            timeline.play();
        }
        node.getProperties().put((Object)animationKey, (Object)timeline);
    }

    public static <T> Animation playAnimation(Node node, String animationKey, Duration duration, WritableValue<T> property, T from, T to, Interpolator interpolator) {
        if (from == null) {
            from = property.getValue();
        }
        if (duration == null || Objects.equals(duration, Duration.ZERO) || Objects.equals(from, to)) {
            FXUtils.playAnimation(node, animationKey, null);
            property.setValue(to);
            return null;
        }
        Timeline timeline = new Timeline(new KeyFrame[]{new KeyFrame(Duration.ZERO, new KeyValue[]{new KeyValue(property, from, interpolator)}), new KeyFrame(duration, new KeyValue[]{new KeyValue(property, to, interpolator)})});
        FXUtils.playAnimation(node, animationKey, timeline);
        return timeline;
    }

    public static void openFolder(File file) {
        if (!FileUtils.makeDirectory(file)) {
            Logger.LOG.error("Unable to make directory " + file);
            return;
        }
        String path = file.getAbsolutePath();
        String openCommand = OperatingSystem.CURRENT_OS == OperatingSystem.WINDOWS ? "explorer.exe" : (OperatingSystem.CURRENT_OS == OperatingSystem.OSX ? "/usr/bin/open" : (OperatingSystem.CURRENT_OS.isLinuxOrBSD() && new File("/usr/bin/xdg-open").exists() ? "/usr/bin/xdg-open" : null));
        Lang.thread(() -> {
            if (openCommand != null) {
                try {
                    int exitCode = SystemUtils.callExternalProcess(openCommand, path);
                    if (exitCode == 0 || exitCode == 1 && OperatingSystem.CURRENT_OS == OperatingSystem.WINDOWS) {
                        return;
                    }
                    Logger.LOG.warning("Open " + path + " failed with code " + exitCode);
                }
                catch (Throwable e) {
                    Logger.LOG.warning("Unable to open " + path + " by executing " + openCommand, e);
                }
            }
            try {
                Desktop.getDesktop().open(file);
            }
            catch (Throwable e) {
                Logger.LOG.error("Unable to open " + path + " by java.awt.Desktop.getDesktop()::open", e);
            }
        });
    }

    public static void showFileInExplorer(Path file) {
        String path = file.toAbsolutePath().toString();
        String[] openCommands = OperatingSystem.CURRENT_OS == OperatingSystem.WINDOWS ? new String[]{"explorer.exe", "/select,", path} : (OperatingSystem.CURRENT_OS == OperatingSystem.OSX ? new String[]{"/usr/bin/open", "-R", path} : null);
        if (openCommands != null) {
            Lang.thread(() -> {
                try {
                    int exitCode = SystemUtils.callExternalProcess(openCommands);
                    if (exitCode == 0 || exitCode == 1 && OperatingSystem.CURRENT_OS == OperatingSystem.WINDOWS) {
                        return;
                    }
                    Logger.LOG.warning("Show " + path + " in explorer failed with code " + exitCode);
                }
                catch (Throwable e) {
                    Logger.LOG.warning("Unable to show " + path + " in explorer", e);
                }
                FXUtils.openFolder(file.getParent().toFile());
            });
        } else {
            FXUtils.openFolder(file.getParent().toFile());
        }
    }

    public static void openLink(String link) {
        if (link == null) {
            return;
        }
        Lang.thread(() -> {
            if (OperatingSystem.CURRENT_OS == OperatingSystem.WINDOWS) {
                try {
                    Runtime.getRuntime().exec(new String[]{"rundll32.exe", "url.dll,FileProtocolHandler", link});
                    return;
                }
                catch (Throwable e) {
                    Logger.LOG.warning("An exception occurred while calling rundll32", e);
                }
            }
            if (OperatingSystem.CURRENT_OS.isLinuxOrBSD()) {
                for (String browser : linuxBrowsers) {
                    try (InputStream is = Runtime.getRuntime().exec(new String[]{"which", browser}).getInputStream();){
                        if (is.read() != -1) {
                            Runtime.getRuntime().exec(new String[]{browser, link});
                            return;
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    Logger.LOG.warning("No known browser found");
                }
            }
            try {
                Desktop.getDesktop().browse(new URI(link));
            }
            catch (Throwable e) {
                if (OperatingSystem.CURRENT_OS == OperatingSystem.OSX) {
                    try {
                        Runtime.getRuntime().exec(new String[]{"/usr/bin/open", link});
                    }
                    catch (IOException ex) {
                        Logger.LOG.warning("Unable to open link: " + link, ex);
                    }
                }
                Logger.LOG.warning("Failed to open link: " + link, e);
            }
        });
    }

    public static void showWebDialog(String title, String content) {
        FXUtils.showWebDialog(title, content, 800, 480);
    }

    public static void showWebDialog(String title, String content, int width, int height) {
        try {
            WebStage stage = new WebStage(width, height);
            stage.getWebView().getEngine().loadContent(content);
            stage.setTitle(title);
            stage.showAndWait();
        }
        catch (NoClassDefFoundError | UnsatisfiedLinkError e) {
            Logger.LOG.warning("WebView is missing or initialization failed, use JEditorPane replaced", e);
            SwingUtils.initLookAndFeel();
            SwingUtilities.invokeLater(() -> {
                JFrame frame = new JFrame(title);
                frame.setSize(width, height);
                frame.setDefaultCloseOperation(2);
                frame.setLocationByPlatform(true);
                frame.setIconImage(new ImageIcon(FXUtils.class.getResource("/assets/img/icon.png")).getImage());
                frame.setLayout(new BorderLayout());
                JProgressBar progressBar = new JProgressBar();
                progressBar.setIndeterminate(true);
                frame.add((Component)progressBar, "First");
                Schedulers.defaultScheduler().execute(() -> {
                    JEditorPane pane = new JEditorPane("text/html", content);
                    pane.setEditable(false);
                    pane.addHyperlinkListener(event -> {
                        if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                            FXUtils.openLink(event.getURL().toExternalForm());
                        }
                    });
                    SwingUtilities.invokeLater(() -> {
                        progressBar.setVisible(false);
                        frame.add((Component)new JScrollPane(pane), "Center");
                    });
                });
                frame.setVisible(true);
                frame.toFront();
            });
        }
    }

    public static <T> void bind(JFXTextField textField, Property<T> property, StringConverter<T> converter) {
        textField.setText(converter == null ? (String)property.getValue() : converter.toString(property.getValue()));
        TextFieldBindingListener<T> listener = new TextFieldBindingListener<T>(textField, property, converter);
        textField.focusedProperty().addListener(listener);
        property.addListener(listener);
    }

    public static void bindInt(JFXTextField textField, Property<Number> property) {
        FXUtils.bind(textField, property, SafeStringConverter.fromInteger());
    }

    public static void bindString(JFXTextField textField, Property<String> property) {
        FXUtils.bind(textField, property, null);
    }

    public static void unbind(JFXTextField textField, Property<?> property) {
        TextFieldBindingListener listener = new TextFieldBindingListener(textField, property, null);
        textField.focusedProperty().removeListener(listener);
        property.removeListener(listener);
    }

    public static void bindBoolean(JFXToggleButton toggleButton, Property<Boolean> property) {
        toggleButton.selectedProperty().bindBidirectional(property);
    }

    public static void unbindBoolean(JFXToggleButton toggleButton, Property<Boolean> property) {
        toggleButton.selectedProperty().unbindBidirectional(property);
    }

    public static void bindBoolean(JFXCheckBox checkBox, Property<Boolean> property) {
        checkBox.selectedProperty().bindBidirectional(property);
    }

    public static void unbindBoolean(JFXCheckBox checkBox, Property<Boolean> property) {
        checkBox.selectedProperty().unbindBidirectional(property);
    }

    public static <T extends Enum<T>> void bindEnum(JFXComboBox<T> comboBox, Property<T> property) {
        FXUtils.unbindEnum(comboBox);
        Enum currentValue = (Enum)property.getValue();
        Enum[] enumConstants = (Enum[])currentValue.getClass().getEnumConstants();
        ChangeListener listener = (a, b, newValue) -> property.setValue((Object)enumConstants[newValue.intValue()]);
        comboBox.getSelectionModel().select(currentValue.ordinal());
        comboBox.getProperties().put((Object)"FXUtils.bindEnum.listener", (Object)listener);
        comboBox.getSelectionModel().selectedIndexProperty().addListener(listener);
    }

    public static void unbindEnum(JFXComboBox<? extends Enum<?>> comboBox) {
        ChangeListener listener = (ChangeListener)comboBox.getProperties().remove((Object)"FXUtils.bindEnum.listener");
        if (listener != null) {
            comboBox.getSelectionModel().selectedIndexProperty().removeListener(listener);
        }
    }

    public static void setIcon(Stage stage) {
        String icon = OperatingSystem.CURRENT_OS == OperatingSystem.WINDOWS ? "/assets/img/icon.png" : "/assets/img/icon@4x.png";
        stage.getIcons().add((Object)FXUtils.newBuiltinImage(icon));
    }

    public static Image newBuiltinImage(String url) {
        try {
            return builtinImageCache.computeIfAbsent(url, Image::new);
        }
        catch (IllegalArgumentException e) {
            throw new ResourceNotFoundError("Cannot access image: " + url, e);
        }
    }

    public static Image newBuiltinImage(String url, double requestedWidth, double requestedHeight, boolean preserveRatio, boolean smooth) {
        try {
            return new Image(url, requestedWidth, requestedHeight, preserveRatio, smooth);
        }
        catch (IllegalArgumentException e) {
            throw new ResourceNotFoundError("Cannot access image: " + url, e);
        }
    }

    public static Image newRemoteImage(String url) {
        return FXUtils.newRemoteImage(url, 0.0, 0.0, false, false, false);
    }

    public static Image newRemoteImage(String url, double requestedWidth, double requestedHeight, boolean preserveRatio, boolean smooth, boolean backgroundLoading) {
        Path currentPath = remoteImageCache.get(url);
        if (currentPath != null) {
            if (Files.isReadable(currentPath)) {
                Image image;
                block12: {
                    InputStream inputStream = Files.newInputStream(currentPath, new OpenOption[0]);
                    try {
                        image = new Image(inputStream, requestedWidth, requestedHeight, preserveRatio, smooth);
                        if (inputStream == null) break block12;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (inputStream != null) {
                                try {
                                    inputStream.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (IOException e) {
                            Logger.LOG.warning("An exception encountered while reading data from cached image file.", e);
                        }
                    }
                    inputStream.close();
                }
                return image;
            }
            remoteImageCache.remove(url);
            try {
                Files.deleteIfExists(currentPath);
            }
            catch (IOException e) {
                Logger.LOG.warning("An exception encountered while deleting broken cached image file.", e);
            }
        }
        Image image = new Image(url, requestedWidth, requestedHeight, preserveRatio, smooth, backgroundLoading);
        image.progressProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue.doubleValue() >= 1.0 && !image.isError() && image.getPixelReader() != null && image.getWidth() > 0.0 && image.getHeight() > 0.0) {
                Task.runAsync(() -> {
                    Path newPath = Files.createTempFile("hmcl-net-resource-cache-", ".cache", new FileAttribute[0]);
                    try (OutputStream outputStream = Files.newOutputStream(newPath, new OpenOption[0]);
                         PNGWriter writer = new PNGWriter(outputStream, PNGType.RGBA, -1);){
                        writer.write(PNGJavaFXUtils.asArgbImage(image));
                    }
                    catch (IOException e) {
                        try {
                            Files.delete(newPath);
                        }
                        catch (IOException e2) {
                            e2.addSuppressed(e);
                            throw e2;
                        }
                        throw e;
                    }
                    if (remoteImageCache.putIfAbsent(url, newPath) != null) {
                        Files.delete(newPath);
                    }
                }).start();
            }
        });
        return image;
    }

    public static JFXButton newRaisedButton(String text) {
        JFXButton button = new JFXButton(text);
        button.getStyleClass().add((Object)"jfx-button-raised");
        button.setButtonType(JFXButton.ButtonType.RAISED);
        return button;
    }

    public static JFXButton newBorderButton(String text) {
        JFXButton button = new JFXButton(text);
        button.getStyleClass().add((Object)"jfx-button-border");
        button.setButtonType(JFXButton.ButtonType.RAISED);
        return button;
    }

    public static void applyDragListener(Node node, FileFilter filter, Consumer<List<File>> callback) {
        FXUtils.applyDragListener(node, filter, callback, null);
    }

    public static void applyDragListener(Node node, FileFilter filter, Consumer<List<File>> callback, Runnable dragDropped) {
        node.setOnDragOver(event -> {
            if (event.getGestureSource() != node && event.getDragboard().hasFiles()) {
                if (event.getDragboard().getFiles().stream().anyMatch(filter::accept)) {
                    event.acceptTransferModes(TransferMode.COPY_OR_MOVE);
                }
            }
            event.consume();
        });
        node.setOnDragDropped(event -> {
            List files = event.getDragboard().getFiles();
            if (files != null) {
                List acceptFiles = files.stream().filter(filter::accept).collect(Collectors.toList());
                if (!acceptFiles.isEmpty()) {
                    callback.accept(acceptFiles);
                    event.setDropCompleted(true);
                }
            }
            if (dragDropped != null) {
                dragDropped.run();
            }
            event.consume();
        });
    }

    public static <T> StringConverter<T> stringConverter(final Function<T, String> func) {
        return new StringConverter<T>(){

            public String toString(T object) {
                return object == null ? "" : (String)func.apply(object);
            }

            public T fromString(String string) {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static <T> Callback<ListView<T>, ListCell<T>> jfxListCellFactory(final Function<T, Node> graphicBuilder) {
        final Holder lastCell = new Holder();
        return view -> new JFXListCell<T>(){

            @Override
            public void updateItem(T item, boolean empty) {
                super.updateItem(item, empty);
                if (this == lastCell.value && !this.isVisible()) {
                    return;
                }
                lastCell.value = this;
                if (!empty) {
                    this.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
                    this.setGraphic((Node)graphicBuilder.apply(item));
                }
            }
        };
    }

    public static ColumnConstraints getColumnFillingWidth() {
        ColumnConstraints constraint = new ColumnConstraints();
        constraint.setFillWidth(true);
        return constraint;
    }

    public static ColumnConstraints getColumnHgrowing() {
        ColumnConstraints constraint = new ColumnConstraints();
        constraint.setFillWidth(true);
        constraint.setHgrow(Priority.ALWAYS);
        return constraint;
    }

    public static void onEscPressed(Node node, Runnable action) {
        node.addEventHandler(KeyEvent.KEY_PRESSED, e -> {
            if (e.getCode() == KeyCode.ESCAPE) {
                action.run();
                e.consume();
            }
        });
    }

    public static void copyText(String text) {
        ClipboardContent content = new ClipboardContent();
        content.putString(text);
        Clipboard.getSystemClipboard().setContent((Map)content);
        if (!Controllers.isStopped()) {
            Controllers.showToast(I18n.i18n("message.copied"));
        }
    }

    public static List<Node> parseSegment(String segment, Consumer<String> hyperlinkAction) {
        if (segment.indexOf(60) < 0) {
            return Collections.singletonList(new Text(segment));
        }
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(new InputSource(new StringReader("<body>" + segment + "</body>")));
            Element r = doc.getDocumentElement();
            NodeList children = r.getChildNodes();
            ArrayList<Node> texts = new ArrayList<Node>();
            for (int i = 0; i < children.getLength(); ++i) {
                org.w3c.dom.Node node = children.item(i);
                if (node instanceof Element) {
                    Element element = (Element)node;
                    if ("a".equals(element.getTagName())) {
                        String href = element.getAttribute("href");
                        JFXHyperlink hyperlink = new JFXHyperlink(element.getTextContent());
                        hyperlink.setOnAction(e -> {
                            String link = href;
                            try {
                                link = new URI(href).toASCIIString();
                            }
                            catch (URISyntaxException uRISyntaxException) {
                                // empty catch block
                            }
                            hyperlinkAction.accept(link);
                        });
                        texts.add((Node)hyperlink);
                        continue;
                    }
                    if ("b".equals(element.getTagName())) {
                        Text text = new Text(element.getTextContent());
                        text.getStyleClass().add((Object)"bold");
                        texts.add((Node)text);
                        continue;
                    }
                    if ("br".equals(element.getTagName())) {
                        texts.add((Node)new Text("\n"));
                        continue;
                    }
                    throw new IllegalArgumentException("unsupported tag " + element.getTagName());
                }
                texts.add((Node)new Text(node.getTextContent()));
            }
            return texts;
        }
        catch (IOException | ParserConfigurationException | SAXException e2) {
            Logger.LOG.warning("Failed to parse xml", e2);
            return Collections.singletonList(new Text(segment));
        }
    }

    public static TextFlow segmentToTextFlow(String segment, Consumer<String> hyperlinkAction) {
        TextFlow tf = new TextFlow();
        tf.getChildren().setAll(FXUtils.parseSegment(segment, hyperlinkAction));
        return tf;
    }

    private static class ListenerPair<T> {
        private final ObservableValue<T> value;
        private final ChangeListener<? super T> listener;

        ListenerPair(ObservableValue<T> value, ChangeListener<? super T> listener) {
            this.value = value;
            this.listener = listener;
        }

        void bind() {
            this.value.addListener(this.listener);
        }

        void unbind() {
            this.value.removeListener(this.listener);
        }
    }

    private static final class TextFieldBindingListener<T>
    implements ChangeListener<Boolean>,
    InvalidationListener {
        private final int hashCode;
        private final WeakReference<JFXTextField> textFieldRef;
        private final WeakReference<Property<T>> propertyRef;
        private final StringConverter<T> converter;

        TextFieldBindingListener(JFXTextField textField, Property<T> property, StringConverter<T> converter) {
            this.textFieldRef = new WeakReference<JFXTextField>(textField);
            this.propertyRef = new WeakReference<Property<Property<T>>>(property);
            this.converter = converter;
            this.hashCode = System.identityHashCode((Object)textField) ^ System.identityHashCode(property);
        }

        public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean focused) {
            JFXTextField textField = (JFXTextField)((Object)this.textFieldRef.get());
            Property property = (Property)this.propertyRef.get();
            if (textField != null && property != null && oldValue == Boolean.TRUE && focused == Boolean.FALSE) {
                if (textField.validate()) {
                    String newValue;
                    String newText = textField.getText();
                    String string = newValue = this.converter == null ? newText : this.converter.fromString(newText);
                    if (!Objects.equals(newValue, property.getValue())) {
                        property.setValue((Object)newValue);
                    }
                } else {
                    this.invalidated(null);
                }
            }
        }

        public void invalidated(Observable observable) {
            JFXTextField textField = (JFXTextField)((Object)this.textFieldRef.get());
            Property property = (Property)this.propertyRef.get();
            if (textField != null && property != null) {
                Object value = property.getValue();
                textField.setText(this.converter == null ? (String)value : this.converter.toString(value));
            }
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof TextFieldBindingListener)) {
                return false;
            }
            TextFieldBindingListener other = (TextFieldBindingListener)obj;
            return this.hashCode == other.hashCode && this.textFieldRef.get() == other.textFieldRef.get() && this.propertyRef.get() == other.propertyRef.get();
        }
    }
}

