/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui;

import com.jfoenix.controls.JFXProgressBar;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.StackPane;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebView;
import javafx.stage.Stage;
import org.jackhuang.hmcl.Metadata;
import org.jackhuang.hmcl.setting.ConfigHolder;
import org.jackhuang.hmcl.setting.Theme;
import org.jackhuang.hmcl.ui.FXUtils;

public class WebStage
extends Stage {
    protected final StackPane pane = new StackPane();
    protected final JFXProgressBar progressBar = new JFXProgressBar();
    protected final WebView webView = new WebView();
    protected final WebEngine webEngine = this.webView.getEngine();

    public WebStage() {
        this(800, 480);
    }

    public WebStage(int width, int height) {
        this.setScene(new Scene((Parent)this.pane, (double)width, (double)height));
        this.getScene().getStylesheets().addAll((Object[])Theme.getTheme().getStylesheets(ConfigHolder.config().getLauncherFontFamily()));
        FXUtils.setIcon(this);
        this.webView.getEngine().setUserDataDirectory(Metadata.HMCL_DIRECTORY.toFile());
        this.webView.setContextMenuEnabled(false);
        this.progressBar.progressProperty().bind((ObservableValue)this.webView.getEngine().getLoadWorker().progressProperty());
        this.progressBar.visibleProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> {
            switch (this.webView.getEngine().getLoadWorker().getState()) {
                case SUCCEEDED: 
                case FAILED: 
                case CANCELLED: {
                    return false;
                }
            }
            return true;
        }, (Observable[])new Observable[]{this.webEngine.getLoadWorker().stateProperty()}));
        BorderPane borderPane = new BorderPane();
        borderPane.setPickOnBounds(false);
        borderPane.setTop((Node)this.progressBar);
        this.progressBar.prefWidthProperty().bind((ObservableValue)borderPane.widthProperty());
        this.pane.getChildren().setAll((Object[])new Node[]{this.webView, borderPane});
    }

    public WebView getWebView() {
        return this.webView;
    }
}

