/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.account;

import com.jfoenix.controls.JFXButton;
import com.jfoenix.controls.JFXRadioButton;
import com.jfoenix.effects.JFXDepthManager;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.SkinBase;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Paint;
import org.jackhuang.hmcl.auth.Account;
import org.jackhuang.hmcl.auth.authlibinjector.AuthlibInjectorAccount;
import org.jackhuang.hmcl.auth.authlibinjector.AuthlibInjectorServer;
import org.jackhuang.hmcl.game.TexturesLoader;
import org.jackhuang.hmcl.setting.Accounts;
import org.jackhuang.hmcl.setting.Theme;
import org.jackhuang.hmcl.task.Schedulers;
import org.jackhuang.hmcl.task.Task;
import org.jackhuang.hmcl.ui.Controllers;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.SVG;
import org.jackhuang.hmcl.ui.account.AccountListItem;
import org.jackhuang.hmcl.ui.construct.SpinnerPane;
import org.jackhuang.hmcl.util.i18n.I18n;
import org.jackhuang.hmcl.util.javafx.BindingMapping;

public class AccountListItemSkin
extends SkinBase<AccountListItem> {
    public AccountListItemSkin(final AccountListItem skinnable) {
        super((Control)skinnable);
        BorderPane root = new BorderPane();
        JFXRadioButton chkSelected = new JFXRadioButton(){

            public void fire() {
                skinnable.fire();
            }
        };
        BorderPane.setAlignment((Node)chkSelected, (Pos)Pos.CENTER);
        chkSelected.selectedProperty().bind((ObservableValue)skinnable.selectedProperty());
        root.setLeft((Node)chkSelected);
        HBox center = new HBox();
        center.setSpacing(8.0);
        center.setAlignment(Pos.CENTER_LEFT);
        Canvas canvas = new Canvas(32.0, 32.0);
        TexturesLoader.bindAvatar(canvas, skinnable.getAccount());
        Label title = new Label();
        title.getStyleClass().add((Object)"title");
        title.textProperty().bind((ObservableValue)skinnable.titleProperty());
        Label subtitle = new Label();
        subtitle.getStyleClass().add((Object)"subtitle");
        subtitle.textProperty().bind((ObservableValue)skinnable.subtitleProperty());
        if (skinnable.getAccount() instanceof AuthlibInjectorAccount) {
            Tooltip tooltip = new Tooltip();
            AuthlibInjectorServer server = ((AuthlibInjectorAccount)skinnable.getAccount()).getServer();
            tooltip.textProperty().bind(BindingMapping.of(server, AuthlibInjectorServer::toString));
            FXUtils.installSlowTooltip((Node)subtitle, tooltip);
        }
        VBox item = new VBox(new Node[]{title, subtitle});
        item.getStyleClass().add((Object)"two-line-list-item");
        BorderPane.setAlignment((Node)item, (Pos)Pos.CENTER);
        center.getChildren().setAll((Object[])new Node[]{canvas, item});
        root.setCenter((Node)center);
        HBox right = new HBox();
        right.setAlignment(Pos.CENTER_RIGHT);
        JFXButton btnMove = new JFXButton();
        SpinnerPane spinnerMove = new SpinnerPane();
        spinnerMove.getStyleClass().add((Object)"small-spinner-pane");
        btnMove.setOnMouseClicked(e -> {
            Account account = skinnable.getAccount();
            Accounts.getAccounts().remove((Object)account);
            if (account.isPortable()) {
                account.setPortable(false);
                if (!Accounts.getAccounts().contains((Object)account)) {
                    Accounts.getAccounts().add((Object)account);
                }
            } else {
                account.setPortable(true);
                if (!Accounts.getAccounts().contains((Object)account)) {
                    int idx = 0;
                    for (int i = Accounts.getAccounts().size() - 1; i >= 0; --i) {
                        if (!((Account)Accounts.getAccounts().get(i)).isPortable()) continue;
                        idx = i + 1;
                        break;
                    }
                    Accounts.getAccounts().add(idx, (Object)account);
                }
            }
        });
        btnMove.getStyleClass().add((Object)"toggle-icon4");
        if (skinnable.getAccount().isPortable()) {
            btnMove.setGraphic(SVG.EARTH.createIcon((Paint)Theme.blackFill(), -1.0, -1.0));
            FXUtils.runInFX(() -> FXUtils.installFastTooltip((Node)btnMove, I18n.i18n("account.move_to_global")));
        } else {
            btnMove.setGraphic(SVG.EXPORT.createIcon((Paint)Theme.blackFill(), -1.0, -1.0));
            FXUtils.runInFX(() -> FXUtils.installFastTooltip((Node)btnMove, I18n.i18n("account.move_to_portable")));
        }
        spinnerMove.setContent((Node)btnMove);
        right.getChildren().add((Object)spinnerMove);
        JFXButton btnRefresh = new JFXButton();
        SpinnerPane spinnerRefresh = new SpinnerPane();
        spinnerRefresh.getStyleClass().setAll((Object[])new String[]{"small-spinner-pane"});
        btnRefresh.setOnMouseClicked(e -> {
            spinnerRefresh.showSpinner();
            skinnable.refreshAsync().whenComplete(Schedulers.javafx(), ex -> {
                spinnerRefresh.hideSpinner();
                if (ex != null) {
                    Controllers.showToast(Accounts.localizeErrorMessage(ex));
                }
            }).start();
        });
        btnRefresh.getStyleClass().add((Object)"toggle-icon4");
        btnRefresh.setGraphic(SVG.REFRESH.createIcon((Paint)Theme.blackFill(), -1.0, -1.0));
        FXUtils.runInFX(() -> FXUtils.installFastTooltip((Node)btnRefresh, I18n.i18n("button.refresh")));
        spinnerRefresh.setContent((Node)btnRefresh);
        right.getChildren().add((Object)spinnerRefresh);
        JFXButton btnUpload = new JFXButton();
        SpinnerPane spinnerUpload = new SpinnerPane();
        btnUpload.setOnMouseClicked(e -> {
            Task<?> uploadTask = skinnable.uploadSkin();
            if (uploadTask != null) {
                spinnerUpload.showSpinner();
                uploadTask.whenComplete(Schedulers.javafx(), ex -> spinnerUpload.hideSpinner()).start();
            }
        });
        btnUpload.getStyleClass().add((Object)"toggle-icon4");
        btnUpload.setGraphic(SVG.HANGER.createIcon((Paint)Theme.blackFill(), -1.0, -1.0));
        FXUtils.runInFX(() -> FXUtils.installFastTooltip((Node)btnUpload, I18n.i18n("account.skin.upload")));
        spinnerUpload.managedProperty().bind((ObservableValue)spinnerUpload.visibleProperty());
        spinnerUpload.visibleProperty().bind((ObservableValue)skinnable.canUploadSkin());
        spinnerUpload.setContent((Node)btnUpload);
        spinnerUpload.getStyleClass().add((Object)"small-spinner-pane");
        right.getChildren().add((Object)spinnerUpload);
        JFXButton btnCopyUUID = new JFXButton();
        SpinnerPane spinnerCopyUUID = new SpinnerPane();
        spinnerCopyUUID.getStyleClass().add((Object)"small-spinner-pane");
        btnCopyUUID.setOnMouseClicked(e -> FXUtils.copyText(skinnable.getAccount().getUUID().toString()));
        btnCopyUUID.setGraphic(SVG.COPY.createIcon((Paint)Theme.blackFill(), -1.0, -1.0));
        FXUtils.runInFX(() -> FXUtils.installFastTooltip((Node)btnCopyUUID, I18n.i18n("account.copy_uuid")));
        spinnerCopyUUID.setContent((Node)btnCopyUUID);
        right.getChildren().add((Object)spinnerCopyUUID);
        JFXButton btnRemove = new JFXButton();
        btnRemove.setOnMouseClicked(e -> skinnable.remove());
        btnRemove.getStyleClass().add((Object)"toggle-icon4");
        BorderPane.setAlignment((Node)btnRemove, (Pos)Pos.CENTER);
        btnRemove.setGraphic(SVG.DELETE.createIcon((Paint)Theme.blackFill(), -1.0, -1.0));
        FXUtils.runInFX(() -> FXUtils.installFastTooltip((Node)btnRemove, I18n.i18n("button.delete")));
        right.getChildren().add((Object)btnRemove);
        root.setRight((Node)right);
        root.getStyleClass().add((Object)"card");
        root.setStyle("-fx-padding: 8 8 8 0;");
        JFXDepthManager.setDepth((Node)root, 1);
        this.getChildren().setAll((Object[])new Node[]{root});
    }
}

