/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.account;

import com.jfoenix.controls.JFXButton;
import com.jfoenix.controls.JFXComboBox;
import com.jfoenix.controls.JFXDialogLayout;
import com.jfoenix.controls.JFXPasswordField;
import com.jfoenix.controls.JFXTextField;
import com.jfoenix.validation.base.ValidatorBase;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.regex.Pattern;
import javafx.application.Platform;
import javafx.beans.NamedArg;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.Label;
import javafx.scene.control.SingleSelectionModel;
import javafx.scene.control.TextInputControl;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Paint;
import org.jackhuang.hmcl.auth.AccountFactory;
import org.jackhuang.hmcl.auth.CharacterSelector;
import org.jackhuang.hmcl.auth.NoSelectedCharacterException;
import org.jackhuang.hmcl.auth.authlibinjector.AuthlibInjectorAccountFactory;
import org.jackhuang.hmcl.auth.authlibinjector.AuthlibInjectorServer;
import org.jackhuang.hmcl.auth.authlibinjector.BoundAuthlibInjectorAccountFactory;
import org.jackhuang.hmcl.auth.microsoft.MicrosoftAccountFactory;
import org.jackhuang.hmcl.auth.offline.OfflineAccountFactory;
import org.jackhuang.hmcl.auth.yggdrasil.GameProfile;
import org.jackhuang.hmcl.auth.yggdrasil.YggdrasilService;
import org.jackhuang.hmcl.game.OAuthServer;
import org.jackhuang.hmcl.game.TexturesLoader;
import org.jackhuang.hmcl.setting.Accounts;
import org.jackhuang.hmcl.setting.ConfigHolder;
import org.jackhuang.hmcl.setting.Theme;
import org.jackhuang.hmcl.task.Schedulers;
import org.jackhuang.hmcl.task.Task;
import org.jackhuang.hmcl.task.TaskExecutor;
import org.jackhuang.hmcl.ui.Controllers;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.SVG;
import org.jackhuang.hmcl.ui.WeakListenerHolder;
import org.jackhuang.hmcl.ui.account.AddAuthlibInjectorServerPane;
import org.jackhuang.hmcl.ui.construct.AdvancedListBox;
import org.jackhuang.hmcl.ui.construct.DialogAware;
import org.jackhuang.hmcl.ui.construct.DialogCloseEvent;
import org.jackhuang.hmcl.ui.construct.HintPane;
import org.jackhuang.hmcl.ui.construct.IconedItem;
import org.jackhuang.hmcl.ui.construct.JFXHyperlink;
import org.jackhuang.hmcl.ui.construct.MenuUpDownButton;
import org.jackhuang.hmcl.ui.construct.MessageDialogPane;
import org.jackhuang.hmcl.ui.construct.RequiredValidator;
import org.jackhuang.hmcl.ui.construct.SpinnerPane;
import org.jackhuang.hmcl.ui.construct.TabControl;
import org.jackhuang.hmcl.ui.construct.TabHeader;
import org.jackhuang.hmcl.ui.construct.TwoLineListItem;
import org.jackhuang.hmcl.ui.construct.Validator;
import org.jackhuang.hmcl.upgrade.IntegrityChecker;
import org.jackhuang.hmcl.util.StringUtils;
import org.jackhuang.hmcl.util.gson.UUIDTypeAdapter;
import org.jackhuang.hmcl.util.i18n.I18n;
import org.jackhuang.hmcl.util.javafx.BindingMapping;
import org.jackhuang.hmcl.util.javafx.ExtendedProperties;
import org.jetbrains.annotations.Nullable;

public class CreateAccountPane
extends JFXDialogLayout
implements DialogAware {
    private static final Pattern USERNAME_CHECKER_PATTERN = Pattern.compile("^[A-Za-z0-9_]+$");
    private boolean showMethodSwitcher;
    private AccountFactory<?> factory;
    private final Label lblErrorMessage;
    private final JFXButton btnAccept;
    private final SpinnerPane spinner;
    private final Node body;
    private Node detailsPane;
    private final Pane detailsContainer;
    private final BooleanProperty logging = new SimpleBooleanProperty();
    private final ObjectProperty<OAuthServer.GrantDeviceCodeEvent> deviceCode = new SimpleObjectProperty();
    private final WeakListenerHolder holder = new WeakListenerHolder();
    private TaskExecutor loginTask;
    private static final String MICROSOFT_ACCOUNT_EDIT_PROFILE_URL = "https://support.microsoft.com/account-billing/837badbc-999e-54d2-2617-d19206b9540a";

    public CreateAccountPane() {
        this((AccountFactory)null);
    }

    public CreateAccountPane(AccountFactory<?> factory) {
        if (factory == null) {
            this.showMethodSwitcher = true;
            String preferred = ConfigHolder.config().getPreferredLoginType();
            try {
                factory = Accounts.getAccountFactory(preferred);
            }
            catch (IllegalArgumentException e2) {
                factory = Accounts.FACTORY_OFFLINE;
            }
        } else {
            this.showMethodSwitcher = false;
        }
        this.factory = factory;
        String title = this.showMethodSwitcher ? "account.create" : "account.create." + Accounts.getLoginType(factory);
        this.setHeading(new Node[]{new Label(I18n.i18n(title))});
        this.lblErrorMessage = new Label();
        this.lblErrorMessage.setWrapText(true);
        this.lblErrorMessage.setMaxWidth(400.0);
        this.btnAccept = new JFXButton(I18n.i18n("account.login"));
        this.btnAccept.getStyleClass().add((Object)"dialog-accept");
        this.btnAccept.setOnAction(e -> this.onAccept());
        this.spinner = new SpinnerPane();
        this.spinner.getStyleClass().add((Object)"small-spinner-pane");
        this.spinner.setContent((Node)this.btnAccept);
        JFXButton btnCancel = new JFXButton(I18n.i18n("button.cancel"));
        btnCancel.getStyleClass().add((Object)"dialog-cancel");
        btnCancel.setOnAction(e -> this.onCancel());
        FXUtils.onEscPressed((Node)this, () -> ((JFXButton)btnCancel).fire());
        HBox hbox = new HBox(new Node[]{this.spinner, btnCancel});
        hbox.setAlignment(Pos.CENTER_RIGHT);
        this.setActions(new Node[]{this.lblErrorMessage, hbox});
        if (this.showMethodSwitcher) {
            TabControl.Tab[] tabs = new TabControl.Tab[Accounts.FACTORIES.size()];
            TabControl.Tab selected = null;
            for (int i = 0; i < tabs.length; ++i) {
                AccountFactory<?> f = Accounts.FACTORIES.get(i);
                tabs[i] = new TabControl.Tab(Accounts.getLoginType(f), Accounts.getLocalizedLoginTypeName(f));
                tabs[i].setUserData(f);
                if (factory != f) continue;
                selected = tabs[i];
            }
            TabHeader tabHeader = new TabHeader(tabs);
            tabHeader.getStyleClass().add((Object)"add-account-tab-header");
            tabHeader.setMinWidth(Double.NEGATIVE_INFINITY);
            tabHeader.setMaxWidth(Double.NEGATIVE_INFINITY);
            tabHeader.getSelectionModel().select(selected);
            FXUtils.onChange(tabHeader.getSelectionModel().selectedItemProperty(), newItem -> {
                if (newItem == null) {
                    return;
                }
                AccountFactory newMethod = (AccountFactory)newItem.getUserData();
                ConfigHolder.config().setPreferredLoginType(Accounts.getLoginType(newMethod));
                this.factory = newMethod;
                this.initDetailsPane();
            });
            this.detailsContainer = new StackPane();
            this.detailsContainer.setPadding(new Insets(15.0, 0.0, 0.0, 0.0));
            VBox boxBody = new VBox(new Node[]{tabHeader, this.detailsContainer});
            boxBody.setAlignment(Pos.CENTER);
            this.body = boxBody;
            this.setBody(this.body);
        } else {
            this.detailsContainer = new StackPane();
            this.detailsContainer.setPadding(new Insets(10.0, 0.0, 0.0, 0.0));
            this.body = this.detailsContainer;
            this.setBody(this.body);
        }
        this.initDetailsPane();
        this.setPrefWidth(560.0);
    }

    public CreateAccountPane(AuthlibInjectorServer authServer) {
        this(Accounts.getAccountFactoryByAuthlibInjectorServer(authServer));
    }

    private void onAccept() {
        Object additionalData;
        String password;
        String username;
        this.spinner.showSpinner();
        this.lblErrorMessage.setText("");
        if (!(this.factory instanceof MicrosoftAccountFactory)) {
            this.body.setDisable(true);
        }
        if (this.detailsPane instanceof AccountDetailsInputPane) {
            AccountDetailsInputPane details = (AccountDetailsInputPane)this.detailsPane;
            username = details.getUsername();
            password = details.getPassword();
            additionalData = details.getAdditionalData();
        } else {
            username = null;
            password = null;
            additionalData = null;
        }
        Runnable doCreate = () -> {
            this.logging.set(true);
            this.deviceCode.set(null);
            this.loginTask = Task.supplyAsync(() -> this.factory.create(new DialogCharacterSelector(), username, password, null, additionalData)).whenComplete(Schedulers.javafx(), account -> {
                int oldIndex = Accounts.getAccounts().indexOf(account);
                if (oldIndex == -1) {
                    Accounts.getAccounts().add(account);
                } else {
                    Accounts.getAccounts().remove(oldIndex);
                    Accounts.getAccounts().add(oldIndex, account);
                }
                Accounts.setSelectedAccount(account);
                this.spinner.hideSpinner();
                this.fireEvent(new DialogCloseEvent());
            }, exception -> {
                if (exception instanceof NoSelectedCharacterException) {
                    this.fireEvent(new DialogCloseEvent());
                } else {
                    this.lblErrorMessage.setText(Accounts.localizeErrorMessage(exception));
                }
                this.body.setDisable(false);
                this.spinner.hideSpinner();
            }).executor(true);
        };
        if (this.factory instanceof OfflineAccountFactory && username != null && !USERNAME_CHECKER_PATTERN.matcher(username).matches()) {
            Controllers.confirm(I18n.i18n("account.methods.offline.name.invalid"), I18n.i18n("message.warning"), MessageDialogPane.MessageType.WARNING, doCreate, () -> {
                this.lblErrorMessage.setText(I18n.i18n("account.methods.offline.name.invalid"));
                this.body.setDisable(false);
                this.spinner.hideSpinner();
            });
        } else {
            doCreate.run();
        }
    }

    private void onCancel() {
        if (this.loginTask != null) {
            this.loginTask.cancel();
        }
        this.fireEvent(new DialogCloseEvent());
    }

    private void initDetailsPane() {
        if (this.detailsPane != null) {
            this.btnAccept.disableProperty().unbind();
            this.detailsContainer.getChildren().remove((Object)this.detailsPane);
            this.lblErrorMessage.setText("");
        }
        if (this.factory == Accounts.FACTORY_MICROSOFT) {
            VBox vbox = new VBox(8.0);
            if (!Accounts.OAUTH_CALLBACK.getClientId().isEmpty()) {
                HintPane hintPane = new HintPane(MessageDialogPane.MessageType.INFO);
                FXUtils.onChangeAndOperate(this.deviceCode, deviceCode -> {
                    if (deviceCode != null) {
                        FXUtils.copyText(deviceCode.getUserCode());
                        hintPane.setSegment(I18n.i18n("account.methods.microsoft.manual", deviceCode.getUserCode(), deviceCode.getVerificationUri()));
                    } else {
                        hintPane.setSegment(I18n.i18n("account.methods.microsoft.hint"));
                    }
                });
                hintPane.setOnMouseClicked(e -> {
                    if (this.deviceCode.get() != null) {
                        FXUtils.copyText(((OAuthServer.GrantDeviceCodeEvent)this.deviceCode.get()).getUserCode());
                    }
                });
                this.holder.add(Accounts.OAUTH_CALLBACK.onGrantDeviceCode.registerWeak(value -> FXUtils.runInFX(() -> this.deviceCode.set(value))));
                FlowPane box = new FlowPane();
                box.setHgap(8.0);
                JFXHyperlink birthLink = new JFXHyperlink(I18n.i18n("account.methods.microsoft.birth"));
                birthLink.setExternalLink(MICROSOFT_ACCOUNT_EDIT_PROFILE_URL);
                JFXHyperlink profileLink = new JFXHyperlink(I18n.i18n("account.methods.microsoft.profile"));
                profileLink.setExternalLink("https://account.live.com/editprof.aspx");
                JFXHyperlink purchaseLink = new JFXHyperlink(I18n.i18n("account.methods.microsoft.purchase"));
                purchaseLink.setExternalLink("https://www.microsoft.com/store/productId/9NXP44L49SHJ");
                JFXHyperlink deauthorizeLink = new JFXHyperlink(I18n.i18n("account.methods.microsoft.deauthorize"));
                deauthorizeLink.setExternalLink("https://account.live.com/consent/Edit?client_id=000000004C794E0A");
                JFXHyperlink forgotpasswordLink = new JFXHyperlink(I18n.i18n("account.methods.forgot_password"));
                forgotpasswordLink.setExternalLink("https://www.minecraft.net/password/forgot");
                JFXHyperlink createProfileLink = new JFXHyperlink(I18n.i18n("account.methods.microsoft.makegameidsettings"));
                createProfileLink.setExternalLink("https://www.minecraft.net/msaprofile/mygames/editprofile");
                box.getChildren().setAll((Object[])new Node[]{profileLink, birthLink, purchaseLink, deauthorizeLink, forgotpasswordLink, createProfileLink});
                GridPane.setColumnSpan((Node)box, (Integer)2);
                if (!IntegrityChecker.isOfficial()) {
                    HintPane unofficialHint = new HintPane(MessageDialogPane.MessageType.WARNING);
                    unofficialHint.setText(I18n.i18n("unofficial.hint"));
                    vbox.getChildren().add((Object)unofficialHint);
                }
                vbox.getChildren().addAll((Object[])new Node[]{hintPane, box});
                this.btnAccept.setDisable(false);
            } else {
                HintPane hintPane = new HintPane(MessageDialogPane.MessageType.WARNING);
                hintPane.setSegment(I18n.i18n("account.methods.microsoft.snapshot"));
                JFXHyperlink officialWebsite = new JFXHyperlink(I18n.i18n("account.methods.microsoft.snapshot.website"));
                officialWebsite.setExternalLink("https://hmcl.huangyuhui.net");
                vbox.getChildren().setAll((Object[])new Node[]{hintPane, officialWebsite});
                this.btnAccept.setDisable(true);
            }
            this.detailsPane = vbox;
        } else {
            this.detailsPane = new AccountDetailsInputPane(this.factory, () -> ((JFXButton)this.btnAccept).fire());
            this.btnAccept.disableProperty().bind((ObservableValue)((AccountDetailsInputPane)this.detailsPane).validProperty().not());
        }
        this.detailsContainer.getChildren().add((Object)this.detailsPane);
    }

    @Override
    public void onDialogShown() {
        if (this.detailsPane instanceof AccountDetailsInputPane) {
            ((AccountDetailsInputPane)this.detailsPane).focus();
        }
    }

    private static class AccountDetailsInputPane
    extends GridPane {
        private static final String[] ALLOWED_LINKS = new String[]{"homepage", "register"};
        private final AccountFactory<?> factory;
        @Nullable
        private AuthlibInjectorServer server;
        @Nullable
        private JFXComboBox<AuthlibInjectorServer> cboServers;
        @Nullable
        private JFXTextField txtUsername;
        @Nullable
        private JFXPasswordField txtPassword;
        @Nullable
        private JFXTextField txtUUID;
        private final BooleanBinding valid;

        private static List<Hyperlink> createHyperlinks(AuthlibInjectorServer server) {
            if (server == null) {
                return Collections.emptyList();
            }
            Map<String, String> links = server.getLinks();
            ArrayList<Hyperlink> result = new ArrayList<Hyperlink>();
            for (String key : ALLOWED_LINKS) {
                String value = links.get(key);
                if (value == null) continue;
                Hyperlink link = new Hyperlink(I18n.i18n("account.injector.link." + key));
                FXUtils.installSlowTooltip((Node)link, value);
                link.setOnAction(e -> FXUtils.openLink(value));
                result.add(link);
            }
            return Collections.unmodifiableList(result);
        }

        public AccountDetailsInputPane(AccountFactory<?> factory, Runnable onAction) {
            HBox linksContainer;
            Label lblServers;
            this.factory = factory;
            this.setVgap(22.0);
            this.setHgap(15.0);
            this.setAlignment(Pos.CENTER);
            ColumnConstraints col0 = new ColumnConstraints();
            col0.setMinWidth(Double.NEGATIVE_INFINITY);
            this.getColumnConstraints().add((Object)col0);
            ColumnConstraints col1 = new ColumnConstraints();
            col1.setHgrow(Priority.ALWAYS);
            this.getColumnConstraints().add((Object)col1);
            int rowIndex = 0;
            if (!IntegrityChecker.isOfficial() && !(factory instanceof OfflineAccountFactory)) {
                HintPane hintPane = new HintPane(MessageDialogPane.MessageType.WARNING);
                hintPane.setSegment(I18n.i18n("unofficial.hint"));
                GridPane.setColumnSpan((Node)hintPane, (Integer)2);
                this.add((Node)hintPane, 0, rowIndex);
                ++rowIndex;
            }
            if (factory instanceof BoundAuthlibInjectorAccountFactory) {
                this.server = ((BoundAuthlibInjectorAccountFactory)factory).getServer();
                lblServers = new Label(I18n.i18n("account.injector.server"));
                AccountDetailsInputPane.setHalignment((Node)lblServers, (HPos)HPos.LEFT);
                this.add((Node)lblServers, 0, rowIndex);
                Label lblServerName = new Label(this.server.getName());
                lblServerName.setMaxWidth(Double.MAX_VALUE);
                HBox.setHgrow((Node)lblServerName, (Priority)Priority.ALWAYS);
                linksContainer = new HBox();
                linksContainer.setAlignment(Pos.CENTER);
                linksContainer.getChildren().setAll(AccountDetailsInputPane.createHyperlinks(this.server));
                linksContainer.setMinWidth(Double.NEGATIVE_INFINITY);
                HBox boxServers = new HBox(new Node[]{lblServerName, linksContainer});
                boxServers.setAlignment(Pos.CENTER_LEFT);
                this.add((Node)boxServers, 1, rowIndex);
                ++rowIndex;
            } else if (factory instanceof AuthlibInjectorAccountFactory) {
                lblServers = new Label(I18n.i18n("account.injector.server"));
                AccountDetailsInputPane.setHalignment((Node)lblServers, (HPos)HPos.LEFT);
                this.add((Node)lblServers, 0, rowIndex);
                this.cboServers = new JFXComboBox();
                this.cboServers.setCellFactory(FXUtils.jfxListCellFactory(server -> new TwoLineListItem(server.getName(), server.getUrl())));
                this.cboServers.setConverter(FXUtils.stringConverter(AuthlibInjectorServer::getName));
                Bindings.bindContent((List)this.cboServers.getItems(), ConfigHolder.config().getAuthlibInjectorServers());
                this.cboServers.getItems().addListener(FXUtils.onInvalidating(() -> Platform.runLater(() -> ((SingleSelectionModel)this.cboServers.getSelectionModel()).selectFirst())));
                this.cboServers.getSelectionModel().selectFirst();
                this.cboServers.setPromptText(I18n.i18n("account.injector.empty"));
                BooleanBinding noServers = Bindings.createBooleanBinding(() -> this.cboServers.getItems().isEmpty(), (Observable[])new Observable[]{this.cboServers.getItems()});
                ExtendedProperties.classPropertyFor(this.cboServers, "jfx-combo-box-warning").bind((ObservableValue)noServers);
                ExtendedProperties.classPropertyFor(this.cboServers, "jfx-combo-box").bind((ObservableValue)noServers.not());
                HBox.setHgrow(this.cboServers, (Priority)Priority.ALWAYS);
                HBox.setMargin(this.cboServers, (Insets)new Insets(0.0, 10.0, 0.0, 0.0));
                this.cboServers.setMaxWidth(Double.MAX_VALUE);
                linksContainer = new HBox();
                linksContainer.setAlignment(Pos.CENTER);
                FXUtils.onChangeAndOperate(this.cboServers.valueProperty(), server -> {
                    this.server = server;
                    linksContainer.getChildren().setAll(AccountDetailsInputPane.createHyperlinks(server));
                });
                linksContainer.setMinWidth(Double.NEGATIVE_INFINITY);
                JFXButton btnAddServer = new JFXButton();
                btnAddServer.setGraphic(SVG.PLUS.createIcon((Paint)Theme.blackFill(), 20.0, 20.0));
                btnAddServer.getStyleClass().add((Object)"toggle-icon4");
                btnAddServer.setOnAction(e -> Controllers.dialog((Region)new AddAuthlibInjectorServerPane()));
                HBox boxServers = new HBox(new Node[]{this.cboServers, linksContainer, btnAddServer});
                this.add((Node)boxServers, 1, rowIndex);
                ++rowIndex;
            }
            if (factory.getLoginType().requiresUsername) {
                Label lblUsername = new Label(I18n.i18n("account.username"));
                AccountDetailsInputPane.setHalignment((Node)lblUsername, (HPos)HPos.LEFT);
                this.add((Node)lblUsername, 0, rowIndex);
                this.txtUsername = new JFXTextField();
                this.txtUsername.setValidators(new RequiredValidator(), new Validator(I18n.i18n("input.email"), username -> {
                    if (this.requiresEmailAsUsername()) {
                        return username.contains("@");
                    }
                    return true;
                }));
                FXUtils.setValidateWhileTextChanged((Node)this.txtUsername, true);
                this.txtUsername.setOnAction(e -> onAction.run());
                this.add((Node)this.txtUsername, 1, rowIndex);
                ++rowIndex;
            }
            if (factory.getLoginType().requiresPassword) {
                Label lblPassword = new Label(I18n.i18n("account.password"));
                AccountDetailsInputPane.setHalignment((Node)lblPassword, (HPos)HPos.LEFT);
                this.add((Node)lblPassword, 0, rowIndex);
                this.txtPassword = new JFXPasswordField();
                this.txtPassword.setValidators(new RequiredValidator());
                FXUtils.setValidateWhileTextChanged((Node)this.txtPassword, true);
                this.txtPassword.setOnAction(e -> onAction.run());
                this.add((Node)this.txtPassword, 1, rowIndex);
                ++rowIndex;
            }
            if (factory instanceof OfflineAccountFactory) {
                this.txtUsername.setPromptText(I18n.i18n("account.methods.offline.name.special_characters"));
                FXUtils.runInFX(() -> FXUtils.installFastTooltip((Node)this.txtUsername, I18n.i18n("account.methods.offline.name.special_characters")));
                JFXHyperlink purchaseLink = new JFXHyperlink(I18n.i18n("account.methods.microsoft.purchase"));
                purchaseLink.setExternalLink("https://www.microsoft.com/store/productId/9NXP44L49SHJ");
                HBox linkPane = new HBox(new Node[]{purchaseLink});
                GridPane.setColumnSpan((Node)linkPane, (Integer)2);
                this.add((Node)linkPane, 0, rowIndex);
                ++rowIndex;
                HBox box = new HBox();
                MenuUpDownButton advancedButton = new MenuUpDownButton();
                box.getChildren().setAll((Object[])new Node[]{advancedButton});
                advancedButton.setText(I18n.i18n("settings.advanced"));
                GridPane.setColumnSpan((Node)box, (Integer)2);
                this.add((Node)box, 0, rowIndex);
                Label lblUUID = new Label(I18n.i18n("account.methods.offline.uuid"));
                lblUUID.managedProperty().bind((ObservableValue)advancedButton.selectedProperty());
                lblUUID.visibleProperty().bind((ObservableValue)advancedButton.selectedProperty());
                AccountDetailsInputPane.setHalignment((Node)lblUUID, (HPos)HPos.LEFT);
                this.add((Node)lblUUID, 0, ++rowIndex);
                this.txtUUID = new JFXTextField();
                this.txtUUID.managedProperty().bind((ObservableValue)advancedButton.selectedProperty());
                this.txtUUID.visibleProperty().bind((ObservableValue)advancedButton.selectedProperty());
                this.txtUUID.setValidators(new UUIDValidator());
                this.txtUUID.promptTextProperty().bind(BindingMapping.of(this.txtUsername.textProperty()).map(name -> OfflineAccountFactory.getUUIDFromUserName(name).toString()));
                this.txtUUID.setOnAction(e -> onAction.run());
                this.add((Node)this.txtUUID, 1, rowIndex);
                ++rowIndex;
                HintPane hintPane = new HintPane(MessageDialogPane.MessageType.WARNING);
                hintPane.managedProperty().bind((ObservableValue)advancedButton.selectedProperty());
                hintPane.visibleProperty().bind((ObservableValue)advancedButton.selectedProperty());
                hintPane.setText(I18n.i18n("account.methods.offline.uuid.hint"));
                GridPane.setColumnSpan((Node)hintPane, (Integer)2);
                this.add((Node)hintPane, 0, rowIndex);
                ++rowIndex;
            }
            this.valid = new BooleanBinding(){
                {
                    if (cboServers != null) {
                        this.bind(new Observable[]{cboServers.valueProperty()});
                    }
                    if (txtUsername != null) {
                        this.bind(new Observable[]{txtUsername.textProperty()});
                    }
                    if (txtPassword != null) {
                        this.bind(new Observable[]{txtPassword.textProperty()});
                    }
                    if (txtUUID != null) {
                        this.bind(new Observable[]{txtUUID.textProperty()});
                    }
                }

                protected boolean computeValue() {
                    if (cboServers != null && cboServers.getValue() == null) {
                        return false;
                    }
                    if (txtUsername != null && !txtUsername.validate()) {
                        return false;
                    }
                    if (txtPassword != null && !txtPassword.validate()) {
                        return false;
                    }
                    return txtUUID == null || txtUUID.validate();
                }
            };
        }

        private boolean requiresEmailAsUsername() {
            if (this.factory instanceof AuthlibInjectorAccountFactory && this.server != null) {
                return !this.server.isNonEmailLogin();
            }
            return false;
        }

        public Object getAdditionalData() {
            if (this.factory instanceof AuthlibInjectorAccountFactory) {
                return this.getAuthServer();
            }
            if (this.factory instanceof OfflineAccountFactory) {
                UUID uuid = this.txtUUID == null ? null : (StringUtils.isBlank(this.txtUUID.getText()) ? null : UUIDTypeAdapter.fromString(this.txtUUID.getText()));
                return new OfflineAccountFactory.AdditionalData(uuid, null);
            }
            return null;
        }

        @Nullable
        public AuthlibInjectorServer getAuthServer() {
            return this.server;
        }

        @Nullable
        public String getUsername() {
            return this.txtUsername == null ? null : this.txtUsername.getText();
        }

        @Nullable
        public String getPassword() {
            return this.txtPassword == null ? null : this.txtPassword.getText();
        }

        public BooleanBinding validProperty() {
            return this.valid;
        }

        public void focus() {
            if (this.txtUsername != null) {
                this.txtUsername.requestFocus();
            }
        }
    }

    private static class DialogCharacterSelector
    extends BorderPane
    implements CharacterSelector {
        private final AdvancedListBox listBox = new AdvancedListBox();
        private final JFXButton cancel = new JFXButton();
        private final CountDownLatch latch = new CountDownLatch(1);
        private GameProfile selectedProfile = null;

        public DialogCharacterSelector() {
            this.setStyle("-fx-padding: 8px;");
            this.cancel.setText(I18n.i18n("button.cancel"));
            StackPane.setAlignment((Node)this.cancel, (Pos)Pos.BOTTOM_RIGHT);
            this.cancel.setOnAction(e -> this.latch.countDown());
            this.listBox.startCategory(I18n.i18n("account.choose"));
            this.setCenter((Node)this.listBox);
            HBox hbox = new HBox();
            hbox.setAlignment(Pos.CENTER_RIGHT);
            hbox.getChildren().add((Object)this.cancel);
            this.setBottom((Node)hbox);
            FXUtils.onEscPressed((Node)this, () -> ((JFXButton)this.cancel).fire());
        }

        @Override
        public GameProfile select(YggdrasilService service, List<GameProfile> profiles) throws NoSelectedCharacterException {
            Platform.runLater(() -> {
                for (GameProfile profile : profiles) {
                    Canvas portraitCanvas = new Canvas(32.0, 32.0);
                    TexturesLoader.bindAvatar(portraitCanvas, service, profile.getId());
                    IconedItem accountItem = new IconedItem((Node)portraitCanvas, profile.getName());
                    accountItem.setOnMouseClicked(e -> {
                        this.selectedProfile = profile;
                        this.latch.countDown();
                    });
                    this.listBox.add((Node)accountItem);
                }
                Controllers.dialog((Region)this);
            });
            try {
                this.latch.await();
                if (this.selectedProfile == null) {
                    throw new NoSelectedCharacterException();
                }
                GameProfile gameProfile = this.selectedProfile;
                return gameProfile;
            }
            catch (InterruptedException ignored) {
                throw new NoSelectedCharacterException();
            }
            finally {
                Platform.runLater(() -> this.fireEvent(new DialogCloseEvent()));
            }
        }
    }

    private static class UUIDValidator
    extends ValidatorBase {
        public UUIDValidator() {
            this(I18n.i18n("account.methods.offline.uuid.malformed"));
        }

        public UUIDValidator(@NamedArg(value="message") String message) {
            super(message);
        }

        @Override
        protected void eval() {
            if (this.srcControl.get() instanceof TextInputControl) {
                this.evalTextInputField();
            }
        }

        private void evalTextInputField() {
            TextInputControl textField = (TextInputControl)this.srcControl.get();
            if (StringUtils.isBlank(textField.getText())) {
                this.hasErrors.set(false);
                return;
            }
            try {
                UUIDTypeAdapter.fromString(textField.getText());
                this.hasErrors.set(false);
            }
            catch (IllegalArgumentException ignored) {
                this.hasErrors.set(true);
            }
        }
    }
}

