/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.construct;

import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.construct.AdvancedListItemSkin;
import org.jackhuang.hmcl.util.Pair;

public class AdvancedListItem
extends Control {
    private final ObjectProperty<Node> leftGraphic = new SimpleObjectProperty((Object)this, "leftGraphic");
    private final ObjectProperty<Node> rightGraphic = new SimpleObjectProperty((Object)this, "rightGraphic");
    private final StringProperty title = new SimpleStringProperty((Object)this, "title");
    private final BooleanProperty active = new SimpleBooleanProperty((Object)this, "active");
    private final StringProperty subtitle = new SimpleStringProperty((Object)this, "subtitle");
    private final BooleanProperty actionButtonVisible = new SimpleBooleanProperty((Object)this, "actionButtonVisible", true);
    private ObjectProperty<EventHandler<ActionEvent>> onAction = new SimpleObjectProperty<EventHandler<ActionEvent>>((Object)this, "onAction"){

        protected void invalidated() {
            AdvancedListItem.this.setEventHandler(ActionEvent.ACTION, (EventHandler)this.get());
        }
    };

    public AdvancedListItem() {
        this.getStyleClass().add((Object)"advanced-list-item");
        this.addEventHandler(MouseEvent.MOUSE_CLICKED, e -> this.fireEvent((Event)new ActionEvent()));
    }

    public Node getLeftGraphic() {
        return (Node)this.leftGraphic.get();
    }

    public ObjectProperty<Node> leftGraphicProperty() {
        return this.leftGraphic;
    }

    public void setLeftGraphic(Node leftGraphic) {
        this.leftGraphic.set((Object)leftGraphic);
    }

    public Node getRightGraphic() {
        return (Node)this.rightGraphic.get();
    }

    public ObjectProperty<Node> rightGraphicProperty() {
        return this.rightGraphic;
    }

    public void setRightGraphic(Node rightGraphic) {
        this.rightGraphic.set((Object)rightGraphic);
    }

    public String getTitle() {
        return (String)this.title.get();
    }

    public StringProperty titleProperty() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title.set((Object)title);
    }

    public boolean isActive() {
        return this.active.get();
    }

    public BooleanProperty activeProperty() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active.set(active);
    }

    public String getSubtitle() {
        return (String)this.subtitle.get();
    }

    public StringProperty subtitleProperty() {
        return this.subtitle;
    }

    public void setSubtitle(String subtitle) {
        this.subtitle.set((Object)subtitle);
    }

    public boolean isActionButtonVisible() {
        return this.actionButtonVisible.get();
    }

    public BooleanProperty actionButtonVisibleProperty() {
        return this.actionButtonVisible;
    }

    public void setActionButtonVisible(boolean actionButtonVisible) {
        this.actionButtonVisible.set(actionButtonVisible);
    }

    public final ObjectProperty<EventHandler<ActionEvent>> onActionProperty() {
        return this.onAction;
    }

    public final void setOnAction(EventHandler<ActionEvent> value) {
        this.onActionProperty().set(value);
    }

    public final EventHandler<ActionEvent> getOnAction() {
        return (EventHandler)this.onActionProperty().get();
    }

    protected Skin<?> createDefaultSkin() {
        return new AdvancedListItemSkin(this);
    }

    public static Pair<Node, ImageView> createImageView(Image image) {
        return AdvancedListItem.createImageView(image, 32.0, 32.0);
    }

    public static Pair<Node, ImageView> createImageView(Image image, double width, double height) {
        StackPane imageViewContainer = new StackPane();
        FXUtils.setLimitWidth((Region)imageViewContainer, width);
        FXUtils.setLimitHeight((Region)imageViewContainer, height);
        ImageView imageView = new ImageView();
        FXUtils.limitSize(imageView, width, height);
        imageView.setPreserveRatio(true);
        imageView.setImage(image);
        imageViewContainer.getChildren().setAll((Object[])new Node[]{imageView});
        return Pair.pair(imageViewContainer, imageView);
    }
}

