/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.construct;

import com.jfoenix.controls.JFXButton;
import java.util.Locale;
import java.util.Timer;
import java.util.TimerTask;
import javafx.event.ActionEvent;
import javafx.scene.Node;
import javafx.scene.control.ButtonBase;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Paint;
import javafx.scene.text.TextFlow;
import org.jackhuang.hmcl.setting.Theme;
import org.jackhuang.hmcl.ui.Controllers;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.SVG;
import org.jackhuang.hmcl.ui.construct.DialogCloseEvent;
import org.jackhuang.hmcl.util.Lang;
import org.jackhuang.hmcl.util.i18n.I18n;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MessageDialogPane
extends HBox {
    private final HBox actions;
    @Nullable
    private ButtonBase cancelButton;

    public MessageDialogPane(@NotNull String text, @Nullable String title, @NotNull MessageType type) {
        SVG svg;
        this.setSpacing(8.0);
        this.getStyleClass().add((Object)"jfx-dialog-layout");
        Label graphic = new Label();
        graphic.setTranslateX(10.0);
        graphic.setTranslateY(10.0);
        graphic.setMinSize(40.0, 40.0);
        graphic.setMaxSize(40.0, 40.0);
        switch (type) {
            case INFO: {
                svg = SVG.INFO_CIRCLE;
                break;
            }
            case ERROR: {
                svg = SVG.CLOSE_CIRCLE;
                break;
            }
            case SUCCESS: {
                svg = SVG.CHECK_CIRCLE;
                break;
            }
            case WARNING: {
                svg = SVG.ALERT;
                break;
            }
            case QUESTION: {
                svg = SVG.HELP_CIRCLE;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unrecognized message box message type " + (Object)((Object)type));
            }
        }
        graphic.setGraphic(svg.createIcon((Paint)Theme.blackFill(), 40.0, 40.0));
        VBox vbox = new VBox();
        HBox.setHgrow((Node)vbox, (Priority)Priority.ALWAYS);
        StackPane titlePane = new StackPane();
        titlePane.getStyleClass().addAll((Object[])new String[]{"jfx-layout-heading", "title"});
        titlePane.getChildren().setAll((Object[])new Node[]{new Label(title != null ? title : I18n.i18n("message.info"))});
        StackPane content = new StackPane();
        content.getStyleClass().add((Object)"jfx-layout-body");
        EnhancedTextFlow textFlow = new EnhancedTextFlow(text);
        textFlow.setStyle("-fx-font-size: 14px;");
        if (textFlow.computePrefHeight(400.0) <= 350.0) {
            content.getChildren().setAll((Object[])new Node[]{textFlow});
        } else {
            ScrollPane scrollPane = new ScrollPane((Node)textFlow);
            scrollPane.setPrefHeight(350.0);
            VBox.setVgrow((Node)scrollPane, (Priority)Priority.ALWAYS);
            scrollPane.setFitToWidth(true);
            content.getChildren().setAll((Object[])new Node[]{scrollPane});
        }
        this.actions = new HBox();
        this.actions.getStyleClass().add((Object)"jfx-layout-actions");
        vbox.getChildren().setAll((Object[])new Node[]{titlePane, content, this.actions});
        this.getChildren().setAll((Object[])new Node[]{graphic, vbox});
        FXUtils.onEscPressed((Node)this, () -> {
            if (this.cancelButton != null) {
                this.cancelButton.fire();
            }
        });
    }

    public void addButton(Node btn) {
        btn.addEventHandler(ActionEvent.ACTION, e -> this.fireEvent(new DialogCloseEvent()));
        this.actions.getChildren().add((Object)btn);
    }

    public void setCancelButton(@Nullable ButtonBase btn) {
        this.cancelButton = btn;
    }

    public ButtonBase getCancelButton() {
        return this.cancelButton;
    }

    public static enum MessageType {
        ERROR,
        INFO,
        WARNING,
        QUESTION,
        SUCCESS;


        public String getDisplayName() {
            return I18n.i18n("message." + this.name().toLowerCase(Locale.ROOT));
        }
    }

    private static final class EnhancedTextFlow
    extends TextFlow {
        EnhancedTextFlow(String text) {
            this.getChildren().setAll(FXUtils.parseSegment(text, Controllers::onHyperlinkAction));
        }

        public double computePrefHeight(double width) {
            return super.computePrefHeight(width);
        }
    }

    public static class Builder {
        private final MessageDialogPane dialog;

        public Builder(String text, String title, MessageType type) {
            this.dialog = new MessageDialogPane(text, title, type);
        }

        public Builder addAction(Node actionNode) {
            this.dialog.addButton(actionNode);
            actionNode.getStyleClass().add((Object)"dialog-accept");
            return this;
        }

        public Builder ok(@Nullable Runnable ok) {
            JFXButton btnOk = new JFXButton(I18n.i18n("button.ok"));
            btnOk.getStyleClass().add((Object)"dialog-accept");
            if (ok != null) {
                btnOk.setOnAction(e -> ok.run());
            }
            this.dialog.addButton((Node)btnOk);
            this.dialog.setCancelButton((ButtonBase)btnOk);
            return this;
        }

        public Builder addCancel(@Nullable Runnable cancel) {
            return this.addCancel(I18n.i18n("button.cancel"), cancel);
        }

        public Builder addCancel(String cancelText, @Nullable Runnable cancel) {
            JFXButton btnCancel = new JFXButton(cancelText);
            btnCancel.getStyleClass().add((Object)"dialog-cancel");
            if (cancel != null) {
                btnCancel.setOnAction(e -> cancel.run());
            }
            this.dialog.addButton((Node)btnCancel);
            this.dialog.setCancelButton((ButtonBase)btnCancel);
            return this;
        }

        public Builder yesOrNo(@Nullable Runnable yes, @Nullable Runnable no) {
            JFXButton btnYes = new JFXButton(I18n.i18n("button.yes"));
            btnYes.getStyleClass().add((Object)"dialog-accept");
            if (yes != null) {
                btnYes.setOnAction(e -> yes.run());
            }
            this.dialog.addButton((Node)btnYes);
            this.addCancel(I18n.i18n("button.no"), no);
            return this;
        }

        public Builder actionOrCancel(ButtonBase actionButton, Runnable cancel) {
            this.dialog.addButton((Node)actionButton);
            this.addCancel(cancel);
            return this;
        }

        public Builder cancelOnTimeout(final long timeoutMs) {
            if (this.dialog.getCancelButton() == null) {
                throw new IllegalStateException("Call ok/yesOrNo/actionOrCancel before calling cancelOnTimeout");
            }
            final ButtonBase cancelButton = this.dialog.getCancelButton();
            final String originalText = cancelButton.getText();
            Timer timer = Lang.getTimer();
            timer.scheduleAtFixedRate(new TimerTask(){
                long timeout;
                {
                    this.timeout = timeoutMs;
                }

                @Override
                public void run() {
                    if (this.timeout <= 0L) {
                        this.cancel();
                        FXUtils.runInFX(() -> cancelButton.fire());
                        return;
                    }
                    this.timeout -= 1000L;
                    long currentTimeout = this.timeout;
                    FXUtils.runInFX(() -> cancelButton.setText(originalText + " (" + currentTimeout / 1000L + ")"));
                }
            }, 1000L, 1000L);
            return this;
        }

        public MessageDialogPane build() {
            return this.dialog;
        }
    }
}

