/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.download;

import java.util.Map;
import java.util.Optional;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableValue;
import org.jackhuang.hmcl.download.DownloadProvider;
import org.jackhuang.hmcl.download.LibraryAnalyzer;
import org.jackhuang.hmcl.download.RemoteVersion;
import org.jackhuang.hmcl.game.GameRepository;
import org.jackhuang.hmcl.game.HMCLGameRepository;
import org.jackhuang.hmcl.game.Version;
import org.jackhuang.hmcl.ui.InstallerItem;
import org.jackhuang.hmcl.ui.download.InstallersPage;
import org.jackhuang.hmcl.ui.download.UpdateInstallerWizardProvider;
import org.jackhuang.hmcl.ui.wizard.WizardController;
import org.jackhuang.hmcl.util.Lang;
import org.jackhuang.hmcl.util.i18n.I18n;

class AdditionalInstallersPage
extends InstallersPage {
    protected final BooleanProperty compatible = new SimpleBooleanProperty();
    protected final GameRepository repository;
    protected final String gameVersion;
    protected final Version version;

    public AdditionalInstallersPage(String gameVersion, Version version, WizardController controller, HMCLGameRepository repository, DownloadProvider downloadProvider) {
        super(controller, repository, gameVersion, downloadProvider);
        this.gameVersion = gameVersion;
        this.version = version;
        this.repository = repository;
        this.txtName.getValidators().clear();
        this.txtName.setText(version.getId());
        this.txtName.setEditable(false);
        this.installable.bind((ObservableValue)Bindings.createBooleanBinding(() -> this.compatible.get() && this.txtName.validate(), (Observable[])new Observable[]{this.txtName.textProperty(), this.compatible}));
        for (InstallerItem library : this.group.getLibraries()) {
            String libraryId = library.getLibraryId();
            if (libraryId.equals("game")) continue;
            library.removeAction.set(e -> {
                controller.getSettings().put(libraryId, new UpdateInstallerWizardProvider.RemoveVersionAction(libraryId));
                this.reload();
            });
        }
    }

    @Override
    protected void onInstall() {
        this.controller.onFinish();
    }

    @Override
    public String getTitle() {
        return I18n.i18n("settings.tabs.installers");
    }

    private String getVersion(String id) {
        return Optional.ofNullable(this.controller.getSettings().get(id)).flatMap(it -> Lang.tryCast(it, RemoteVersion.class)).map(RemoteVersion::getSelfVersion).orElse(null);
    }

    @Override
    protected void reload() {
        Version resolved = this.version.resolvePreservingPatches(this.repository);
        LibraryAnalyzer analyzer = LibraryAnalyzer.analyze(resolved, this.repository.getGameVersion(resolved).orElse(null));
        String game = analyzer.getVersion(LibraryAnalyzer.LibraryType.MINECRAFT).orElse(null);
        String currentGameVersion = Lang.nonNull(this.getVersion("game"), game);
        boolean compatible = true;
        for (InstallerItem library : this.group.getLibraries()) {
            boolean alreadyInstalled;
            String libraryId = library.getLibraryId();
            String version = analyzer.getVersion(libraryId).orElse(null);
            String libraryVersion = Lang.requireNonNullElse(this.getVersion(libraryId), version);
            boolean bl = alreadyInstalled = version != null && !(this.controller.getSettings().get(libraryId) instanceof UpdateInstallerWizardProvider.RemoveVersionAction);
            if (!"game".equals(libraryId) && currentGameVersion != null && !currentGameVersion.equals(game) && this.getVersion(libraryId) == null && alreadyInstalled) {
                library.setState(libraryVersion, true, true);
                compatible = false;
                continue;
            }
            if (alreadyInstalled || this.getVersion(libraryId) != null) {
                library.setState(libraryVersion, false, true);
                continue;
            }
            library.setState(null, false, false);
        }
        this.compatible.set(compatible);
    }

    @Override
    public void cleanup(Map<String, Object> settings) {
    }
}

