/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.versions;

import java.util.function.Consumer;
import javafx.scene.Node;
import javafx.scene.control.Tooltip;
import javafx.scene.image.ImageView;
import org.jackhuang.hmcl.event.Event;
import org.jackhuang.hmcl.setting.Profile;
import org.jackhuang.hmcl.setting.Profiles;
import org.jackhuang.hmcl.setting.VersionIconType;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.WeakListenerHolder;
import org.jackhuang.hmcl.ui.construct.AdvancedListItem;
import org.jackhuang.hmcl.util.Pair;
import org.jackhuang.hmcl.util.i18n.I18n;

public class GameAdvancedListItem
extends AdvancedListItem {
    private final Tooltip tooltip;
    private final ImageView imageView;
    private final WeakListenerHolder holder = new WeakListenerHolder();
    private Profile profile;
    private Consumer<Event> onVersionIconChangedListener;

    public GameAdvancedListItem() {
        this.tooltip = new Tooltip();
        Pair<Node, ImageView> view = GameAdvancedListItem.createImageView(null);
        this.setLeftGraphic(view.getKey());
        this.imageView = view.getValue();
        this.holder.add(FXUtils.onWeakChangeAndOperate(Profiles.selectedVersionProperty(), this::loadVersion));
        this.setActionButtonVisible(false);
    }

    private void loadVersion(String version) {
        if (Profiles.getSelectedProfile() != this.profile) {
            this.profile = Profiles.getSelectedProfile();
            if (this.profile != null) {
                this.onVersionIconChangedListener = this.profile.getRepository().onVersionIconChanged.registerWeak(event -> this.loadVersion(Profiles.getSelectedVersion()));
            }
        }
        if (version != null && Profiles.getSelectedProfile() != null && Profiles.getSelectedProfile().getRepository().hasVersion(version)) {
            FXUtils.installFastTooltip((Node)this, this.tooltip);
            this.setTitle(version);
            this.setSubtitle(null);
            this.imageView.setImage(Profiles.getSelectedProfile().getRepository().getVersionIconImage(version));
            this.tooltip.setText(version);
        } else {
            Tooltip.uninstall((Node)this, (Tooltip)this.tooltip);
            this.setTitle(I18n.i18n("version.empty"));
            this.setSubtitle(I18n.i18n("version.empty.add"));
            this.imageView.setImage(VersionIconType.DEFAULT.getIcon());
            this.tooltip.setText("");
        }
    }
}

