/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.versions;

import java.util.MissingResourceException;
import javafx.collections.ObservableList;
import org.jackhuang.hmcl.game.LocalizedRemoteModRepository;
import org.jackhuang.hmcl.mod.RemoteModRepository;
import org.jackhuang.hmcl.mod.curse.CurseForgeRemoteModRepository;
import org.jackhuang.hmcl.mod.modrinth.ModrinthRemoteModRepository;
import org.jackhuang.hmcl.ui.versions.DownloadListPage;
import org.jackhuang.hmcl.ui.versions.DownloadPage;
import org.jackhuang.hmcl.util.i18n.I18n;
import org.jackhuang.hmcl.util.logging.Logger;

public class ResourcePackDownloadListPage
extends DownloadListPage {
    public ResourcePackDownloadListPage(DownloadPage.DownloadCallback callback, boolean versionSelection) {
        super(null, callback, versionSelection);
        this.repository = new Repository();
        this.supportChinese.set(true);
        ((ObservableList)this.downloadSources.get()).setAll((Object[])new String[]{"mods.curseforge", "mods.modrinth"});
        if (CurseForgeRemoteModRepository.isAvailable()) {
            this.downloadSource.set((Object)"mods.curseforge");
        } else {
            this.downloadSource.set((Object)"mods.modrinth");
        }
    }

    @Override
    protected String getLocalizedCategory(String category) {
        String key = "mods.modrinth".equals(this.downloadSource.get()) ? "modrinth.category." + category : "curse.category." + category;
        try {
            return I18n.getResourceBundle().getString(key);
        }
        catch (MissingResourceException e) {
            Logger.LOG.warning("Cannot find key " + key + " in resource bundle", e);
            return category;
        }
    }

    @Override
    protected String getLocalizedOfficialPage() {
        if ("mods.modrinth".equals(this.downloadSource.get())) {
            return I18n.i18n("mods.modrinth");
        }
        return I18n.i18n("mods.curseforge");
    }

    private class Repository
    extends LocalizedRemoteModRepository {
        private Repository() {
        }

        @Override
        protected RemoteModRepository getBackedRemoteModRepository() {
            if ("mods.modrinth".equals(ResourcePackDownloadListPage.this.downloadSource.get())) {
                return ModrinthRemoteModRepository.RESOURCE_PACKS;
            }
            return CurseForgeRemoteModRepository.RESOURCE_PACKS;
        }

        @Override
        protected RemoteModRepository.SortType getBackedRemoteModRepositorySortOrder() {
            if ("mods.modrinth".equals(ResourcePackDownloadListPage.this.downloadSource.get())) {
                return RemoteModRepository.SortType.NAME;
            }
            return RemoteModRepository.SortType.POPULARITY;
        }

        @Override
        public RemoteModRepository.Type getType() {
            return RemoteModRepository.Type.MOD;
        }
    }
}

