/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.versions;

import com.jfoenix.controls.JFXButton;
import com.jfoenix.controls.JFXTextField;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.Property;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.SkinBase;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.construct.ComponentList;
import org.jackhuang.hmcl.ui.construct.FileItem;
import org.jackhuang.hmcl.ui.versions.WorldExportPage;
import org.jackhuang.hmcl.util.i18n.I18n;

public class WorldExportPageSkin
extends SkinBase<WorldExportPage> {
    public WorldExportPageSkin(WorldExportPage skinnable) {
        super((Control)skinnable);
        Insets insets = new Insets(0.0, 0.0, 12.0, 0.0);
        VBox container = new VBox();
        container.setSpacing(16.0);
        container.setAlignment(Pos.CENTER);
        FXUtils.setLimitWidth((Region)container, 500.0);
        HBox labelContainer = new HBox();
        labelContainer.setPadding(new Insets(0.0, 0.0, 0.0, 5.0));
        Label label = new Label(I18n.i18n("world.export"));
        labelContainer.getChildren().setAll((Object[])new Node[]{label});
        container.getChildren().add((Object)labelContainer);
        ComponentList list = new ComponentList();
        FileItem fileItem = new FileItem();
        fileItem.setName(I18n.i18n("world.export.location"));
        fileItem.pathProperty().bindBidirectional((Property)skinnable.pathProperty());
        list.getContent().add((Object)fileItem);
        JFXTextField txtWorldName = new JFXTextField();
        txtWorldName.textProperty().bindBidirectional((Property)skinnable.worldNameProperty());
        txtWorldName.setLabelFloat(true);
        txtWorldName.setPromptText(I18n.i18n("world.name"));
        StackPane.setMargin((Node)txtWorldName, (Insets)insets);
        list.getContent().add((Object)txtWorldName);
        Label lblGameVersionTitle = new Label(I18n.i18n("world.game_version"));
        Label lblGameVersion = new Label();
        lblGameVersion.textProperty().bind((ObservableValue)skinnable.gameVersionProperty());
        BorderPane gameVersionPane = new BorderPane();
        gameVersionPane.setPadding(new Insets(4.0, 0.0, 4.0, 0.0));
        gameVersionPane.setLeft((Node)lblGameVersionTitle);
        gameVersionPane.setRight((Node)lblGameVersion);
        list.getContent().add((Object)gameVersionPane);
        container.getChildren().add((Object)list);
        JFXButton btnExport = FXUtils.newRaisedButton(I18n.i18n("button.export"));
        btnExport.disableProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> txtWorldName.getText().isEmpty() || Files.exists(Paths.get(fileItem.getPath(), new String[0]), new LinkOption[0]), (Observable[])new Observable[]{txtWorldName.textProperty().isEmpty(), fileItem.pathProperty()}));
        btnExport.setOnMouseClicked(e -> skinnable.export());
        HBox bottom = new HBox();
        bottom.setAlignment(Pos.CENTER_RIGHT);
        bottom.getChildren().setAll((Object[])new Node[]{btnExport});
        container.getChildren().add((Object)bottom);
        this.getChildren().setAll((Object[])new Node[]{container});
    }
}

