/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.util.io;

import java.io.IOException;
import java.net.URL;

public final class ResponseCodeException
extends IOException {
    private final URL url;
    private final int responseCode;
    private final String data;

    public ResponseCodeException(URL url, int responseCode) {
        super("Unable to request url " + url + ", response code: " + responseCode);
        this.url = url;
        this.responseCode = responseCode;
        this.data = null;
    }

    public ResponseCodeException(URL url, int responseCode, String data) {
        super("Unable to request url " + url + ", response code: " + responseCode + ", data: " + data);
        this.url = url;
        this.responseCode = responseCode;
        this.data = data;
    }

    public URL getUrl() {
        return this.url;
    }

    public int getResponseCode() {
        return this.responseCode;
    }

    public String getData() {
        return this.data;
    }
}

