/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.auth.yggdrasil;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.jackhuang.hmcl.auth.AuthenticationException;
import org.jackhuang.hmcl.auth.ServerDisconnectException;
import org.jackhuang.hmcl.auth.ServerResponseMalformedException;
import org.jackhuang.hmcl.auth.yggdrasil.CompleteGameProfile;
import org.jackhuang.hmcl.auth.yggdrasil.GameProfile;
import org.jackhuang.hmcl.auth.yggdrasil.RemoteAuthenticationException;
import org.jackhuang.hmcl.auth.yggdrasil.Texture;
import org.jackhuang.hmcl.auth.yggdrasil.TextureType;
import org.jackhuang.hmcl.auth.yggdrasil.User;
import org.jackhuang.hmcl.auth.yggdrasil.YggdrasilProvider;
import org.jackhuang.hmcl.auth.yggdrasil.YggdrasilSession;
import org.jackhuang.hmcl.util.Lang;
import org.jackhuang.hmcl.util.Pair;
import org.jackhuang.hmcl.util.StringUtils;
import org.jackhuang.hmcl.util.gson.UUIDTypeAdapter;
import org.jackhuang.hmcl.util.gson.ValidationTypeAdapterFactory;
import org.jackhuang.hmcl.util.io.FileUtils;
import org.jackhuang.hmcl.util.io.HttpMultipartRequest;
import org.jackhuang.hmcl.util.io.NetworkUtils;
import org.jackhuang.hmcl.util.javafx.ObservableOptionalCache;
import org.jackhuang.hmcl.util.logging.Logger;

public class YggdrasilService {
    private static final ThreadPoolExecutor POOL = Lang.threadPool("YggdrasilProfileProperties", true, 2, 10L, TimeUnit.SECONDS);
    private final YggdrasilProvider provider;
    private final ObservableOptionalCache<UUID, CompleteGameProfile, AuthenticationException> profileRepository;
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter((Type)((Object)UUID.class), UUIDTypeAdapter.INSTANCE).registerTypeAdapterFactory(ValidationTypeAdapterFactory.INSTANCE).create();
    public static final String PURCHASE_URL = "https://www.microsoft.com/store/productid/9nxp44l49shj";

    public YggdrasilService(YggdrasilProvider provider) {
        this.provider = provider;
        this.profileRepository = new ObservableOptionalCache(uuid -> {
            Logger.LOG.info("Fetching properties of " + uuid + " from " + provider);
            return this.getCompleteGameProfile((UUID)uuid);
        }, (uuid, e) -> Logger.LOG.warning("Failed to fetch properties of " + uuid + " from " + provider, (Throwable)e), POOL);
    }

    public ObservableOptionalCache<UUID, CompleteGameProfile, AuthenticationException> getProfileRepository() {
        return this.profileRepository;
    }

    public YggdrasilSession authenticate(String username, String password, String clientToken) throws AuthenticationException {
        Objects.requireNonNull(username);
        Objects.requireNonNull(password);
        Objects.requireNonNull(clientToken);
        HashMap<String, Object> request = new HashMap<String, Object>();
        request.put("agent", Lang.mapOf(Pair.pair("name", "Minecraft"), Pair.pair("version", 1)));
        request.put("username", username);
        request.put("password", password);
        request.put("clientToken", clientToken);
        request.put("requestUser", true);
        return YggdrasilService.handleAuthenticationResponse(YggdrasilService.request(this.provider.getAuthenticationURL(), request), clientToken);
    }

    private static Map<String, Object> createRequestWithCredentials(String accessToken, String clientToken) {
        HashMap<String, Object> request = new HashMap<String, Object>();
        request.put("accessToken", accessToken);
        request.put("clientToken", clientToken);
        return request;
    }

    public YggdrasilSession refresh(String accessToken, String clientToken, GameProfile characterToSelect) throws AuthenticationException {
        Objects.requireNonNull(accessToken);
        Objects.requireNonNull(clientToken);
        Map<String, Object> request = YggdrasilService.createRequestWithCredentials(accessToken, clientToken);
        request.put("requestUser", true);
        if (characterToSelect != null) {
            request.put("selectedProfile", Lang.mapOf(Pair.pair("id", characterToSelect.getId()), Pair.pair("name", characterToSelect.getName())));
        }
        YggdrasilSession response = YggdrasilService.handleAuthenticationResponse(YggdrasilService.request(this.provider.getRefreshmentURL(), request), clientToken);
        if (!(characterToSelect == null || response.getSelectedProfile() != null && response.getSelectedProfile().getId().equals(characterToSelect.getId()))) {
            throw new ServerResponseMalformedException("Failed to select character");
        }
        return response;
    }

    public boolean validate(String accessToken) throws AuthenticationException {
        return this.validate(accessToken, null);
    }

    public boolean validate(String accessToken, String clientToken) throws AuthenticationException {
        Objects.requireNonNull(accessToken);
        try {
            YggdrasilService.requireEmpty(YggdrasilService.request(this.provider.getValidationURL(), YggdrasilService.createRequestWithCredentials(accessToken, clientToken)));
            return true;
        }
        catch (RemoteAuthenticationException e) {
            if ("ForbiddenOperationException".equals(e.getRemoteName())) {
                return false;
            }
            throw e;
        }
    }

    public void invalidate(String accessToken) throws AuthenticationException {
        this.invalidate(accessToken, null);
    }

    public void invalidate(String accessToken, String clientToken) throws AuthenticationException {
        Objects.requireNonNull(accessToken);
        YggdrasilService.requireEmpty(YggdrasilService.request(this.provider.getInvalidationURL(), YggdrasilService.createRequestWithCredentials(accessToken, clientToken)));
    }

    public void uploadSkin(UUID uuid, String accessToken, boolean isSlim, Path file) throws AuthenticationException, UnsupportedOperationException {
        try {
            HttpURLConnection con = NetworkUtils.createHttpConnection(this.provider.getSkinUploadURL(uuid));
            con.setRequestMethod("PUT");
            con.setRequestProperty("Authorization", "Bearer " + accessToken);
            con.setDoOutput(true);
            try (HttpMultipartRequest request = new HttpMultipartRequest(con);){
                request.param("model", isSlim ? "slim" : "");
                try (InputStream fis = Files.newInputStream(file, new OpenOption[0]);){
                    request.file("file", FileUtils.getName(file), "image/" + FileUtils.getExtension(file), fis);
                }
            }
            YggdrasilService.requireEmpty(NetworkUtils.readData(con));
        }
        catch (IOException e) {
            throw new AuthenticationException(e);
        }
    }

    public Optional<CompleteGameProfile> getCompleteGameProfile(UUID uuid) throws AuthenticationException {
        Objects.requireNonNull(uuid);
        return Optional.ofNullable(YggdrasilService.fromJson(YggdrasilService.request(this.provider.getProfilePropertiesURL(uuid), null), CompleteGameProfile.class));
    }

    public static Optional<Map<TextureType, Texture>> getTextures(CompleteGameProfile profile) throws ServerResponseMalformedException {
        Objects.requireNonNull(profile);
        String encodedTextures = profile.getProperties().get("textures");
        if (encodedTextures != null) {
            byte[] decodedBinary;
            try {
                decodedBinary = Base64.getDecoder().decode(encodedTextures);
            }
            catch (IllegalArgumentException e) {
                throw new ServerResponseMalformedException(e);
            }
            TextureResponse texturePayload = YggdrasilService.fromJson(new String(decodedBinary, StandardCharsets.UTF_8), TextureResponse.class);
            return Optional.ofNullable(texturePayload.textures);
        }
        return Optional.empty();
    }

    private static YggdrasilSession handleAuthenticationResponse(String responseText, String clientToken) throws AuthenticationException {
        AuthenticationResponse response = YggdrasilService.fromJson(responseText, AuthenticationResponse.class);
        YggdrasilService.handleErrorMessage(response);
        if (!clientToken.equals(response.clientToken)) {
            throw new AuthenticationException("Client token changed from " + clientToken + " to " + response.clientToken);
        }
        return new YggdrasilSession(response.clientToken, response.accessToken, response.selectedProfile, response.availableProfiles == null ? null : Collections.unmodifiableList(response.availableProfiles), response.user == null ? null : response.user.getProperties());
    }

    private static void requireEmpty(String response) throws AuthenticationException {
        if (StringUtils.isBlank(response)) {
            return;
        }
        YggdrasilService.handleErrorMessage(YggdrasilService.fromJson(response, ErrorResponse.class));
    }

    private static void handleErrorMessage(ErrorResponse response) throws AuthenticationException {
        if (!StringUtils.isBlank(response.error)) {
            throw new RemoteAuthenticationException(response.error, response.errorMessage, response.cause);
        }
    }

    private static String request(URL url, Object payload) throws AuthenticationException {
        try {
            if (payload == null) {
                return NetworkUtils.doGet(url);
            }
            return NetworkUtils.doPost(url, payload instanceof String ? (String)payload : GSON.toJson(payload), "application/json");
        }
        catch (IOException e) {
            throw new ServerDisconnectException(e);
        }
    }

    private static <T> T fromJson(String text, Class<T> typeOfT) throws ServerResponseMalformedException {
        try {
            return GSON.fromJson(text, typeOfT);
        }
        catch (JsonParseException e) {
            throw new ServerResponseMalformedException(text, e);
        }
    }

    private static class TextureResponse {
        public Map<TextureType, Texture> textures;

        private TextureResponse() {
        }
    }

    private static class AuthenticationResponse
    extends ErrorResponse {
        public String accessToken;
        public String clientToken;
        public GameProfile selectedProfile;
        public List<GameProfile> availableProfiles;
        public User user;

        private AuthenticationResponse() {
        }
    }

    private static class ErrorResponse {
        public String error;
        public String errorMessage;
        public String cause;

        private ErrorResponse() {
        }
    }
}

