/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.game;

import java.util.List;
import java.util.Objects;
import org.jackhuang.hmcl.download.LibraryAnalyzer;
import org.jackhuang.hmcl.game.GameJavaVersion;
import org.jackhuang.hmcl.game.Version;
import org.jackhuang.hmcl.java.JavaRuntime;
import org.jackhuang.hmcl.util.Lang;
import org.jackhuang.hmcl.util.platform.Architecture;
import org.jackhuang.hmcl.util.platform.OperatingSystem;
import org.jackhuang.hmcl.util.versioning.GameVersionNumber;
import org.jackhuang.hmcl.util.versioning.VersionNumber;
import org.jackhuang.hmcl.util.versioning.VersionRange;
import org.jetbrains.annotations.Nullable;

public enum JavaVersionConstraint {
    VANILLA(true, VersionRange.all(), VersionRange.all()){

        @Override
        public boolean checkJava(GameVersionNumber gameVersionNumber, Version version, JavaRuntime java) {
            GameJavaVersion minimumJavaVersion = GameJavaVersion.getMinimumJavaVersion(gameVersionNumber);
            return minimumJavaVersion == null || java.getParsedVersion() >= minimumJavaVersion.getMajorVersion();
        }
    }
    ,
    MODDED_JAVA_7(false, (VersionRange)GameVersionNumber.atMost("1.7.2"), (VersionRange)VersionNumber.atMost("1.7.999")){

        @Override
        protected boolean appliesToVersionImpl(GameVersionNumber gameVersionNumber, @Nullable Version version, @Nullable JavaRuntime java, @Nullable LibraryAnalyzer analyzer) {
            return version != null && analyzer != null && analyzer.has(LibraryAnalyzer.LibraryType.FORGE);
        }
    }
    ,
    MODDED_JAVA_8(false, (VersionRange)GameVersionNumber.between("1.7.10", "1.16.999"), (VersionRange)VersionNumber.between("1.8", "1.8.999")){

        @Override
        protected boolean appliesToVersionImpl(GameVersionNumber gameVersionNumber, @Nullable Version version, @Nullable JavaRuntime java, @Nullable LibraryAnalyzer analyzer) {
            return analyzer != null && analyzer.has(LibraryAnalyzer.LibraryType.FORGE);
        }
    }
    ,
    MODDED_JAVA_16(false, (VersionRange)GameVersionNumber.between("1.17", "1.17.999"), (VersionRange)VersionNumber.between("16", "16.999")){

        @Override
        protected boolean appliesToVersionImpl(GameVersionNumber gameVersionNumber, @Nullable Version version, @Nullable JavaRuntime java, @Nullable LibraryAnalyzer analyzer) {
            return analyzer != null && analyzer.has(LibraryAnalyzer.LibraryType.FORGE);
        }
    }
    ,
    MODDED_JAVA_17(false, (VersionRange)GameVersionNumber.between("1.18", "1.20.4"), (VersionRange)VersionNumber.between("17", "17.999")){

        @Override
        protected boolean appliesToVersionImpl(GameVersionNumber gameVersionNumber, @Nullable Version version, @Nullable JavaRuntime java, @Nullable LibraryAnalyzer analyzer) {
            return analyzer != null && analyzer.has(LibraryAnalyzer.LibraryType.FORGE);
        }
    }
    ,
    MODDED_JAVA_21(false, (VersionRange)GameVersionNumber.atLeast("1.20.5"), (VersionRange)VersionNumber.between("21", "21.999")){

        @Override
        protected boolean appliesToVersionImpl(GameVersionNumber gameVersionNumber, @Nullable Version version, @Nullable JavaRuntime java, @Nullable LibraryAnalyzer analyzer) {
            return analyzer != null && analyzer.has(LibraryAnalyzer.LibraryType.FORGE);
        }
    }
    ,
    LAUNCH_WRAPPER(true, (VersionRange)GameVersionNumber.atMost("1.12.999"), (VersionRange)VersionNumber.atMost("1.8.999")){

        @Override
        protected boolean appliesToVersionImpl(GameVersionNumber gameVersionNumber, @Nullable Version version, @Nullable JavaRuntime java, @Nullable LibraryAnalyzer analyzer) {
            if (version == null) {
                return false;
            }
            return "net.minecraft.launchwrapper.Launch".equals(version.getMainClass()) && version.getLibraries().stream().filter(library -> "launchwrapper".equals(library.getArtifactId())).anyMatch(library -> VersionNumber.asVersion(library.getVersion()).compareTo(VersionNumber.asVersion("1.13")) < 0);
        }
    }
    ,
    VANILLA_JAVA_8_51(false, GameVersionNumber.atLeast("1.13"), VersionNumber.atLeast("1.8.0_51")),
    GAME_JSON(true, VersionRange.all(), VersionRange.all()){

        @Override
        protected boolean appliesToVersionImpl(GameVersionNumber gameVersionNumber, @Nullable Version version, @Nullable JavaRuntime java, @Nullable LibraryAnalyzer analyzer) {
            if (version == null) {
                return false;
            }
            return gameVersionNumber.compareTo("1.7.10") >= 0 && version.getJavaVersion() != null;
        }

        @Override
        public VersionRange<VersionNumber> getJavaVersionRange(Version version) {
            String javaVersion = Objects.requireNonNull(version.getJavaVersion()).getMajorVersion() >= 9 ? "" + version.getJavaVersion().getMajorVersion() : "1." + version.getJavaVersion().getMajorVersion();
            return VersionNumber.atLeast(javaVersion);
        }
    }
    ,
    VANILLA_LINUX_JAVA_8(true, (VersionRange)GameVersionNumber.atMost("1.12.999"), (VersionRange)VersionNumber.atMost("1.8.999")){

        @Override
        protected boolean appliesToVersionImpl(GameVersionNumber gameVersionNumber, @Nullable Version version, @Nullable JavaRuntime java, @Nullable LibraryAnalyzer analyzer) {
            return OperatingSystem.CURRENT_OS == OperatingSystem.LINUX && Architecture.SYSTEM_ARCH == Architecture.X86_64 && (java == null || java.getArchitecture() == Architecture.X86_64);
        }

        @Override
        public boolean checkJava(GameVersionNumber gameVersionNumber, Version version, JavaRuntime java) {
            return java.getArchitecture() != Architecture.X86_64 || super.checkJava(gameVersionNumber, version, java);
        }
    }
    ,
    VANILLA_X86(false, VersionRange.all(), VersionRange.all()){

        @Override
        protected boolean appliesToVersionImpl(GameVersionNumber gameVersionNumber, @Nullable Version version, @Nullable JavaRuntime java, @Nullable LibraryAnalyzer analyzer) {
            if (java == null || java.getArchitecture() != Architecture.ARM64) {
                return false;
            }
            if (OperatingSystem.CURRENT_OS == OperatingSystem.WINDOWS || OperatingSystem.CURRENT_OS == OperatingSystem.OSX) {
                return gameVersionNumber.compareTo("1.6") < 0;
            }
            return false;
        }

        @Override
        public boolean checkJava(GameVersionNumber gameVersionNumber, Version version, JavaRuntime java) {
            return java.getArchitecture().isX86();
        }
    }
    ,
    MODLAUNCHER_8(false, (VersionRange)GameVersionNumber.between("1.16.3", "1.17.1"), VersionRange.all()){

        @Override
        protected boolean appliesToVersionImpl(GameVersionNumber gameVersionNumber, @Nullable Version version, @Nullable JavaRuntime java, @Nullable LibraryAnalyzer analyzer) {
            if (version == null || java == null || analyzer == null) {
                return false;
            }
            VersionNumber forgePatchVersion = analyzer.getVersion(LibraryAnalyzer.LibraryType.FORGE).map(VersionNumber::asVersion).orElse(null);
            if (forgePatchVersion == null) {
                return false;
            }
            switch (gameVersionNumber.toString()) {
                case "1.16.3": {
                    return forgePatchVersion.compareTo(VersionNumber.asVersion("34.1.27")) >= 0;
                }
                case "1.16.4": {
                    return true;
                }
                case "1.16.5": {
                    return forgePatchVersion.compareTo(VersionNumber.asVersion("36.2.23")) <= 0;
                }
                case "1.17.1": {
                    return VersionNumber.between("37.0.60", "37.0.75").contains(forgePatchVersion);
                }
            }
            return false;
        }

        @Override
        public boolean checkJava(GameVersionNumber gameVersionNumber, Version version, JavaRuntime java) {
            int parsedJavaVersion = java.getParsedVersion();
            if (parsedJavaVersion > 17) {
                return false;
            }
            if (parsedJavaVersion == 8) {
                return java.getVersionNumber().compareTo(VersionNumber.asVersion("1.8.0_321")) < 0;
            }
            if (parsedJavaVersion == 11) {
                return java.getVersionNumber().compareTo(VersionNumber.asVersion("11.0.14")) < 0;
            }
            if (parsedJavaVersion == 15) {
                return java.getVersionNumber().compareTo(VersionNumber.asVersion("15.0.6")) < 0;
            }
            if (parsedJavaVersion == 17) {
                return java.getVersionNumber().compareTo(VersionNumber.asVersion("17.0.2")) < 0;
            }
            return true;
        }
    };

    private final boolean isMandatory;
    private final VersionRange<GameVersionNumber> gameVersionRange;
    private final VersionRange<VersionNumber> javaVersionRange;
    public static final List<JavaVersionConstraint> ALL;

    private JavaVersionConstraint(boolean isMandatory, VersionRange<GameVersionNumber> gameVersionRange, VersionRange<VersionNumber> javaVersionRange) {
        this.isMandatory = isMandatory;
        this.gameVersionRange = gameVersionRange;
        this.javaVersionRange = javaVersionRange;
    }

    public boolean isMandatory() {
        return this.isMandatory;
    }

    public VersionRange<GameVersionNumber> getGameVersionRange() {
        return this.gameVersionRange;
    }

    public VersionRange<VersionNumber> getJavaVersionRange(Version version) {
        return this.javaVersionRange;
    }

    public final boolean appliesToVersion(@Nullable GameVersionNumber gameVersionNumber, @Nullable Version version, @Nullable JavaRuntime java, LibraryAnalyzer analyzer) {
        return this.gameVersionRange.contains(gameVersionNumber) && this.appliesToVersionImpl(gameVersionNumber, version, java, analyzer);
    }

    protected boolean appliesToVersionImpl(GameVersionNumber gameVersionNumber, @Nullable Version version, @Nullable JavaRuntime java, @Nullable LibraryAnalyzer analyzer) {
        return true;
    }

    public boolean checkJava(GameVersionNumber gameVersionNumber, Version version, JavaRuntime java) {
        return this.getJavaVersionRange(version).contains(java.getVersionNumber());
    }

    static {
        ALL = Lang.immutableListOf(JavaVersionConstraint.values());
    }
}

