/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.game;

import com.github.steveice10.opennbt.NBTIO;
import com.github.steveice10.opennbt.tag.builtin.CompoundTag;
import com.github.steveice10.opennbt.tag.builtin.LongTag;
import com.github.steveice10.opennbt.tag.builtin.StringTag;
import com.github.steveice10.opennbt.tag.builtin.Tag;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.charset.StandardCharsets;
import java.nio.file.AccessDeniedException;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javafx.scene.image.Image;
import org.jackhuang.hmcl.game.WorldLockedException;
import org.jackhuang.hmcl.util.io.CompressingUtils;
import org.jackhuang.hmcl.util.io.FileUtils;
import org.jackhuang.hmcl.util.io.IOUtils;
import org.jackhuang.hmcl.util.io.Unzipper;
import org.jackhuang.hmcl.util.io.Zipper;
import org.jackhuang.hmcl.util.logging.Logger;

public class World {
    private final Path file;
    private String fileName;
    private String worldName;
    private String gameVersion;
    private long lastPlayed;
    private Image icon;
    private boolean isLocked;

    public World(Path file) throws IOException {
        this.file = file;
        if (Files.isDirectory(file, new LinkOption[0])) {
            this.loadFromDirectory();
        } else if (Files.isRegularFile(file, new LinkOption[0])) {
            this.loadFromZip();
        } else {
            throw new IOException("Path " + file + " cannot be recognized as a Minecraft world");
        }
    }

    private void loadFromDirectory() throws IOException {
        this.fileName = FileUtils.getName(this.file);
        Path levelDat = this.file.resolve("level.dat");
        this.getWorldName(levelDat);
        this.isLocked = World.isLocked(this.getSessionLockFile());
        Path iconFile = this.file.resolve("icon.png");
        if (Files.isRegularFile(iconFile, new LinkOption[0])) {
            try (InputStream inputStream = Files.newInputStream(iconFile, new OpenOption[0]);){
                this.icon = new Image(inputStream, 64.0, 64.0, true, false);
                if (this.icon.isError()) {
                    throw this.icon.getException();
                }
            }
            catch (Exception e) {
                Logger.LOG.warning("Failed to load world icon", e);
            }
        }
    }

    public Path getFile() {
        return this.file;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getWorldName() {
        return this.worldName;
    }

    public Path getLevelDatFile() {
        return this.file.resolve("level.dat");
    }

    public Path getSessionLockFile() {
        return this.file.resolve("session.lock");
    }

    public long getLastPlayed() {
        return this.lastPlayed;
    }

    public String getGameVersion() {
        return this.gameVersion;
    }

    public Image getIcon() {
        return this.icon;
    }

    public boolean isLocked() {
        return this.isLocked;
    }

    private void loadFromZipImpl(Path root) throws IOException {
        Path levelDat = root.resolve("level.dat");
        if (!Files.exists(levelDat, new LinkOption[0])) {
            throw new IOException("Not a valid world zip file since level.dat cannot be found.");
        }
        this.getWorldName(levelDat);
        Path iconFile = root.resolve("icon.png");
        if (Files.isRegularFile(iconFile, new LinkOption[0])) {
            try (InputStream inputStream = Files.newInputStream(iconFile, new OpenOption[0]);){
                this.icon = new Image(inputStream, 64.0, 64.0, true, false);
                if (this.icon.isError()) {
                    throw this.icon.getException();
                }
            }
            catch (Exception e) {
                Logger.LOG.warning("Failed to load world icon", e);
            }
        }
    }

    private void loadFromZip() throws IOException {
        this.isLocked = false;
        try (FileSystem fs = CompressingUtils.readonly(this.file).setAutoDetectEncoding(true).build();){
            Path cur = fs.getPath("/level.dat", new String[0]);
            if (Files.isRegularFile(cur, new LinkOption[0])) {
                this.fileName = FileUtils.getName(this.file);
                this.loadFromZipImpl(fs.getPath("/", new String[0]));
                return;
            }
            try (Stream<Path> stream = Files.list(fs.getPath("/", new String[0]));){
                Path root = stream.filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).findAny().orElseThrow(() -> new IOException("Not a valid world zip file"));
                this.fileName = FileUtils.getName(root);
                this.loadFromZipImpl(root);
            }
        }
    }

    private void getWorldName(Path levelDat) throws IOException {
        CompoundTag version;
        CompoundTag nbt = World.parseLevelDat(levelDat);
        CompoundTag data = (CompoundTag)nbt.get("Data");
        if (data == null) {
            throw new IOException("level.dat missing Data");
        }
        if (!(data.get("LevelName") instanceof StringTag)) {
            throw new IOException("level.dat missing LevelName");
        }
        this.worldName = ((StringTag)data.get("LevelName")).getValue();
        if (!(data.get("LastPlayed") instanceof LongTag)) {
            throw new IOException("level.dat missing LastPlayed");
        }
        this.lastPlayed = ((LongTag)data.get("LastPlayed")).getValue();
        this.gameVersion = null;
        if (data.get("Version") instanceof CompoundTag && (version = (CompoundTag)data.get("Version")).get("Name") instanceof StringTag) {
            this.gameVersion = ((StringTag)version.get("Name")).getValue();
        }
    }

    public void rename(String newName) throws IOException {
        if (!Files.isDirectory(this.file, new LinkOption[0])) {
            throw new IOException("Not a valid world directory");
        }
        CompoundTag nbt = this.readLevelDat();
        CompoundTag data = (CompoundTag)nbt.get("Data");
        data.put(new StringTag("LevelName", newName));
        this.writeLevelDat(nbt);
        Files.move(this.file, this.file.resolveSibling(newName), new CopyOption[0]);
    }

    public void install(Path savesDir, String name) throws IOException {
        Path worldDir;
        try {
            worldDir = savesDir.resolve(name);
        }
        catch (InvalidPathException e) {
            throw new IOException(e);
        }
        if (Files.isDirectory(worldDir, new LinkOption[0])) {
            throw new FileAlreadyExistsException("World already exists");
        }
        if (Files.isRegularFile(this.file, new LinkOption[0])) {
            block20: {
                try (FileSystem fs = CompressingUtils.readonly(this.file).setAutoDetectEncoding(true).build();){
                    Path cur = fs.getPath("/level.dat", new String[0]);
                    if (Files.isRegularFile(cur, new LinkOption[0])) {
                        this.fileName = FileUtils.getName(this.file);
                        new Unzipper(this.file, worldDir).unzip();
                        break block20;
                    }
                    try (Stream<Path> stream = Files.list(fs.getPath("/", new String[0]));){
                        List subDirs = stream.collect(Collectors.toList());
                        if (subDirs.size() != 1) {
                            throw new IOException("World zip malformed");
                        }
                        String subDirectoryName = FileUtils.getName((Path)subDirs.get(0));
                        new Unzipper(this.file, worldDir).setSubDirectory("/" + subDirectoryName + "/").unzip();
                    }
                }
            }
            new World(worldDir).rename(name);
        } else if (Files.isDirectory(this.file, new LinkOption[0])) {
            FileUtils.copyDirectory(this.file, worldDir);
        }
    }

    public void export(Path zip, String worldName) throws IOException {
        if (!Files.isDirectory(this.file, new LinkOption[0])) {
            throw new IOException();
        }
        try (Zipper zipper = new Zipper(zip);){
            zipper.putDirectory(this.file, worldName);
        }
    }

    public CompoundTag readLevelDat() throws IOException {
        if (!Files.isDirectory(this.file, new LinkOption[0])) {
            throw new IOException("Not a valid world directory");
        }
        return World.parseLevelDat(this.getLevelDatFile());
    }

    public FileChannel lock() throws WorldLockedException {
        Path lockFile = this.getSessionLockFile();
        FileChannel channel = null;
        try {
            channel = FileChannel.open(lockFile, StandardOpenOption.CREATE, StandardOpenOption.WRITE);
            channel.write(ByteBuffer.wrap("\u2603".getBytes(StandardCharsets.UTF_8)));
            channel.force(true);
            FileLock fileLock = channel.tryLock();
            if (fileLock != null) {
                return channel;
            }
            IOUtils.closeQuietly(channel);
            throw new WorldLockedException("The world " + this.getFile() + " has been locked");
        }
        catch (IOException e) {
            IOUtils.closeQuietly(channel);
            throw new WorldLockedException(e);
        }
    }

    public void writeLevelDat(CompoundTag nbt) throws IOException {
        if (!Files.isDirectory(this.file, new LinkOption[0])) {
            throw new IOException("Not a valid world directory");
        }
        FileUtils.saveSafely(this.getLevelDatFile(), os -> {
            try (GZIPOutputStream gos = new GZIPOutputStream((OutputStream)os);){
                NBTIO.writeTag(gos, (Tag)nbt);
            }
        });
    }

    private static CompoundTag parseLevelDat(Path path) throws IOException {
        try (GZIPInputStream is = new GZIPInputStream(Files.newInputStream(path, new OpenOption[0]));){
            Tag nbt = NBTIO.readTag(is);
            if (nbt instanceof CompoundTag) {
                CompoundTag compoundTag = (CompoundTag)nbt;
                return compoundTag;
            }
            throw new IOException("level.dat malformed");
        }
    }

    private static boolean isLocked(Path sessionLockFile) {
        boolean bl;
        block10: {
            FileChannel fileChannel = FileChannel.open(sessionLockFile, StandardOpenOption.WRITE);
            try {
                boolean bl2 = bl = fileChannel.tryLock() == null;
                if (fileChannel == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (fileChannel != null) {
                        try {
                            fileChannel.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (AccessDeniedException accessDeniedException) {
                    return true;
                }
                catch (NoSuchFileException noSuchFileException) {
                    return false;
                }
                catch (IOException e) {
                    Logger.LOG.warning("Failed to open the lock file " + sessionLockFile, e);
                    return false;
                }
            }
            fileChannel.close();
        }
        return bl;
    }

    public static Stream<World> getWorlds(Path savesDir) {
        try {
            if (Files.exists(savesDir, new LinkOption[0])) {
                return Files.list(savesDir).flatMap(world -> {
                    try {
                        return Stream.of(new World(world.toAbsolutePath()));
                    }
                    catch (IOException e) {
                        Logger.LOG.warning("Failed to read world " + world, e);
                        return Stream.empty();
                    }
                });
            }
        }
        catch (IOException e) {
            Logger.LOG.warning("Failed to read saves", e);
        }
        return Stream.empty();
    }
}

