/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.mod;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import org.jackhuang.hmcl.mod.ModpackConfiguration;
import org.jackhuang.hmcl.task.Task;
import org.jackhuang.hmcl.util.DigestUtils;
import org.jackhuang.hmcl.util.io.FileUtils;
import org.jackhuang.hmcl.util.io.Unzipper;

public class ModpackInstallTask<T>
extends Task<Void> {
    private final File modpackFile;
    private final File dest;
    private final Charset charset;
    private final List<String> subDirectories;
    private final List<ModpackConfiguration.FileInformation> overrides;
    private final Predicate<String> callback;

    public ModpackInstallTask(File modpackFile, File dest, Charset charset, List<String> subDirectories, Predicate<String> callback, ModpackConfiguration<T> oldConfiguration) {
        this.modpackFile = modpackFile;
        this.dest = dest;
        this.charset = charset;
        this.subDirectories = subDirectories;
        this.callback = callback;
        this.overrides = oldConfiguration == null ? Collections.emptyList() : oldConfiguration.getOverrides();
    }

    @Override
    public void execute() throws Exception {
        HashSet entries = new HashSet();
        if (!FileUtils.makeDirectory(this.dest)) {
            throw new IOException("Unable to make directory " + this.dest);
        }
        HashMap<String, ModpackConfiguration.FileInformation> files = new HashMap<String, ModpackConfiguration.FileInformation>();
        for (ModpackConfiguration.FileInformation file : this.overrides) {
            files.put(file.getPath(), file);
        }
        for (String subDirectory : this.subDirectories) {
            new Unzipper(this.modpackFile, this.dest).setSubDirectory(subDirectory).setTerminateIfSubDirectoryNotExists().setReplaceExistentFile(true).setEncoding(this.charset).setFilter((destPath, isDirectory, zipEntry, entryPath) -> {
                if (isDirectory) {
                    return true;
                }
                if (!this.callback.test(entryPath)) {
                    return false;
                }
                entries.add(entryPath);
                if (!files.containsKey(entryPath)) {
                    return true;
                }
                if (!Files.exists(destPath, new LinkOption[0])) {
                    return false;
                }
                String fileHash = DigestUtils.digestToString("SHA-1", destPath);
                String oldHash = ((ModpackConfiguration.FileInformation)files.get(entryPath)).getHash();
                return Objects.equals(oldHash, fileHash);
            }).unzip();
        }
        for (ModpackConfiguration.FileInformation file : this.overrides) {
            File original = new File(this.dest, file.getPath());
            if (!original.exists() || entries.contains(file.getPath())) continue;
            original.delete();
        }
    }
}

