/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.mod;

import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.jackhuang.hmcl.mod.LocalModFile;
import org.jackhuang.hmcl.mod.RemoteMod;
import org.jetbrains.annotations.Nullable;

public interface RemoteModRepository {
    public Type getType();

    public SearchResult search(String var1, @Nullable Category var2, int var3, int var4, String var5, SortType var6, SortOrder var7) throws IOException;

    public Optional<RemoteMod.Version> getRemoteVersionByLocalFile(LocalModFile var1, Path var2) throws IOException;

    public RemoteMod getModById(String var1) throws IOException;

    public RemoteMod.File getModFile(String var1, String var2) throws IOException;

    public Stream<RemoteMod.Version> getRemoteVersionsById(String var1) throws IOException;

    public Stream<Category> getCategories() throws IOException;

    public static class Category {
        private final Object self;
        private final String id;
        private final List<Category> subcategories;

        public Category(Object self, String id, List<Category> subcategories) {
            this.self = self;
            this.id = id;
            this.subcategories = subcategories;
        }

        public Object getSelf() {
            return this.self;
        }

        public String getId() {
            return this.id;
        }

        public List<Category> getSubcategories() {
            return this.subcategories;
        }
    }

    public static class SearchResult {
        private final Stream<RemoteMod> sortedResults;
        private final Stream<RemoteMod> unsortedResults;
        private final int totalPages;

        public SearchResult(Stream<RemoteMod> sortedResults, Stream<RemoteMod> unsortedResults, int totalPages) {
            this.sortedResults = sortedResults;
            this.unsortedResults = unsortedResults;
            this.totalPages = totalPages;
        }

        public SearchResult(Stream<RemoteMod> sortedResults, int pages) {
            this.sortedResults = sortedResults;
            this.unsortedResults = sortedResults;
            this.totalPages = pages;
        }

        public Stream<RemoteMod> getResults() {
            return this.sortedResults;
        }

        public Stream<RemoteMod> getUnsortedResults() {
            return this.unsortedResults;
        }

        public int getTotalPages() {
            return this.totalPages;
        }
    }

    public static enum SortOrder {
        ASC,
        DESC;

    }

    public static enum SortType {
        POPULARITY,
        NAME,
        DATE_CREATED,
        LAST_UPDATED,
        AUTHOR,
        TOTAL_DOWNLOADS;

    }

    public static enum Type {
        MOD,
        MODPACK,
        RESOURCE_PACK,
        WORLD,
        CUSTOMIZATION;

    }
}

