/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.setting;

import java.io.FileNotFoundException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.nio.file.AccessDeniedException;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CancellationException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javax.net.ssl.SSLHandshakeException;
import org.jackhuang.hmcl.download.AdaptedDownloadProvider;
import org.jackhuang.hmcl.download.ArtifactMalformedException;
import org.jackhuang.hmcl.download.AutoDownloadProvider;
import org.jackhuang.hmcl.download.BMCLAPIDownloadProvider;
import org.jackhuang.hmcl.download.BalancedDownloadProvider;
import org.jackhuang.hmcl.download.DownloadProvider;
import org.jackhuang.hmcl.download.MojangDownloadProvider;
import org.jackhuang.hmcl.setting.ConfigHolder;
import org.jackhuang.hmcl.task.DownloadException;
import org.jackhuang.hmcl.task.FetchTask;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.util.Lang;
import org.jackhuang.hmcl.util.Pair;
import org.jackhuang.hmcl.util.StringUtils;
import org.jackhuang.hmcl.util.i18n.I18n;
import org.jackhuang.hmcl.util.io.ResponseCodeException;

public final class DownloadProviders {
    private static DownloadProvider currentDownloadProvider;
    public static final Map<String, DownloadProvider> providersById;
    public static final Map<String, DownloadProvider> rawProviders;
    private static final AdaptedDownloadProvider fileDownloadProvider;
    private static final MojangDownloadProvider MOJANG;
    private static final BMCLAPIDownloadProvider BMCLAPI;
    public static final String DEFAULT_PROVIDER_ID = "balanced";
    public static final String DEFAULT_RAW_PROVIDER_ID = "bmclapi";
    private static final InvalidationListener observer;

    private DownloadProviders() {
    }

    static void init() {
        FXUtils.onChangeAndOperate(ConfigHolder.config().versionListSourceProperty(), versionListSource -> {
            if (!providersById.containsKey(versionListSource)) {
                ConfigHolder.config().setVersionListSource(DEFAULT_PROVIDER_ID);
                return;
            }
            currentDownloadProvider = Optional.ofNullable(providersById.get(versionListSource)).orElse(providersById.get(DEFAULT_PROVIDER_ID));
        });
        if (!rawProviders.containsKey(ConfigHolder.config().getDownloadType())) {
            ConfigHolder.config().setDownloadType(DEFAULT_RAW_PROVIDER_ID);
        }
        FXUtils.onChangeAndOperate(ConfigHolder.config().downloadTypeProperty(), downloadType -> {
            DownloadProvider primary = Optional.ofNullable(rawProviders.get(downloadType)).orElse(rawProviders.get(DEFAULT_RAW_PROVIDER_ID));
            fileDownloadProvider.setDownloadProviderCandidates(Stream.concat(Stream.of(primary), rawProviders.values().stream().filter(x -> x != primary)).collect(Collectors.toList()));
        });
    }

    public static String getPrimaryDownloadProviderId() {
        String downloadType = ConfigHolder.config().getDownloadType();
        if (providersById.containsKey(downloadType)) {
            return downloadType;
        }
        return DEFAULT_PROVIDER_ID;
    }

    public static DownloadProvider getDownloadProviderByPrimaryId(String primaryId) {
        return Optional.ofNullable(providersById.get(primaryId)).orElse(providersById.get(DEFAULT_PROVIDER_ID));
    }

    public static DownloadProvider getDownloadProvider() {
        return ConfigHolder.config().isAutoChooseDownloadType() ? currentDownloadProvider : fileDownloadProvider;
    }

    public static String localizeErrorMessage(Throwable exception) {
        if (exception instanceof DownloadException) {
            URL url = ((DownloadException)exception).getUrl();
            if (exception.getCause() instanceof SocketTimeoutException) {
                return I18n.i18n("install.failed.downloading.timeout", url);
            }
            if (exception.getCause() instanceof ResponseCodeException) {
                ResponseCodeException responseCodeException = (ResponseCodeException)exception.getCause();
                if (I18n.hasKey("download.code." + responseCodeException.getResponseCode())) {
                    return I18n.i18n("download.code." + responseCodeException.getResponseCode(), url);
                }
                return I18n.i18n("install.failed.downloading.detail", url) + "\n" + StringUtils.getStackTrace(exception.getCause());
            }
            if (exception.getCause() instanceof FileNotFoundException) {
                return I18n.i18n("download.code.404", url);
            }
            if (exception.getCause() instanceof AccessDeniedException) {
                return I18n.i18n("install.failed.downloading.detail", url) + "\n" + I18n.i18n("exception.access_denied", ((AccessDeniedException)exception.getCause()).getFile());
            }
            if (exception.getCause() instanceof ArtifactMalformedException) {
                return I18n.i18n("install.failed.downloading.detail", url) + "\n" + I18n.i18n("exception.artifact_malformed");
            }
            if (exception.getCause() instanceof SSLHandshakeException) {
                return I18n.i18n("install.failed.downloading.detail", url) + "\n" + I18n.i18n("exception.ssl_handshake");
            }
            return I18n.i18n("install.failed.downloading.detail", url) + "\n" + StringUtils.getStackTrace(exception.getCause());
        }
        if (exception instanceof ArtifactMalformedException) {
            return I18n.i18n("exception.artifact_malformed");
        }
        if (exception instanceof CancellationException) {
            return I18n.i18n("message.cancelled");
        }
        return StringUtils.getStackTrace(exception);
    }

    static {
        fileDownloadProvider = new AdaptedDownloadProvider();
        String bmclapiRoot = "https://bmclapi2.bangbang93.com";
        String bmclapiRootOverride = System.getProperty("hmcl.bmclapi.override");
        if (bmclapiRootOverride != null) {
            bmclapiRoot = bmclapiRootOverride;
        }
        MOJANG = new MojangDownloadProvider();
        BMCLAPI = new BMCLAPIDownloadProvider(bmclapiRoot);
        rawProviders = Lang.mapOf(Pair.pair("mojang", MOJANG), Pair.pair(DEFAULT_RAW_PROVIDER_ID, BMCLAPI));
        AdaptedDownloadProvider fileProvider = new AdaptedDownloadProvider();
        fileProvider.setDownloadProviderCandidates(Arrays.asList(BMCLAPI, MOJANG));
        BalancedDownloadProvider balanced = new BalancedDownloadProvider(MOJANG, BMCLAPI);
        providersById = Lang.mapOf(Pair.pair("official", new AutoDownloadProvider(MOJANG, fileProvider)), Pair.pair(DEFAULT_PROVIDER_ID, new AutoDownloadProvider(balanced, fileProvider)), Pair.pair("mirror", new AutoDownloadProvider(BMCLAPI, fileProvider)));
        observer = FXUtils.observeWeak(() -> FetchTask.setDownloadExecutorConcurrency(ConfigHolder.config().getAutoDownloadThreads() ? FetchTask.DEFAULT_CONCURRENCY : ConfigHolder.config().getDownloadThreads()), new Observable[]{ConfigHolder.config().autoDownloadThreadsProperty(), ConfigHolder.config().downloadThreadsProperty()});
    }
}

