/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.setting;

import java.net.Authenticator;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.ObjectBinding;
import javafx.beans.value.ObservableObjectValue;
import org.jackhuang.hmcl.setting.ConfigHolder;
import org.jackhuang.hmcl.util.StringUtils;
import org.jackhuang.hmcl.util.logging.Logger;

public final class ProxyManager {
    private static ObjectBinding<Proxy> proxyProperty;

    private ProxyManager() {
    }

    public static Proxy getProxy() {
        return (Proxy)proxyProperty.get();
    }

    public static ObservableObjectValue<Proxy> proxyProperty() {
        return proxyProperty;
    }

    static void init() {
        proxyProperty = Bindings.createObjectBinding(() -> {
            String host = ConfigHolder.config().getProxyHost();
            int port = ConfigHolder.config().getProxyPort();
            if (!ConfigHolder.config().hasProxy() || StringUtils.isBlank(host) || ConfigHolder.config().getProxyType() == Proxy.Type.DIRECT) {
                return Proxy.NO_PROXY;
            }
            if (port < 0 || port > 65535) {
                Logger.LOG.warning("Illegal proxy port: " + port);
                return Proxy.NO_PROXY;
            }
            return new Proxy(ConfigHolder.config().getProxyType(), new InetSocketAddress(host, port));
        }, (Observable[])new Observable[]{ConfigHolder.config().proxyTypeProperty(), ConfigHolder.config().proxyHostProperty(), ConfigHolder.config().proxyPortProperty(), ConfigHolder.config().hasProxyProperty()});
        proxyProperty.addListener(any -> ProxyManager.updateSystemProxy());
        ProxyManager.updateSystemProxy();
        Authenticator.setDefault(new Authenticator(){

            @Override
            protected PasswordAuthentication getPasswordAuthentication() {
                if (ConfigHolder.config().hasProxyAuth()) {
                    String username = ConfigHolder.config().getProxyUser();
                    String password = ConfigHolder.config().getProxyPass();
                    if (username != null && password != null) {
                        return new PasswordAuthentication(username, password.toCharArray());
                    }
                }
                return null;
            }
        });
    }

    private static void updateSystemProxy() {
        Proxy proxy = (Proxy)proxyProperty.get();
        if (proxy.type() == Proxy.Type.DIRECT) {
            System.clearProperty("http.proxyHost");
            System.clearProperty("http.proxyPort");
            System.clearProperty("https.proxyHost");
            System.clearProperty("https.proxyPort");
            System.clearProperty("socksProxyHost");
            System.clearProperty("socksProxyPort");
        } else {
            InetSocketAddress address = (InetSocketAddress)proxy.address();
            String host = address.getHostString();
            String port = String.valueOf(address.getPort());
            if (proxy.type() == Proxy.Type.HTTP) {
                System.clearProperty("socksProxyHost");
                System.clearProperty("socksProxyPort");
                System.setProperty("http.proxyHost", host);
                System.setProperty("http.proxyPort", port);
                System.setProperty("https.proxyHost", host);
                System.setProperty("https.proxyPort", port);
            } else if (proxy.type() == Proxy.Type.SOCKS) {
                System.clearProperty("http.proxyHost");
                System.clearProperty("http.proxyPort");
                System.clearProperty("https.proxyHost");
                System.clearProperty("https.proxyPort");
                System.setProperty("socksProxyHost", host);
                System.setProperty("socksProxyPort", port);
            }
        }
    }
}

