/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.setting;

import com.google.gson.annotations.JsonAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Base64;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.ObjectBinding;
import javafx.scene.paint.Color;
import javafx.scene.text.Font;
import org.jackhuang.hmcl.Metadata;
import org.jackhuang.hmcl.setting.ConfigHolder;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.util.Lazy;
import org.jackhuang.hmcl.util.Pair;
import org.jackhuang.hmcl.util.io.FileUtils;
import org.jackhuang.hmcl.util.logging.Logger;

@JsonAdapter(value=TypeAdapter.class)
public class Theme {
    public static final Theme BLUE = new Theme("blue", "#5C6BC0");
    public static final Color BLACK = Color.web((String)"#292929");
    public static final Color[] SUGGESTED_COLORS = new Color[]{Color.web((String)"#3D6DA3"), Color.web((String)"#283593"), Color.web((String)"#43A047"), Color.web((String)"#E67E22"), Color.web((String)"#9C27B0"), Color.web((String)"#B71C1C")};
    private static final Lazy<Font> FONT = new Lazy<Font>(() -> {
        Font font2;
        Path path;
        String[] fileNames;
        for (String fileName : fileNames = new String[]{"font.ttf", "font.otf", "font.woff"}) {
            path = Paths.get(fileName, new String[0]).toAbsolutePath();
            if (!Files.isRegularFile(path, new LinkOption[0])) continue;
            try {
                font2 = Font.loadFont((String)path.toUri().toURL().toExternalForm(), (double)0.0);
                if (font2 != null) {
                    return font2;
                }
            }
            catch (MalformedURLException font2) {
                // empty catch block
            }
            Logger.LOG.warning("Failed to load font " + path);
        }
        for (String fileName : fileNames) {
            path = Metadata.HMCL_DIRECTORY.resolve(fileName);
            if (!Files.isRegularFile(path, new LinkOption[0])) continue;
            try {
                font2 = Font.loadFont((String)path.toUri().toURL().toExternalForm(), (double)0.0);
                if (font2 != null) {
                    return font2;
                }
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            Logger.LOG.warning("Failed to load font " + path);
        }
        return null;
    });
    private final Color paint;
    private final String color;
    private final String name;
    private static ObjectBinding<Color> FOREGROUND_FILL;

    public static Theme getTheme() {
        Theme theme = ConfigHolder.config().getTheme();
        return theme == null ? BLUE : theme;
    }

    Theme(String name, String color) {
        this.name = name;
        this.color = Objects.requireNonNull(color);
        this.paint = Color.web((String)color);
    }

    public String getName() {
        return this.name;
    }

    public String getColor() {
        return this.color;
    }

    public boolean isCustom() {
        return this.name.startsWith("#");
    }

    public boolean isLight() {
        return this.paint.grayscale().getRed() >= 0.5;
    }

    public Color getForegroundColor() {
        return this.isLight() ? Color.BLACK : Color.WHITE;
    }

    private static String rgba(Color color, double opacity) {
        return String.format("rgba(%d, %d, %d, %.1f)", (int)Math.ceil(color.getRed() * 256.0), (int)Math.ceil(color.getGreen() * 256.0), (int)Math.ceil(color.getBlue() * 256.0), opacity);
    }

    private static Pair<String, String> parseFontStyle(String style) {
        if (style == null) {
            return null;
        }
        String weight = (style = style.toLowerCase(Locale.ROOT)).contains("thin") ? "100" : (style.contains("extralight") || style.contains("extra light") || style.contains("ultralight") | style.contains("ultra light") ? "200" : (style.contains("medium") ? "500" : (style.contains("semibold") || style.contains("semi bold") || style.contains("demibold") || style.contains("demi bold") ? "600" : (style.contains("extrabold") || style.contains("extra bold") || style.contains("ultrabold") || style.contains("ultra bold") ? "800" : (style.contains("black") || style.contains("heavy") ? "900" : (style.contains("light") ? "lighter" : (style.contains("bold") ? "bold" : null)))))));
        String posture = style.contains("italic") || style.contains("oblique") ? "italic" : null;
        return Pair.pair(weight, posture);
    }

    public String[] getStylesheets(String overrideFontFamily) {
        Font font;
        String css = "/assets/css/blue.css";
        String fontFamily = overrideFontFamily == null ? System.getProperty("hmcl.font.override", System.getenv("HMCL_FONT")) : overrideFontFamily;
        Pair<String, String> fontStyle = null;
        if (fontFamily == null && (font = FONT.get()) != null) {
            fontFamily = font.getFamily();
            fontStyle = Theme.parseFontStyle(font.getStyle());
        }
        if (fontFamily != null || !this.color.equalsIgnoreCase(Theme.BLUE.color)) {
            Color textFill = this.getForegroundColor();
            StringBuilder themeBuilder = new StringBuilder(512);
            themeBuilder.append(".root {").append("-fx-base-color:").append(this.color).append(';').append("-fx-base-darker-color: derive(-fx-base-color, -10%);").append("-fx-base-check-color: derive(-fx-base-color, 30%);").append("-fx-rippler-color:").append(Theme.rgba(this.paint, 0.3)).append(';').append("-fx-base-rippler-color: derive(").append(Theme.rgba(this.paint, 0.3)).append(", 100%);").append("-fx-base-disabled-text-fill:").append(Theme.rgba(textFill, 0.7)).append(";").append("-fx-base-text-fill:").append(Theme.getColorDisplayName(this.getForegroundColor())).append(";").append("-theme-thumb:").append(Theme.rgba(this.paint, 0.7)).append(";");
            if (fontFamily == null) {
                themeBuilder.append("-fx-font-family: -fx-base-font-family;");
            } else {
                themeBuilder.append("-fx-font-family:\"").append(fontFamily).append("\";");
            }
            if (fontStyle != null) {
                if (fontStyle.getKey() != null) {
                    themeBuilder.append("-fx-font-weight:").append(fontStyle.getKey()).append(";");
                }
                if (fontStyle.getValue() != null) {
                    themeBuilder.append("-fx-font-style:").append(fontStyle.getValue()).append(";");
                }
            }
            themeBuilder.append('}');
            if (FXUtils.JAVAFX_MAJOR_VERSION >= 17) {
                css = "data:text/css;charset=UTF-8;base64," + Base64.getEncoder().encodeToString(themeBuilder.toString().getBytes(StandardCharsets.UTF_8));
            } else {
                try {
                    File temp = File.createTempFile("hmcl", ".css");
                    FileUtils.writeText(temp, themeBuilder.toString(), Charset.defaultCharset());
                    temp.deleteOnExit();
                    css = temp.toURI().toString();
                }
                catch (IOException | NullPointerException e) {
                    Logger.LOG.error("Unable to create theme stylesheet. Fallback to blue theme.", e);
                }
            }
        }
        return new String[]{css, "/assets/css/root.css"};
    }

    public static Theme custom(String color) {
        if (!color.startsWith("#")) {
            throw new IllegalArgumentException();
        }
        return new Theme(color, color);
    }

    public static Optional<Theme> getTheme(String name) {
        if (name == null) {
            return Optional.empty();
        }
        if (name.startsWith("#")) {
            try {
                Color.web((String)name);
                return Optional.of(Theme.custom(name));
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        } else {
            String color = null;
            switch (name.toLowerCase(Locale.ROOT)) {
                case "blue": {
                    return Optional.of(BLUE);
                }
                case "darker_blue": {
                    color = "#283593";
                    break;
                }
                case "green": {
                    color = "#43A047";
                    break;
                }
                case "orange": {
                    color = "#E67E22";
                    break;
                }
                case "purple": {
                    color = "#9C27B0";
                    break;
                }
                case "red": {
                    color = "#F44336";
                }
            }
            if (color != null) {
                return Optional.of(new Theme(name, color));
            }
        }
        return Optional.empty();
    }

    public static String getColorDisplayName(Color c) {
        return c != null ? String.format("#%02X%02X%02X", Math.round(c.getRed() * 255.0), Math.round(c.getGreen() * 255.0), Math.round(c.getBlue() * 255.0)) : null;
    }

    public static ObjectBinding<Color> foregroundFillBinding() {
        if (FOREGROUND_FILL == null) {
            FOREGROUND_FILL = Bindings.createObjectBinding(() -> Theme.getTheme().getForegroundColor(), (Observable[])new Observable[]{ConfigHolder.config().themeProperty()});
        }
        return FOREGROUND_FILL;
    }

    public static Color blackFill() {
        return BLACK;
    }

    public static Color whiteFill() {
        return Color.WHITE;
    }

    public static class TypeAdapter
    extends com.google.gson.TypeAdapter<Theme> {
        @Override
        public void write(JsonWriter out, Theme value) throws IOException {
            out.value(value.getName().toLowerCase(Locale.ROOT));
        }

        @Override
        public Theme read(JsonReader in) throws IOException {
            return Theme.getTheme(in.nextString()).orElse(BLUE);
        }
    }
}

