/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui;

import com.jfoenix.controls.JFXButton;
import com.jfoenix.controls.JFXDialogLayout;
import java.io.File;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.geometry.Rectangle2D;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.ButtonBase;
import javafx.scene.control.Label;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.stage.Screen;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.util.Duration;
import org.jackhuang.hmcl.Launcher;
import org.jackhuang.hmcl.Metadata;
import org.jackhuang.hmcl.game.ModpackHelper;
import org.jackhuang.hmcl.java.JavaManager;
import org.jackhuang.hmcl.setting.Accounts;
import org.jackhuang.hmcl.setting.ConfigHolder;
import org.jackhuang.hmcl.setting.EnumCommonDirectory;
import org.jackhuang.hmcl.setting.Profiles;
import org.jackhuang.hmcl.setting.Theme;
import org.jackhuang.hmcl.task.Task;
import org.jackhuang.hmcl.task.TaskExecutor;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.account.AccountListPage;
import org.jackhuang.hmcl.ui.animation.AnimationUtils;
import org.jackhuang.hmcl.ui.construct.DialogCloseEvent;
import org.jackhuang.hmcl.ui.construct.InputDialogPane;
import org.jackhuang.hmcl.ui.construct.JFXHyperlink;
import org.jackhuang.hmcl.ui.construct.MessageDialogPane;
import org.jackhuang.hmcl.ui.construct.PromptDialogPane;
import org.jackhuang.hmcl.ui.construct.TaskExecutorDialogPane;
import org.jackhuang.hmcl.ui.decorator.DecoratorController;
import org.jackhuang.hmcl.ui.download.DownloadPage;
import org.jackhuang.hmcl.ui.download.ModpackInstallWizardProvider;
import org.jackhuang.hmcl.ui.main.LauncherSettingsPage;
import org.jackhuang.hmcl.ui.main.RootPage;
import org.jackhuang.hmcl.ui.versions.GameListPage;
import org.jackhuang.hmcl.ui.versions.VersionPage;
import org.jackhuang.hmcl.util.FutureCallback;
import org.jackhuang.hmcl.util.Lang;
import org.jackhuang.hmcl.util.Lazy;
import org.jackhuang.hmcl.util.TaskCancellationAction;
import org.jackhuang.hmcl.util.i18n.I18n;
import org.jackhuang.hmcl.util.io.FileUtils;
import org.jackhuang.hmcl.util.logging.Logger;
import org.jackhuang.hmcl.util.platform.Architecture;
import org.jackhuang.hmcl.util.platform.OperatingSystem;

public final class Controllers {
    public static final int MIN_WIDTH = 818;
    public static final int MIN_HEIGHT = 508;
    public static final Screen SCREEN = Screen.getPrimary();
    private static InvalidationListener stageSizeChangeListener;
    private static DoubleProperty stageX;
    private static DoubleProperty stageY;
    private static DoubleProperty stageWidth;
    private static DoubleProperty stageHeight;
    private static Scene scene;
    private static Stage stage;
    private static Lazy<VersionPage> versionPage;
    private static Lazy<GameListPage> gameListPage;
    private static Lazy<RootPage> rootPage;
    private static DecoratorController decorator;
    private static Lazy<DownloadPage> downloadPage;
    private static Lazy<AccountListPage> accountListPage;
    private static Lazy<LauncherSettingsPage> settingsPage;

    private Controllers() {
    }

    public static Scene getScene() {
        return scene;
    }

    public static Stage getStage() {
        return stage;
    }

    public static VersionPage getVersionPage() {
        return versionPage.get();
    }

    public static GameListPage getGameListPage() {
        return gameListPage.get();
    }

    public static RootPage getRootPage() {
        return rootPage.get();
    }

    public static LauncherSettingsPage getSettingsPage() {
        return settingsPage.get();
    }

    public static AccountListPage getAccountListPage() {
        return accountListPage.get();
    }

    public static DownloadPage getDownloadPage() {
        return downloadPage.get();
    }

    public static DecoratorController getDecorator() {
        return decorator;
    }

    public static void onApplicationStop() {
        stageSizeChangeListener = null;
        if (stageX != null) {
            ConfigHolder.config().setX(stageX.get() / SCREEN.getBounds().getWidth());
            stageX = null;
        }
        if (stageY != null) {
            ConfigHolder.config().setY(stageY.get() / SCREEN.getBounds().getHeight());
            stageY = null;
        }
        if (stageHeight != null) {
            ConfigHolder.config().setHeight(stageHeight.get());
            stageHeight = null;
        }
        if (stageWidth != null) {
            ConfigHolder.config().setWidth(stageWidth.get());
            stageWidth = null;
        }
    }

    public static void initialize(Stage stage) {
        Logger.LOG.info("Start initializing application");
        Controllers.stage = stage;
        stageSizeChangeListener = o -> {
            DoubleProperty targetProperty;
            ReadOnlyDoubleProperty sourceProperty = (ReadOnlyDoubleProperty)o;
            switch (sourceProperty.getName()) {
                case "x": {
                    targetProperty = stageX;
                    break;
                }
                case "y": {
                    targetProperty = stageY;
                    break;
                }
                case "width": {
                    targetProperty = stageWidth;
                    break;
                }
                case "height": {
                    targetProperty = stageHeight;
                    break;
                }
                default: {
                    targetProperty = null;
                }
            }
            if (targetProperty != null && stage != null && !stage.isIconified()) {
                targetProperty.set(sourceProperty.get());
            }
        };
        WeakInvalidationListener weakListener = new WeakInvalidationListener(stageSizeChangeListener);
        double initWidth = Math.max(818.0, ConfigHolder.config().getWidth());
        double initHeight = Math.max(508.0, ConfigHolder.config().getHeight());
        double initX = ConfigHolder.config().getX() * SCREEN.getBounds().getWidth();
        double initY = ConfigHolder.config().getY() * SCREEN.getBounds().getHeight();
        boolean invalid = true;
        double border = 20.0;
        for (Screen screen : Screen.getScreens()) {
            Rectangle2D bound = screen.getBounds();
            if (!(bound.getMinX() + border <= initX + initWidth) || !(initX <= bound.getMaxX() - border) || !(bound.getMinY() + border <= initY) || !(initY <= bound.getMaxY() - border)) continue;
            invalid = false;
            break;
        }
        if (invalid) {
            initX = (0.5 - initWidth / SCREEN.getBounds().getWidth() / 2.0) * SCREEN.getBounds().getWidth();
            initY = (0.5 - initHeight / SCREEN.getBounds().getHeight() / 2.0) * SCREEN.getBounds().getHeight();
        }
        stage.setX(initX);
        stage.setY(initY);
        stageX.set(initX);
        stageY.set(initY);
        stage.setHeight(initHeight);
        stage.setWidth(initWidth);
        stageHeight.set(initHeight);
        stageWidth.set(initWidth);
        stage.xProperty().addListener((InvalidationListener)weakListener);
        stage.yProperty().addListener((InvalidationListener)weakListener);
        stage.heightProperty().addListener((InvalidationListener)weakListener);
        stage.widthProperty().addListener((InvalidationListener)weakListener);
        stage.setOnCloseRequest(e -> Launcher.stopApplication());
        decorator = new DecoratorController(stage, (Node)Controllers.getRootPage());
        if (ConfigHolder.config().getCommonDirType() == EnumCommonDirectory.CUSTOM && !FileUtils.canCreateDirectory(ConfigHolder.config().getCommonDirectory())) {
            ConfigHolder.config().setCommonDirType(EnumCommonDirectory.DEFAULT);
            Controllers.dialog(I18n.i18n("launcher.cache_directory.invalid"));
        }
        Lang.thread(JavaManager::initialize, "Search Java", true);
        scene = new Scene((Parent)decorator.getDecorator());
        scene.setFill((Paint)Color.TRANSPARENT);
        stage.setMinWidth(818.0);
        stage.setMinHeight(508.0);
        decorator.getDecorator().prefWidthProperty().bind((ObservableValue)scene.widthProperty());
        decorator.getDecorator().prefHeightProperty().bind((ObservableValue)scene.heightProperty());
        scene.getStylesheets().setAll((Object[])Theme.getTheme().getStylesheets(ConfigHolder.config().getLauncherFontFamily()));
        FXUtils.setIcon(stage);
        stage.setTitle(Metadata.FULL_TITLE);
        stage.initStyle(StageStyle.TRANSPARENT);
        stage.setScene(scene);
        if (AnimationUtils.playWindowAnimation()) {
            Timeline timeline = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)0.0), new KeyValue[]{new KeyValue((WritableValue)decorator.getDecorator().opacityProperty(), (Object)0, FXUtils.EASE), new KeyValue((WritableValue)decorator.getDecorator().scaleXProperty(), (Object)0.8, FXUtils.EASE), new KeyValue((WritableValue)decorator.getDecorator().scaleYProperty(), (Object)0.8, FXUtils.EASE), new KeyValue((WritableValue)decorator.getDecorator().scaleZProperty(), (Object)0.8, FXUtils.EASE)}), new KeyFrame(Duration.millis((double)600.0), new KeyValue[]{new KeyValue((WritableValue)decorator.getDecorator().opacityProperty(), (Object)1, FXUtils.EASE), new KeyValue((WritableValue)decorator.getDecorator().scaleXProperty(), (Object)1, FXUtils.EASE), new KeyValue((WritableValue)decorator.getDecorator().scaleYProperty(), (Object)1, FXUtils.EASE), new KeyValue((WritableValue)decorator.getDecorator().scaleZProperty(), (Object)1, FXUtils.EASE)})});
            timeline.play();
        }
        if (!Architecture.SYSTEM_ARCH.isX86() && ConfigHolder.globalConfig().getPlatformPromptVersion() < 1) {
            Runnable continueAction = () -> ConfigHolder.globalConfig().setPlatformPromptVersion(1);
            if (OperatingSystem.CURRENT_OS == OperatingSystem.OSX && Architecture.SYSTEM_ARCH == Architecture.ARM64) {
                Controllers.dialog(I18n.i18n("fatal.unsupported_platform.osx_arm64"), null, MessageDialogPane.MessageType.INFO, continueAction);
            } else if (OperatingSystem.CURRENT_OS == OperatingSystem.WINDOWS && Architecture.SYSTEM_ARCH == Architecture.ARM64) {
                Controllers.dialog(I18n.i18n("fatal.unsupported_platform.windows_arm64"), null, MessageDialogPane.MessageType.INFO, continueAction);
            } else if (OperatingSystem.CURRENT_OS == OperatingSystem.LINUX && (Architecture.SYSTEM_ARCH == Architecture.LOONGARCH64 || Architecture.SYSTEM_ARCH == Architecture.LOONGARCH64_OW || Architecture.SYSTEM_ARCH == Architecture.MIPS64EL)) {
                Controllers.dialog(I18n.i18n("fatal.unsupported_platform.loongarch"), null, MessageDialogPane.MessageType.INFO, continueAction);
            } else {
                Controllers.dialog(I18n.i18n("fatal.unsupported_platform"), null, MessageDialogPane.MessageType.WARNING, continueAction);
            }
        }
        if (ConfigHolder.globalConfig().getAgreementVersion() < 1) {
            JFXDialogLayout agreementPane = new JFXDialogLayout();
            agreementPane.setHeading(new Node[]{new Label(I18n.i18n("launcher.agreement"))});
            agreementPane.setBody(new Node[]{new Label(I18n.i18n("launcher.agreement.hint"))});
            JFXHyperlink agreementLink = new JFXHyperlink(I18n.i18n("launcher.agreement"));
            agreementLink.setExternalLink("https://docs.hmcl.net/eula/hmcl.html");
            JFXButton yesButton = new JFXButton(I18n.i18n("launcher.agreement.accept"));
            yesButton.getStyleClass().add((Object)"dialog-accept");
            yesButton.setOnAction(e -> {
                ConfigHolder.globalConfig().setAgreementVersion(1);
                agreementPane.fireEvent(new DialogCloseEvent());
            });
            JFXButton noButton = new JFXButton(I18n.i18n("launcher.agreement.decline"));
            noButton.getStyleClass().add((Object)"dialog-cancel");
            noButton.setOnAction(e -> Platform.exit());
            agreementPane.setActions(new Node[]{agreementLink, yesButton, noButton});
            Controllers.dialog((Region)agreementPane);
        }
    }

    public static void dialog(Region content) {
        if (decorator != null) {
            decorator.showDialog((Node)content);
        }
    }

    public static void dialog(String text) {
        Controllers.dialog(text, null);
    }

    public static void dialog(String text, String title) {
        Controllers.dialog(text, title, MessageDialogPane.MessageType.INFO);
    }

    public static void dialog(String text, String title, MessageDialogPane.MessageType type) {
        Controllers.dialog(text, title, type, null);
    }

    public static void dialog(String text, String title, MessageDialogPane.MessageType type, Runnable ok) {
        Controllers.dialog((Region)new MessageDialogPane.Builder(text, title, type).ok(ok).build());
    }

    public static void confirm(String text, String title, Runnable yes, Runnable no) {
        Controllers.confirm(text, title, MessageDialogPane.MessageType.QUESTION, yes, no);
    }

    public static void confirm(String text, String title, MessageDialogPane.MessageType type, Runnable yes, Runnable no) {
        Controllers.dialog((Region)new MessageDialogPane.Builder(text, title, type).yesOrNo(yes, no).build());
    }

    public static void confirmAction(String text, String title, MessageDialogPane.MessageType type, ButtonBase actionButton) {
        Controllers.dialog((Region)new MessageDialogPane.Builder(text, title, type).actionOrCancel(actionButton, null).build());
    }

    public static void confirmAction(String text, String title, MessageDialogPane.MessageType type, ButtonBase actionButton, Runnable cancel) {
        Controllers.dialog((Region)new MessageDialogPane.Builder(text, title, type).actionOrCancel(actionButton, cancel).build());
    }

    public static CompletableFuture<String> prompt(String title, FutureCallback<String> onResult) {
        return Controllers.prompt(title, onResult, "");
    }

    public static CompletableFuture<String> prompt(String title, FutureCallback<String> onResult, String initialValue) {
        InputDialogPane pane = new InputDialogPane(title, initialValue, onResult);
        Controllers.dialog((Region)pane);
        return pane.getCompletableFuture();
    }

    public static CompletableFuture<List<PromptDialogPane.Builder.Question<?>>> prompt(PromptDialogPane.Builder builder) {
        PromptDialogPane pane = new PromptDialogPane(builder);
        Controllers.dialog((Region)pane);
        return pane.getCompletableFuture();
    }

    public static TaskExecutorDialogPane taskDialog(TaskExecutor executor, String title, TaskCancellationAction onCancel) {
        TaskExecutorDialogPane pane = new TaskExecutorDialogPane(onCancel);
        pane.setTitle(title);
        pane.setExecutor(executor);
        Controllers.dialog((Region)pane);
        return pane;
    }

    public static TaskExecutorDialogPane taskDialog(Task<?> task, String title, TaskCancellationAction onCancel) {
        TaskExecutor executor = task.executor();
        TaskExecutorDialogPane pane = Controllers.taskDialog(executor, title, onCancel);
        executor.start();
        return pane;
    }

    public static void navigate(Node node) {
        decorator.navigate(node);
    }

    public static void showToast(String content) {
        decorator.showToast(content);
    }

    public static void onHyperlinkAction(String href) {
        if (href.startsWith("hmcl://")) {
            switch (href) {
                case "hmcl://settings/feedback": {
                    Controllers.getSettingsPage().showFeedback();
                    Controllers.navigate((Node)Controllers.getSettingsPage());
                }
            }
        } else {
            FXUtils.openLink(href);
        }
    }

    public static boolean isStopped() {
        return decorator == null;
    }

    public static void shutdown() {
        rootPage = null;
        versionPage = null;
        gameListPage = null;
        downloadPage = null;
        accountListPage = null;
        settingsPage = null;
        decorator = null;
        stage = null;
        scene = null;
        Controllers.onApplicationStop();
        FXUtils.shutdown();
    }

    static {
        stageX = new SimpleDoubleProperty();
        stageY = new SimpleDoubleProperty();
        stageWidth = new SimpleDoubleProperty();
        stageHeight = new SimpleDoubleProperty();
        versionPage = new Lazy<VersionPage>(VersionPage::new);
        gameListPage = new Lazy<GameListPage>(() -> {
            GameListPage gameListPage = new GameListPage();
            gameListPage.selectedProfileProperty().bindBidirectional(Profiles.selectedProfileProperty());
            gameListPage.profilesProperty().bindContent(Profiles.profilesProperty());
            FXUtils.applyDragListener((Node)gameListPage, ModpackHelper::isFileModpackByExtension, modpacks -> {
                File modpack = (File)modpacks.get(0);
                Controllers.getDecorator().startWizard(new ModpackInstallWizardProvider(Profiles.getSelectedProfile(), modpack), I18n.i18n("install.modpack"));
            });
            return gameListPage;
        });
        rootPage = new Lazy<RootPage>(RootPage::new);
        downloadPage = new Lazy<DownloadPage>(DownloadPage::new);
        accountListPage = new Lazy<AccountListPage>(() -> {
            AccountListPage accountListPage = new AccountListPage();
            accountListPage.selectedAccountProperty().bindBidirectional(Accounts.selectedAccountProperty());
            accountListPage.accountsProperty().bindContent(Accounts.getAccounts());
            accountListPage.authServersProperty().bindContentBidirectional(ConfigHolder.config().getAuthlibInjectorServers());
            return accountListPage;
        });
        settingsPage = new Lazy<LauncherSettingsPage>(LauncherSettingsPage::new);
    }
}

