/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui;

import com.jfoenix.controls.JFXButton;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.scene.text.Text;
import javafx.scene.text.TextFlow;
import javafx.stage.Stage;
import org.jackhuang.hmcl.Metadata;
import org.jackhuang.hmcl.download.LibraryAnalyzer;
import org.jackhuang.hmcl.game.CrashReportAnalyzer;
import org.jackhuang.hmcl.game.DefaultGameRepository;
import org.jackhuang.hmcl.game.LaunchOptions;
import org.jackhuang.hmcl.game.Log;
import org.jackhuang.hmcl.game.LogExporter;
import org.jackhuang.hmcl.game.Version;
import org.jackhuang.hmcl.launch.ProcessListener;
import org.jackhuang.hmcl.setting.ConfigHolder;
import org.jackhuang.hmcl.setting.Theme;
import org.jackhuang.hmcl.task.Schedulers;
import org.jackhuang.hmcl.task.Task;
import org.jackhuang.hmcl.ui.Controllers;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.LogWindow;
import org.jackhuang.hmcl.ui.construct.TwoLineListItem;
import org.jackhuang.hmcl.util.Lang;
import org.jackhuang.hmcl.util.Log4jLevel;
import org.jackhuang.hmcl.util.Pair;
import org.jackhuang.hmcl.util.StringUtils;
import org.jackhuang.hmcl.util.i18n.I18n;
import org.jackhuang.hmcl.util.io.FileUtils;
import org.jackhuang.hmcl.util.logging.Logger;
import org.jackhuang.hmcl.util.platform.Architecture;
import org.jackhuang.hmcl.util.platform.CommandBuilder;
import org.jackhuang.hmcl.util.platform.ManagedProcess;
import org.jackhuang.hmcl.util.platform.OperatingSystem;

public class GameCrashWindow
extends Stage {
    private final Version version;
    private final String memory;
    private final String total_memory;
    private final String java;
    private final LibraryAnalyzer analyzer;
    private final TextFlow reasonTextFlow = new TextFlow(new Node[]{new Text(I18n.i18n("game.crash.reason.unknown"))});
    private final BooleanProperty loading = new SimpleBooleanProperty();
    private final TextFlow feedbackTextFlow = new TextFlow();
    private final ManagedProcess managedProcess;
    private final DefaultGameRepository repository;
    private final ProcessListener.ExitType exitType;
    private final LaunchOptions launchOptions;
    private final View view;
    private final List<Log> logs;
    private static final Pattern FABRIC_MOD_ID = Pattern.compile("\\{(?<modid>.*?) @ (?<version>.*?)}");

    public GameCrashWindow(ManagedProcess managedProcess, ProcessListener.ExitType exitType, DefaultGameRepository repository, Version version, LaunchOptions launchOptions, List<Log> logs) {
        this.managedProcess = managedProcess;
        this.exitType = exitType;
        this.repository = repository;
        this.version = version;
        this.launchOptions = launchOptions;
        this.logs = logs;
        this.analyzer = LibraryAnalyzer.analyze(version, repository.getGameVersion(version).orElse(null));
        this.memory = Optional.ofNullable(launchOptions.getMaxMemory()).map(i -> i + " MB").orElse("-");
        this.total_memory = OperatingSystem.TOTAL_MEMORY + " MB";
        this.java = launchOptions.getJava().getArchitecture() == Architecture.SYSTEM_ARCH ? launchOptions.getJava().getVersion() : launchOptions.getJava().getVersion() + " (" + launchOptions.getJava().getArchitecture().getDisplayName() + ")";
        this.view = new View();
        this.feedbackTextFlow.getChildren().addAll(FXUtils.parseSegment(I18n.i18n("game.crash.feedback"), Controllers::onHyperlinkAction));
        this.setScene(new Scene((Parent)this.view, 800.0, 480.0));
        this.getScene().getStylesheets().addAll((Object[])Theme.getTheme().getStylesheets(ConfigHolder.config().getLauncherFontFamily()));
        this.setTitle(I18n.i18n("game.crash.title"));
        FXUtils.setIcon(this);
        this.analyzeCrashReport();
    }

    private void analyzeCrashReport() {
        this.loading.set(true);
        Task.allOf(Task.supplyAsync(() -> {
            String rawLog = this.logs.stream().map(Log::getLog).collect(Collectors.joining("\n"));
            String crashReport = null;
            try {
                crashReport = CrashReportAnalyzer.findCrashReport(rawLog);
            }
            catch (IOException e) {
                Logger.LOG.warning("Failed to read crash report", e);
            }
            if (crashReport == null) {
                crashReport = CrashReportAnalyzer.extractCrashReport(rawLog);
            }
            return Pair.pair(CrashReportAnalyzer.anaylze(rawLog), crashReport != null ? CrashReportAnalyzer.findKeywordsFromCrashReport(crashReport) : new HashSet());
        }), Task.supplyAsync(() -> {
            String log;
            Path latestLog = this.repository.getRunDirectory(this.version.getId()).toPath().resolve("logs/latest.log");
            if (!Files.isReadable(latestLog)) {
                return Pair.pair(new HashSet(), new HashSet());
            }
            try {
                log = FileUtils.readText(latestLog);
            }
            catch (IOException e) {
                Logger.LOG.warning("Failed to read logs/latest.log", e);
                return Pair.pair(new HashSet(), new HashSet());
            }
            return Pair.pair(CrashReportAnalyzer.anaylze(log), CrashReportAnalyzer.findKeywordsFromCrashReport(log));
        })).whenComplete(Schedulers.javafx(), (taskResult, exception) -> {
            this.loading.set(false);
            if (exception != null) {
                Logger.LOG.warning("Failed to analyze crash report", exception);
                this.reasonTextFlow.getChildren().setAll(FXUtils.parseSegment(I18n.i18n("game.crash.reason.unknown"), Controllers::onHyperlinkAction));
            } else {
                EnumMap<CrashReportAnalyzer.Rule, CrashReportAnalyzer.Result> results = new EnumMap<CrashReportAnalyzer.Rule, CrashReportAnalyzer.Result>(CrashReportAnalyzer.Rule.class);
                HashSet keywords = new HashSet();
                for (Pair pair : taskResult) {
                    for (CrashReportAnalyzer.Result result : (Set)pair.getKey()) {
                        results.put(result.getRule(), result);
                    }
                    keywords.addAll((Collection)pair.getValue());
                }
                ArrayList<Node> segments = new ArrayList<Node>(FXUtils.parseSegment(I18n.i18n("game.crash.feedback"), Controllers::onHyperlinkAction));
                Logger.LOG.info("Number of reasons: " + results.size());
                if (results.size() > 1) {
                    segments.add((Node)new Text("\n"));
                    segments.addAll(FXUtils.parseSegment(I18n.i18n("game.crash.reason.multiple"), Controllers::onHyperlinkAction));
                } else {
                    segments.add((Node)new Text("\n\n"));
                }
                for (CrashReportAnalyzer.Result result : results.values()) {
                    String message;
                    switch (result.getRule()) {
                        case TOO_OLD_JAVA: {
                            message = I18n.i18n("game.crash.reason.too_old_java", CrashReportAnalyzer.getJavaVersionFromMajorVersion(Integer.parseInt(result.getMatcher().group("expected"))));
                            break;
                        }
                        case MOD_RESOLUTION_CONFLICT: 
                        case MOD_RESOLUTION_MISSING: 
                        case MOD_RESOLUTION_COLLECTION: {
                            message = I18n.i18n("game.crash.reason." + result.getRule().name().toLowerCase(Locale.ROOT), this.translateFabricModId(result.getMatcher().group("sourcemod")), this.parseFabricModId(result.getMatcher().group("destmod")), this.parseFabricModId(result.getMatcher().group("destmod")));
                            break;
                        }
                        case MOD_RESOLUTION_MISSING_MINECRAFT: {
                            message = I18n.i18n("game.crash.reason." + result.getRule().name().toLowerCase(Locale.ROOT), this.translateFabricModId(result.getMatcher().group("mod")), result.getMatcher().group("version"));
                            break;
                        }
                        case MOD_FOREST_OPTIFINE: 
                        case TWILIGHT_FOREST_OPTIFINE: 
                        case PERFORMANT_FOREST_OPTIFINE: 
                        case JADE_FOREST_OPTIFINE: 
                        case NEOFORGE_FOREST_OPTIFINE: {
                            message = I18n.i18n("game.crash.reason.mod", "OptiFine");
                            Logger.LOG.info("Crash cause: " + (Object)((Object)result.getRule()) + ": " + I18n.i18n("game.crash.reason.mod", "OptiFine"));
                            break;
                        }
                        default: {
                            message = I18n.i18n("game.crash.reason." + result.getRule().name().toLowerCase(Locale.ROOT), Arrays.stream(result.getRule().getGroupNames()).map(groupName -> result.getMatcher().group((String)groupName)).toArray());
                        }
                    }
                    Logger.LOG.info("Crash cause: " + (Object)((Object)result.getRule()) + ": " + message);
                    segments.addAll(FXUtils.parseSegment(message, Controllers::onHyperlinkAction));
                    segments.add((Node)new Text("\n\n"));
                }
                if (results.isEmpty()) {
                    if (!keywords.isEmpty()) {
                        this.reasonTextFlow.getChildren().setAll((Object[])new Node[]{new Text(I18n.i18n("game.crash.reason.stacktrace", String.join((CharSequence)", ", keywords)))});
                        Logger.LOG.info("Crash reason unknown, but some log keywords have been found: " + String.join((CharSequence)", ", keywords));
                    } else {
                        this.reasonTextFlow.getChildren().setAll(FXUtils.parseSegment(I18n.i18n("game.crash.reason.unknown"), Controllers::onHyperlinkAction));
                        Logger.LOG.info("Crash reason unknown");
                    }
                } else {
                    this.feedbackTextFlow.setVisible(false);
                    this.reasonTextFlow.getChildren().setAll(segments);
                }
            }
        }).start();
    }

    private String translateFabricModId(String modName) {
        switch (modName) {
            case "fabricloader": {
                return "Fabric";
            }
            case "fabric": {
                return "Fabric API";
            }
            case "minecraft": {
                return "Minecraft";
            }
        }
        return modName;
    }

    private String parseFabricModId(String modName) {
        Matcher matcher = FABRIC_MOD_ID.matcher(modName);
        if (matcher.find()) {
            String modid = matcher.group("modid");
            String version = matcher.group("version");
            if ("[*]".equals(version)) {
                return I18n.i18n("game.crash.reason.mod_resolution_mod_version.any", this.translateFabricModId(modid));
            }
            return I18n.i18n("game.crash.reason.mod_resolution_mod_version", this.translateFabricModId(modid), version);
        }
        return this.translateFabricModId(modName);
    }

    private void showLogWindow() {
        LogWindow logWindow = new LogWindow(this.managedProcess);
        logWindow.logLine(new Log(Logger.filterForbiddenToken("Command: " + new CommandBuilder().addAll(this.managedProcess.getCommands())), Log4jLevel.INFO));
        if (this.managedProcess.getClasspath() != null) {
            logWindow.logLine(new Log("ClassPath: " + this.managedProcess.getClasspath(), Log4jLevel.INFO));
        }
        logWindow.logLines(this.logs);
        logWindow.show();
    }

    private void exportGameCrashInfo() {
        Path logFile = Paths.get("minecraft-exported-crash-info-" + LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH-mm-ss")) + ".zip", new String[0]).toAbsolutePath();
        ((CompletableFuture)CompletableFuture.supplyAsync(() -> this.logs.stream().map(Log::getLog).collect(Collectors.joining(OperatingSystem.LINE_SEPARATOR))).thenComposeAsync(logs -> LogExporter.exportLogs(logFile, this.repository, this.launchOptions.getVersionName(), logs, new CommandBuilder().addAll(this.managedProcess.getCommands()).toString()))).handleAsync((result, exception) -> {
            Alert alert;
            if (exception == null) {
                FXUtils.showFileInExplorer(logFile);
                alert = new Alert(Alert.AlertType.INFORMATION, I18n.i18n("settings.launcher.launcher_log.export.success", logFile), new ButtonType[0]);
            } else {
                Logger.LOG.warning("Failed to export game crash info", (Throwable)exception);
                alert = new Alert(Alert.AlertType.WARNING, I18n.i18n("settings.launcher.launcher_log.export.failed") + "\n" + StringUtils.getStackTrace(exception), new ButtonType[0]);
            }
            alert.setTitle(I18n.i18n("settings.launcher.launcher_log.export"));
            alert.showAndWait();
            return null;
        });
    }

    private final class View
    extends VBox {
        View() {
            this.setStyle("-fx-background-color: white");
            HBox titlePane = new HBox();
            Label title = new Label();
            HBox.setHgrow((Node)title, (Priority)Priority.ALWAYS);
            switch (GameCrashWindow.this.exitType) {
                case JVM_ERROR: {
                    title.setText(I18n.i18n("launch.failed.cannot_create_jvm"));
                    break;
                }
                case APPLICATION_ERROR: {
                    title.setText(I18n.i18n("launch.failed.exited_abnormally"));
                    break;
                }
                case SIGKILL: {
                    title.setText(I18n.i18n("launch.failed.sigkill"));
                }
            }
            titlePane.setAlignment(Pos.CENTER);
            titlePane.getStyleClass().addAll((Object[])new String[]{"jfx-tool-bar-second", "depth-1", "padding-8"});
            titlePane.getChildren().setAll((Object[])new Node[]{title});
            HBox infoPane = new HBox(8.0);
            infoPane.setPadding(new Insets(8.0));
            infoPane.setAlignment(Pos.CENTER_LEFT);
            TwoLineListItem launcher = new TwoLineListItem();
            launcher.getStyleClass().setAll((Object[])new String[]{"two-line-item-second-large"});
            launcher.setTitle(I18n.i18n("launcher"));
            launcher.setSubtitle(Metadata.VERSION);
            LibraryAnalyzer.LibraryType[] version = new TwoLineListItem();
            version.getStyleClass().setAll((Object[])new String[]{"two-line-item-second-large"});
            version.setTitle(I18n.i18n("game.version"));
            version.setSubtitle(GameCrashWindow.this.version.getId());
            TwoLineListItem total_memory = new TwoLineListItem();
            total_memory.getStyleClass().setAll((Object[])new String[]{"two-line-item-second-large"});
            total_memory.setTitle(I18n.i18n("settings.physical_memory"));
            total_memory.setSubtitle(GameCrashWindow.this.total_memory);
            TwoLineListItem memory = new TwoLineListItem();
            memory.getStyleClass().setAll((Object[])new String[]{"two-line-item-second-large"});
            memory.setTitle(I18n.i18n("settings.memory"));
            memory.setSubtitle(GameCrashWindow.this.memory);
            TwoLineListItem java = new TwoLineListItem();
            java.getStyleClass().setAll((Object[])new String[]{"two-line-item-second-large"});
            java.setTitle("Java");
            java.setSubtitle(GameCrashWindow.this.java);
            TwoLineListItem os = new TwoLineListItem();
            os.getStyleClass().setAll((Object[])new String[]{"two-line-item-second-large"});
            os.setTitle(I18n.i18n("system.operating_system"));
            os.setSubtitle(Lang.requireNonNullElse(OperatingSystem.OS_RELEASE_NAME, OperatingSystem.SYSTEM_NAME));
            TwoLineListItem arch = new TwoLineListItem();
            arch.getStyleClass().setAll((Object[])new String[]{"two-line-item-second-large"});
            arch.setTitle(I18n.i18n("system.architecture"));
            arch.setSubtitle(Architecture.SYSTEM_ARCH.getDisplayName());
            infoPane.getChildren().setAll((Object[])new Node[]{launcher, version, total_memory, memory, java, os, arch});
            HBox moddedPane = new HBox(8.0);
            moddedPane.setPadding(new Insets(8.0));
            moddedPane.setAlignment(Pos.CENTER_LEFT);
            for (LibraryAnalyzer.LibraryType type : LibraryAnalyzer.LibraryType.values()) {
                if (type.getPatchId().isEmpty()) continue;
                GameCrashWindow.this.analyzer.getVersion(type).ifPresent(ver -> {
                    TwoLineListItem item = new TwoLineListItem();
                    item.getStyleClass().setAll((Object[])new String[]{"two-line-item-second-large"});
                    item.setTitle(I18n.i18n("install.installer." + type.getPatchId()));
                    item.setSubtitle((String)ver);
                    moddedPane.getChildren().add((Object)item);
                });
            }
            VBox gameDirPane = new VBox(8.0);
            TwoLineListItem gameDir = new TwoLineListItem();
            gameDir.getStyleClass().setAll((Object[])new String[]{"two-line-item-second-large"});
            gameDir.setTitle(I18n.i18n("game.directory"));
            gameDir.setSubtitle(GameCrashWindow.this.launchOptions.getGameDir().getAbsolutePath());
            FXUtils.installFastTooltip((Node)gameDir, I18n.i18n("game.directory"));
            TwoLineListItem javaDir = new TwoLineListItem();
            javaDir.getStyleClass().setAll((Object[])new String[]{"two-line-item-second-large"});
            javaDir.setTitle(I18n.i18n("settings.game.java_directory"));
            javaDir.setSubtitle(GameCrashWindow.this.launchOptions.getJava().getBinary().toAbsolutePath().toString());
            FXUtils.installFastTooltip((Node)javaDir, I18n.i18n("settings.game.java_directory"));
            Label reasonTitle = new Label(I18n.i18n("game.crash.reason"));
            reasonTitle.getStyleClass().add((Object)"two-line-item-second-large-title");
            ScrollPane reasonPane = new ScrollPane((Node)GameCrashWindow.this.reasonTextFlow);
            reasonPane.setFitToWidth(true);
            reasonPane.setHbarPolicy(ScrollPane.ScrollBarPolicy.NEVER);
            reasonPane.setVbarPolicy(ScrollPane.ScrollBarPolicy.AS_NEEDED);
            gameDirPane.setPadding(new Insets(8.0));
            VBox.setVgrow((Node)gameDirPane, (Priority)Priority.ALWAYS);
            FXUtils.onChangeAndOperate(GameCrashWindow.this.feedbackTextFlow.visibleProperty(), visible -> {
                if (visible.booleanValue()) {
                    gameDirPane.getChildren().setAll((Object[])new Node[]{gameDir, javaDir, new VBox(new Node[]{reasonTitle, reasonPane, GameCrashWindow.this.feedbackTextFlow})});
                } else {
                    gameDirPane.getChildren().setAll((Object[])new Node[]{gameDir, javaDir, new VBox(new Node[]{reasonTitle, reasonPane})});
                }
            });
            HBox toolBar = new HBox();
            JFXButton exportGameCrashInfoButton = FXUtils.newRaisedButton(I18n.i18n("logwindow.export_game_crash_logs"));
            exportGameCrashInfoButton.setOnAction(e -> GameCrashWindow.this.exportGameCrashInfo());
            JFXButton logButton = FXUtils.newRaisedButton(I18n.i18n("logwindow.title"));
            logButton.setOnAction(e -> GameCrashWindow.this.showLogWindow());
            JFXButton helpButton = FXUtils.newRaisedButton(I18n.i18n("help"));
            helpButton.setOnAction(e -> FXUtils.openLink("https://docs.hmcl.net/help.html"));
            FXUtils.installFastTooltip((Node)helpButton, I18n.i18n("logwindow.help"));
            toolBar.setPadding(new Insets(8.0));
            toolBar.setSpacing(8.0);
            toolBar.getStyleClass().add((Object)"jfx-tool-bar");
            toolBar.getChildren().setAll((Object[])new Node[]{exportGameCrashInfoButton, logButton, helpButton});
            this.getChildren().setAll((Object[])new Node[]{titlePane, infoPane, moddedPane, gameDirPane, toolBar});
        }
    }
}

