/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.account;

import java.util.function.Consumer;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import org.jackhuang.hmcl.auth.AuthInfo;
import org.jackhuang.hmcl.auth.OAuthAccount;
import org.jackhuang.hmcl.game.OAuthServer;
import org.jackhuang.hmcl.setting.Accounts;
import org.jackhuang.hmcl.task.Schedulers;
import org.jackhuang.hmcl.task.Task;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.WeakListenerHolder;
import org.jackhuang.hmcl.ui.construct.DialogPane;
import org.jackhuang.hmcl.ui.construct.HintPane;
import org.jackhuang.hmcl.ui.construct.JFXHyperlink;
import org.jackhuang.hmcl.ui.construct.MessageDialogPane;
import org.jackhuang.hmcl.util.i18n.I18n;
import org.jackhuang.hmcl.util.logging.Logger;

public class OAuthAccountLoginDialog
extends DialogPane {
    private final OAuthAccount account;
    private final Consumer<AuthInfo> success;
    private final Runnable failed;
    private final ObjectProperty<OAuthServer.GrantDeviceCodeEvent> deviceCode = new SimpleObjectProperty();
    private final WeakListenerHolder holder = new WeakListenerHolder();

    public OAuthAccountLoginDialog(OAuthAccount account, Consumer<AuthInfo> success, Runnable failed) {
        this.account = account;
        this.success = success;
        this.failed = failed;
        this.setTitle(I18n.i18n("account.login.refresh"));
        VBox vbox = new VBox(8.0);
        Label usernameLabel = new Label(account.getUsername());
        HintPane hintPane = new HintPane(MessageDialogPane.MessageType.INFO);
        FXUtils.onChangeAndOperate(this.deviceCode, deviceCode -> {
            if (deviceCode != null) {
                FXUtils.copyText(deviceCode.getUserCode());
                hintPane.setSegment("<b>" + I18n.i18n("account.login.refresh.microsoft.hint") + "</b>\n" + I18n.i18n("account.methods.microsoft.manual", deviceCode.getUserCode(), deviceCode.getVerificationUri()));
            } else {
                hintPane.setSegment("<b>" + I18n.i18n("account.login.refresh.microsoft.hint") + "</b>\n" + I18n.i18n("account.methods.microsoft.hint"));
            }
        });
        FXUtils.onClicked((Node)hintPane, () -> {
            if (this.deviceCode.get() != null) {
                FXUtils.copyText(((OAuthServer.GrantDeviceCodeEvent)this.deviceCode.get()).getUserCode());
            }
        });
        HBox box = new HBox(8.0);
        JFXHyperlink birthLink = new JFXHyperlink(I18n.i18n("account.methods.microsoft.birth"));
        birthLink.setOnAction(e -> FXUtils.openLink("https://support.microsoft.com/account-billing/how-to-change-a-birth-date-on-a-microsoft-account-837badbc-999e-54d2-2617-d19206b9540a"));
        JFXHyperlink profileLink = new JFXHyperlink(I18n.i18n("account.methods.microsoft.profile"));
        profileLink.setOnAction(e -> FXUtils.openLink("https://account.live.com/editprof.aspx"));
        JFXHyperlink purchaseLink = new JFXHyperlink(I18n.i18n("account.methods.microsoft.purchase"));
        purchaseLink.setOnAction(e -> FXUtils.openLink("https://www.microsoft.com/store/productid/9nxp44l49shj"));
        box.getChildren().setAll((Object[])new Node[]{profileLink, birthLink, purchaseLink});
        GridPane.setColumnSpan((Node)box, (Integer)2);
        vbox.getChildren().setAll((Object[])new Node[]{usernameLabel, hintPane, box});
        this.setBody(new Node[]{vbox});
        this.holder.add(Accounts.OAUTH_CALLBACK.onGrantDeviceCode.registerWeak(this::onGrantDeviceCode));
    }

    private void onGrantDeviceCode(OAuthServer.GrantDeviceCodeEvent event) {
        FXUtils.runInFX(() -> this.deviceCode.set((Object)event));
    }

    @Override
    protected void onAccept() {
        this.setLoading();
        Task.supplyAsync(this.account::logInWhenCredentialsExpired).whenComplete(Schedulers.javafx(), (authInfo, exception) -> {
            if (exception == null) {
                this.success.accept((AuthInfo)authInfo);
                this.onSuccess();
            } else {
                Logger.LOG.info("Failed to login when credentials expired: " + this.account, exception);
                this.onFailure(Accounts.localizeErrorMessage(exception));
            }
        }).start();
    }

    @Override
    protected void onCancel() {
        this.failed.run();
        super.onCancel();
    }
}

