/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.animation;

import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.scene.Node;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.util.Duration;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.animation.AnimationHandler;
import org.jackhuang.hmcl.ui.animation.AnimationProducer;
import org.jackhuang.hmcl.ui.animation.AnimationUtils;
import org.jackhuang.hmcl.ui.animation.ContainerAnimations;

public class TransitionPane
extends StackPane
implements AnimationHandler {
    private static final Duration DEFAULT_DURATION = Duration.millis((double)200.0);
    private Duration duration;
    private Node previousNode;
    private Node currentNode = this.getChildren().stream().findFirst().orElse(null);
    private final EmptyPane EMPTY_PANE;

    public TransitionPane() {
        FXUtils.setOverflowHidden((Region)this);
        this.EMPTY_PANE = new EmptyPane();
    }

    @Override
    public Node getPreviousNode() {
        return this.previousNode;
    }

    @Override
    public Node getCurrentNode() {
        return this.currentNode;
    }

    public StackPane getCurrentRoot() {
        return this;
    }

    @Override
    public Duration getDuration() {
        return this.duration;
    }

    public void setContent(Node newView, AnimationProducer transition) {
        this.setContent(newView, transition, DEFAULT_DURATION);
    }

    public void setContent(Node newView, AnimationProducer transition, Duration duration) {
        this.duration = duration;
        this.updateContent(newView);
        if (this.previousNode == this.EMPTY_PANE) {
            this.getChildren().setAll((Object[])new Node[]{newView});
            return;
        }
        if (AnimationUtils.isAnimationEnabled() && transition != ContainerAnimations.NONE) {
            this.setMouseTransparent(true);
            transition.init(this);
            Platform.runLater(() -> {
                Timeline newAnimation = new Timeline();
                newAnimation.getKeyFrames().setAll(transition.animate(this));
                newAnimation.setOnFinished(e -> {
                    this.setMouseTransparent(false);
                    this.getChildren().remove((Object)this.previousNode);
                });
                FXUtils.playAnimation((Node)this, "transition_pane", newAnimation);
            });
        } else {
            this.getChildren().remove((Object)this.previousNode);
        }
    }

    private void updateContent(Node newView) {
        if (this.getWidth() > 0.0 && this.getHeight() > 0.0) {
            this.previousNode = this.currentNode;
            if (this.previousNode == null) {
                this.previousNode = this.EMPTY_PANE;
            }
        } else {
            this.previousNode = this.EMPTY_PANE;
        }
        if (this.previousNode == newView) {
            this.previousNode = this.EMPTY_PANE;
        }
        this.currentNode = newView;
        this.getChildren().setAll((Object[])new Node[]{this.previousNode, this.currentNode});
    }

    public static class EmptyPane
    extends StackPane {
    }
}

