/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.construct;

import com.jfoenix.controls.JFXRadioButton;
import com.jfoenix.controls.JFXTextField;
import com.jfoenix.validation.base.ValidatorBase;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleGroup;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import javafx.stage.FileChooser;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.construct.FileSelector;
import org.jackhuang.hmcl.util.StringUtils;

public final class MultiFileItem<T>
extends VBox {
    private final ObjectProperty<T> selectedData = new SimpleObjectProperty((Object)this, "selectedData");
    private final ObjectProperty<T> fallbackData = new SimpleObjectProperty((Object)this, "fallbackData");
    private final ToggleGroup group = new ToggleGroup();
    private Consumer<Toggle> toggleSelectedListener;

    public MultiFileItem() {
        this.setPadding(new Insets(0.0, 0.0, 10.0, 0.0));
        this.setSpacing(8.0);
        this.group.selectedToggleProperty().addListener((a, b, newValue) -> {
            this.selectedData.set(newValue != null ? newValue.getUserData() : null);
            if (this.toggleSelectedListener != null) {
                this.toggleSelectedListener.accept((Toggle)newValue);
            }
        });
        this.selectedData.addListener((a, b, newValue) -> {
            Optional<Toggle> selecting = this.group.getToggles().stream().filter(it -> Objects.equals(it.getUserData(), newValue)).findFirst();
            if (!selecting.isPresent()) {
                selecting = this.group.getToggles().stream().filter(it -> it.getUserData() == this.getFallbackData()).findFirst();
            }
            selecting.ifPresent(toggle -> toggle.setSelected(true));
        });
    }

    public void loadChildren(Collection<Option<T>> options) {
        this.getChildren().setAll((Collection)options.stream().map(option -> option.createItem(this.group)).collect(Collectors.toList()));
    }

    public ToggleGroup getGroup() {
        return this.group;
    }

    public void setToggleSelectedListener(Consumer<Toggle> consumer) {
        this.toggleSelectedListener = consumer;
    }

    public T getSelectedData() {
        return (T)this.selectedData.get();
    }

    public ObjectProperty<T> selectedDataProperty() {
        return this.selectedData;
    }

    public void setSelectedData(T selectedData) {
        this.selectedData.set(selectedData);
    }

    public T getFallbackData() {
        return (T)this.fallbackData.get();
    }

    public ObjectProperty<T> fallbackDataProperty() {
        return this.fallbackData;
    }

    public void setFallbackData(T fallbackData) {
        this.fallbackData.set(fallbackData);
    }

    public static class Option<T> {
        protected final String title;
        protected String subtitle;
        protected String tooltip;
        protected final T data;
        protected final BooleanProperty selected = new SimpleBooleanProperty();
        protected final JFXRadioButton left = new JFXRadioButton();

        public Option(String title, T data) {
            this.title = title;
            this.data = data;
        }

        public T getData() {
            return this.data;
        }

        public String getTitle() {
            return this.title;
        }

        public String getSubtitle() {
            return this.subtitle;
        }

        public Option<T> setSubtitle(String subtitle) {
            this.subtitle = subtitle;
            return this;
        }

        public Option<T> setTooltip(String tooltip) {
            this.tooltip = tooltip;
            return this;
        }

        public boolean isSelected() {
            return this.left.isSelected();
        }

        public BooleanProperty selectedProperty() {
            return this.left.selectedProperty();
        }

        public void setSelected(boolean selected) {
            this.left.setSelected(selected);
        }

        protected Node createItem(ToggleGroup group) {
            BorderPane pane = new BorderPane();
            pane.setPadding(new Insets(3.0));
            FXUtils.setLimitHeight((Region)pane, 30.0);
            this.left.setText(this.title);
            BorderPane.setAlignment((Node)this.left, (Pos)Pos.CENTER_LEFT);
            this.left.setToggleGroup(group);
            this.left.setUserData(this.data);
            if (StringUtils.isNotBlank(this.tooltip)) {
                FXUtils.installFastTooltip((Node)this.left, this.tooltip);
            }
            pane.setLeft((Node)this.left);
            if (StringUtils.isNotBlank(this.subtitle)) {
                Label center = new Label(this.subtitle);
                BorderPane.setAlignment((Node)center, (Pos)Pos.CENTER_RIGHT);
                center.setWrapText(true);
                center.getStyleClass().add((Object)"subtitle-label");
                center.setStyle("-fx-font-size: 10;");
                pane.setCenter((Node)center);
            }
            return pane;
        }
    }

    public static final class FileOption<T>
    extends Option<T> {
        private final FileSelector selector = new FileSelector();

        public FileOption(String title, T data) {
            super(title, data);
        }

        public String getValue() {
            return this.selector.getValue();
        }

        public StringProperty valueProperty() {
            return this.selector.valueProperty();
        }

        public void setValue(String value) {
            this.selector.setValue(value);
        }

        public FileOption<T> setDirectory(boolean directory) {
            this.selector.setDirectory(directory);
            return this;
        }

        public FileOption<T> bindBidirectional(Property<String> property) {
            this.selector.valueProperty().bindBidirectional(property);
            return this;
        }

        public FileOption<T> setChooserTitle(String chooserTitle) {
            this.selector.setChooserTitle(chooserTitle);
            return this;
        }

        public FileOption<T> addExtensionFilter(FileChooser.ExtensionFilter filter) {
            this.selector.getExtensionFilters().add((Object)filter);
            return this;
        }

        @Override
        protected Node createItem(ToggleGroup group) {
            BorderPane pane = new BorderPane();
            pane.setPadding(new Insets(3.0));
            FXUtils.setLimitHeight((Region)pane, 30.0);
            this.left.setText(this.title);
            BorderPane.setAlignment((Node)this.left, (Pos)Pos.CENTER_LEFT);
            this.left.setToggleGroup(group);
            this.left.setUserData(this.data);
            pane.setLeft((Node)this.left);
            this.selector.disableProperty().bind((ObservableValue)this.left.selectedProperty().not());
            BorderPane.setAlignment((Node)this.selector, (Pos)Pos.CENTER_RIGHT);
            pane.setRight((Node)this.selector);
            return pane;
        }
    }

    public static final class StringOption<T>
    extends Option<T> {
        private final JFXTextField customField = new JFXTextField();

        public StringOption(String title, T data) {
            super(title, data);
        }

        public JFXTextField getCustomField() {
            return this.customField;
        }

        public String getValue() {
            return this.customField.getText();
        }

        public StringProperty valueProperty() {
            return this.customField.textProperty();
        }

        public void setValue(String value) {
            this.customField.setText(value);
        }

        public StringOption<T> bindBidirectional(Property<String> property) {
            FXUtils.bindString(this.customField, property);
            return this;
        }

        public StringOption<T> setValidators(ValidatorBase ... validators) {
            this.customField.setValidators(validators);
            return this;
        }

        @Override
        protected Node createItem(ToggleGroup group) {
            BorderPane pane = new BorderPane();
            pane.setPadding(new Insets(3.0));
            FXUtils.setLimitHeight((Region)pane, 30.0);
            this.left.setText(this.title);
            BorderPane.setAlignment((Node)this.left, (Pos)Pos.CENTER_LEFT);
            this.left.setToggleGroup(group);
            this.left.setUserData(this.data);
            pane.setLeft((Node)this.left);
            BorderPane.setAlignment((Node)this.customField, (Pos)Pos.CENTER_RIGHT);
            this.customField.disableProperty().bind((ObservableValue)this.left.selectedProperty().not());
            if (!this.customField.getValidators().isEmpty()) {
                FXUtils.setValidateWhileTextChanged((Node)this.customField, true);
            }
            pane.setRight((Node)this.customField);
            return pane;
        }
    }
}

