/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.versions;

import com.jfoenix.controls.JFXComboBox;
import com.jfoenix.controls.JFXTextField;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Locale;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import org.jackhuang.hmcl.game.NativesDirectoryType;
import org.jackhuang.hmcl.game.Renderer;
import org.jackhuang.hmcl.setting.Profile;
import org.jackhuang.hmcl.setting.VersionSetting;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.construct.ComponentList;
import org.jackhuang.hmcl.ui.construct.ComponentSublist;
import org.jackhuang.hmcl.ui.construct.HintPane;
import org.jackhuang.hmcl.ui.construct.MessageDialogPane;
import org.jackhuang.hmcl.ui.construct.MultiFileItem;
import org.jackhuang.hmcl.ui.construct.NumberValidator;
import org.jackhuang.hmcl.ui.construct.OptionToggleButton;
import org.jackhuang.hmcl.ui.decorator.DecoratorPage;
import org.jackhuang.hmcl.util.i18n.I18n;

public final class AdvancedVersionSettingPage
extends StackPane
implements DecoratorPage {
    private final ObjectProperty<DecoratorPage.State> stateProperty;
    private final Profile profile;
    private final String versionId;
    private final VersionSetting versionSetting;
    private final JFXTextField txtJVMArgs;
    private final JFXTextField txtGameArgs;
    private final JFXTextField txtEnvironmentVariables;
    private final JFXTextField txtMetaspace;
    private final JFXTextField txtWrapper;
    private final JFXTextField txtPreLaunchCommand;
    private final JFXTextField txtPostExitCommand;
    private final OptionToggleButton noJVMArgsPane;
    private final OptionToggleButton noGameCheckPane;
    private final OptionToggleButton noJVMCheckPane;
    private final OptionToggleButton noNativesPatchPane;
    private final OptionToggleButton useNativeGLFWPane;
    private final OptionToggleButton useNativeOpenALPane;
    private final ComponentSublist nativesDirSublist;
    private final MultiFileItem<NativesDirectoryType> nativesDirItem;
    private final MultiFileItem.FileOption<NativesDirectoryType> nativesDirCustomOption;
    private final JFXComboBox<Renderer> cboRenderer;

    public AdvancedVersionSettingPage(Profile profile, String versionId, VersionSetting versionSetting) {
        this.profile = profile;
        this.versionId = versionId;
        this.versionSetting = versionSetting;
        this.stateProperty = new SimpleObjectProperty((Object)DecoratorPage.State.fromTitle(versionId == null ? I18n.i18n("settings.advanced") : I18n.i18n("settings.advanced.title", versionId)));
        this.getStyleClass().add((Object)"gray-background");
        ScrollPane scrollPane = new ScrollPane();
        scrollPane.setFitToHeight(true);
        scrollPane.setFitToWidth(true);
        scrollPane.setVbarPolicy(ScrollPane.ScrollBarPolicy.AS_NEEDED);
        this.getChildren().setAll((Object[])new Node[]{scrollPane});
        VBox rootPane = new VBox();
        rootPane.setFillWidth(true);
        scrollPane.setContent((Node)rootPane);
        FXUtils.smoothScrolling(scrollPane);
        rootPane.getStyleClass().add((Object)"card-list");
        ComponentList customCommandsPane = new ComponentList();
        GridPane pane = new GridPane();
        pane.setHgap(16.0);
        pane.setVgap(8.0);
        pane.getColumnConstraints().setAll((Object[])new ColumnConstraints[]{new ColumnConstraints(), FXUtils.getColumnHgrowing()});
        this.txtGameArgs = new JFXTextField();
        this.txtGameArgs.setPromptText(I18n.i18n("settings.advanced.minecraft_arguments.prompt"));
        this.txtGameArgs.getStyleClass().add((Object)"fit-width");
        pane.addRow(0, new Node[]{new Label(I18n.i18n("settings.advanced.minecraft_arguments")), this.txtGameArgs});
        this.txtPreLaunchCommand = new JFXTextField();
        this.txtPreLaunchCommand.setPromptText(I18n.i18n("settings.advanced.precall_command.prompt"));
        this.txtPreLaunchCommand.getStyleClass().add((Object)"fit-width");
        pane.addRow(1, new Node[]{new Label(I18n.i18n("settings.advanced.precall_command")), this.txtPreLaunchCommand});
        this.txtWrapper = new JFXTextField();
        this.txtWrapper.setPromptText(I18n.i18n("settings.advanced.wrapper_launcher.prompt"));
        this.txtWrapper.getStyleClass().add((Object)"fit-width");
        pane.addRow(2, new Node[]{new Label(I18n.i18n("settings.advanced.wrapper_launcher")), this.txtWrapper});
        this.txtPostExitCommand = new JFXTextField();
        this.txtPostExitCommand.setPromptText(I18n.i18n("settings.advanced.post_exit_command.prompt"));
        this.txtPostExitCommand.getStyleClass().add((Object)"fit-width");
        pane.addRow(3, new Node[]{new Label(I18n.i18n("settings.advanced.post_exit_command")), this.txtPostExitCommand});
        HintPane hintPane = new HintPane();
        hintPane.setText(I18n.i18n("settings.advanced.custom_commands.hint"));
        GridPane.setColumnSpan((Node)hintPane, (Integer)2);
        pane.addRow(4, new Node[]{hintPane});
        customCommandsPane.getContent().setAll((Object[])new Node[]{pane});
        ComponentList jvmPane = new ComponentList();
        GridPane pane2 = new GridPane();
        ColumnConstraints title = new ColumnConstraints();
        ColumnConstraints value = new ColumnConstraints();
        value.setFillWidth(true);
        value.setHgrow(Priority.ALWAYS);
        pane2.setHgap(16.0);
        pane2.setVgap(8.0);
        pane2.getColumnConstraints().setAll((Object[])new ColumnConstraints[]{title, value});
        this.txtJVMArgs = new JFXTextField();
        this.txtJVMArgs.getStyleClass().add((Object)"fit-width");
        pane2.addRow(0, new Node[]{new Label(I18n.i18n("settings.advanced.jvm_args")), this.txtJVMArgs});
        HintPane hintPane2 = new HintPane();
        hintPane2.setText(I18n.i18n("settings.advanced.jvm_args.prompt"));
        GridPane.setColumnSpan((Node)hintPane2, (Integer)2);
        pane2.addRow(4, new Node[]{hintPane2});
        this.txtMetaspace = new JFXTextField();
        this.txtMetaspace.setPromptText(I18n.i18n("settings.advanced.java_permanent_generation_space.prompt"));
        this.txtMetaspace.getStyleClass().add((Object)"fit-width");
        FXUtils.setValidateWhileTextChanged((Node)this.txtMetaspace, true);
        this.txtMetaspace.setValidators(new NumberValidator(I18n.i18n("input.number"), true));
        pane2.addRow(1, new Node[]{new Label(I18n.i18n("settings.advanced.java_permanent_generation_space")), this.txtMetaspace});
        this.txtEnvironmentVariables = new JFXTextField();
        this.txtEnvironmentVariables.getStyleClass().add((Object)"fit-width");
        pane2.addRow(2, new Node[]{new Label(I18n.i18n("settings.advanced.environment_variables")), this.txtEnvironmentVariables});
        jvmPane.getContent().setAll((Object[])new Node[]{pane2});
        ComponentList workaroundPane = new ComponentList();
        HintPane workaroundWarning = new HintPane(MessageDialogPane.MessageType.WARNING);
        workaroundWarning.setText(I18n.i18n("settings.advanced.workaround.warning"));
        this.nativesDirItem = new MultiFileItem();
        this.nativesDirSublist = new ComponentSublist();
        this.nativesDirSublist.getContent().add(this.nativesDirItem);
        this.nativesDirSublist.setTitle(I18n.i18n("settings.advanced.natives_directory"));
        this.nativesDirSublist.setHasSubtitle(true);
        this.nativesDirCustomOption = new MultiFileItem.FileOption<NativesDirectoryType>(I18n.i18n("settings.advanced.natives_directory.custom"), NativesDirectoryType.CUSTOM).setChooserTitle(I18n.i18n("settings.advanced.natives_directory.choose")).setDirectory(true);
        this.nativesDirItem.loadChildren(Arrays.asList(new MultiFileItem.Option<NativesDirectoryType>(I18n.i18n("settings.advanced.natives_directory.default"), NativesDirectoryType.VERSION_FOLDER), this.nativesDirCustomOption));
        HintPane nativesDirHint = new HintPane(MessageDialogPane.MessageType.WARNING);
        nativesDirHint.setText(I18n.i18n("settings.advanced.natives_directory.hint"));
        this.nativesDirItem.getChildren().add((Object)nativesDirHint);
        BorderPane rendererPane = new BorderPane();
        Label label = new Label(I18n.i18n("settings.advanced.renderer"));
        rendererPane.setLeft((Node)label);
        BorderPane.setAlignment((Node)label, (Pos)Pos.CENTER_LEFT);
        this.cboRenderer = new JFXComboBox();
        this.cboRenderer.getItems().setAll((Object[])Renderer.values());
        this.cboRenderer.setConverter(FXUtils.stringConverter(e -> I18n.i18n("settings.advanced.renderer." + e.name().toLowerCase(Locale.ROOT))));
        rendererPane.setRight(this.cboRenderer);
        BorderPane.setAlignment(this.cboRenderer, (Pos)Pos.CENTER_RIGHT);
        FXUtils.setLimitWidth(this.cboRenderer, 300.0);
        this.noJVMArgsPane = new OptionToggleButton();
        this.noJVMArgsPane.setTitle(I18n.i18n("settings.advanced.no_jvm_args"));
        this.noGameCheckPane = new OptionToggleButton();
        this.noGameCheckPane.setTitle(I18n.i18n("settings.advanced.dont_check_game_completeness"));
        this.noJVMCheckPane = new OptionToggleButton();
        this.noJVMCheckPane.setTitle(I18n.i18n("settings.advanced.dont_check_jvm_validity"));
        this.noNativesPatchPane = new OptionToggleButton();
        this.noNativesPatchPane.setTitle(I18n.i18n("settings.advanced.dont_patch_natives"));
        this.useNativeGLFWPane = new OptionToggleButton();
        this.useNativeGLFWPane.setTitle(I18n.i18n("settings.advanced.use_native_glfw"));
        this.useNativeOpenALPane = new OptionToggleButton();
        this.useNativeOpenALPane.setTitle(I18n.i18n("settings.advanced.use_native_openal"));
        workaroundPane.getContent().setAll((Object[])new Node[]{this.nativesDirSublist, rendererPane, this.noJVMArgsPane, this.noGameCheckPane, this.noJVMCheckPane, this.noNativesPatchPane, this.useNativeGLFWPane, this.useNativeOpenALPane});
        rootPane.getChildren().addAll((Object[])new Node[]{ComponentList.createComponentListTitle(I18n.i18n("settings.advanced.custom_commands")), customCommandsPane, ComponentList.createComponentListTitle(I18n.i18n("settings.advanced.jvm")), jvmPane, ComponentList.createComponentListTitle(I18n.i18n("settings.advanced.workaround")), workaroundWarning, workaroundPane});
        this.bindProperties();
    }

    void bindProperties() {
        this.nativesDirCustomOption.bindBidirectional((Property<String>)this.versionSetting.nativesDirProperty());
        FXUtils.bindString(this.txtJVMArgs, (Property<String>)this.versionSetting.javaArgsProperty());
        FXUtils.bindString(this.txtGameArgs, (Property<String>)this.versionSetting.minecraftArgsProperty());
        FXUtils.bindString(this.txtMetaspace, (Property<String>)this.versionSetting.permSizeProperty());
        FXUtils.bindString(this.txtEnvironmentVariables, (Property<String>)this.versionSetting.environmentVariablesProperty());
        FXUtils.bindString(this.txtWrapper, (Property<String>)this.versionSetting.wrapperProperty());
        FXUtils.bindString(this.txtPreLaunchCommand, (Property<String>)this.versionSetting.preLaunchCommandProperty());
        FXUtils.bindString(this.txtPostExitCommand, (Property<String>)this.versionSetting.postExitCommandProperty());
        FXUtils.bindEnum(this.cboRenderer, this.versionSetting.rendererProperty());
        this.noGameCheckPane.selectedProperty().bindBidirectional((Property)this.versionSetting.notCheckGameProperty());
        this.noJVMCheckPane.selectedProperty().bindBidirectional((Property)this.versionSetting.notCheckJVMProperty());
        this.noJVMArgsPane.selectedProperty().bindBidirectional((Property)this.versionSetting.noJVMArgsProperty());
        this.noNativesPatchPane.selectedProperty().bindBidirectional((Property)this.versionSetting.notPatchNativesProperty());
        this.useNativeGLFWPane.selectedProperty().bindBidirectional((Property)this.versionSetting.useNativeGLFWProperty());
        this.useNativeOpenALPane.selectedProperty().bindBidirectional((Property)this.versionSetting.useNativeOpenALProperty());
        this.nativesDirItem.selectedDataProperty().bindBidirectional(this.versionSetting.nativesDirTypeProperty());
        this.nativesDirSublist.subtitleProperty().bind((ObservableValue)Bindings.createStringBinding(() -> Paths.get(this.profile.getRepository().getRunDirectory(this.versionId).getAbsolutePath() + "/natives", new String[0]).normalize().toString(), (Observable[])new Observable[]{this.versionSetting.nativesDirProperty(), this.versionSetting.nativesDirTypeProperty()}));
    }

    void unbindProperties() {
        this.nativesDirCustomOption.valueProperty().unbindBidirectional((Property)this.versionSetting.nativesDirProperty());
        FXUtils.unbind(this.txtJVMArgs, this.versionSetting.javaArgsProperty());
        FXUtils.unbind(this.txtGameArgs, this.versionSetting.minecraftArgsProperty());
        FXUtils.unbind(this.txtMetaspace, this.versionSetting.permSizeProperty());
        FXUtils.unbind(this.txtEnvironmentVariables, this.versionSetting.environmentVariablesProperty());
        FXUtils.unbind(this.txtWrapper, this.versionSetting.wrapperProperty());
        FXUtils.unbind(this.txtPreLaunchCommand, this.versionSetting.preLaunchCommandProperty());
        FXUtils.unbind(this.txtPostExitCommand, this.versionSetting.postExitCommandProperty());
        FXUtils.unbindEnum(this.cboRenderer, this.versionSetting.rendererProperty());
        this.noGameCheckPane.selectedProperty().unbindBidirectional((Property)this.versionSetting.notCheckGameProperty());
        this.noJVMCheckPane.selectedProperty().unbindBidirectional((Property)this.versionSetting.notCheckJVMProperty());
        this.noJVMArgsPane.selectedProperty().unbindBidirectional((Property)this.versionSetting.noJVMArgsProperty());
        this.noNativesPatchPane.selectedProperty().unbindBidirectional((Property)this.versionSetting.notPatchNativesProperty());
        this.useNativeGLFWPane.selectedProperty().unbindBidirectional((Property)this.versionSetting.useNativeGLFWProperty());
        this.useNativeOpenALPane.selectedProperty().unbindBidirectional((Property)this.versionSetting.useNativeOpenALProperty());
        this.nativesDirItem.selectedDataProperty().unbindBidirectional(this.versionSetting.nativesDirTypeProperty());
        this.nativesDirSublist.subtitleProperty().unbind();
    }

    @Override
    public ReadOnlyObjectProperty<DecoratorPage.State> stateProperty() {
        return this.stateProperty;
    }
}

