/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.versions;

import java.io.File;
import java.nio.file.Path;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;
import javafx.stage.FileChooser;
import javafx.stage.Window;
import org.jackhuang.hmcl.game.World;
import org.jackhuang.hmcl.ui.Controllers;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.versions.DatapackListPage;
import org.jackhuang.hmcl.ui.versions.WorldBackupsPage;
import org.jackhuang.hmcl.ui.versions.WorldExportPage;
import org.jackhuang.hmcl.ui.versions.WorldInfoPage;
import org.jackhuang.hmcl.ui.versions.WorldListItemSkin;
import org.jackhuang.hmcl.ui.wizard.SinglePageWizardProvider;
import org.jackhuang.hmcl.util.i18n.I18n;
import org.jackhuang.hmcl.util.versioning.GameVersionNumber;

public final class WorldListItem
extends Control {
    private final World world;
    private final Path backupsDir;

    public WorldListItem(World world, Path backupsDir) {
        this.world = world;
        this.backupsDir = backupsDir;
    }

    protected Skin<?> createDefaultSkin() {
        return new WorldListItemSkin(this);
    }

    public World getWorld() {
        return this.world;
    }

    public void export() {
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle(I18n.i18n("world.export.title"));
        fileChooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter(I18n.i18n("world"), new String[]{"*.zip"}));
        fileChooser.setInitialFileName(this.world.getWorldName());
        File file = fileChooser.showSaveDialog((Window)Controllers.getStage());
        if (file == null) {
            return;
        }
        Controllers.getDecorator().startWizard(new SinglePageWizardProvider(controller -> new WorldExportPage(this.world, file.toPath(), controller::onFinish)));
    }

    public void reveal() {
        FXUtils.openFolder(this.world.getFile().toFile());
    }

    public void manageDatapacks() {
        if (this.world.getGameVersion() == null || GameVersionNumber.compare(this.world.getGameVersion(), "1.13") < 0) {
            Controllers.dialog(I18n.i18n("world.datapack.1_13"));
            return;
        }
        Controllers.navigate((Node)new DatapackListPage(this.world.getWorldName(), this.world.getFile()));
    }

    public void showInfo() {
        Controllers.navigate((Node)new WorldInfoPage(this.world));
    }

    public void showBackupPage() {
        Controllers.navigate((Node)new WorldBackupsPage(this.world, this.backupsDir));
    }
}

