/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.versions;

import com.jfoenix.controls.JFXButton;
import java.time.Instant;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.SkinBase;
import javafx.scene.image.ImageView;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Paint;
import org.jackhuang.hmcl.game.World;
import org.jackhuang.hmcl.setting.Theme;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.SVG;
import org.jackhuang.hmcl.ui.construct.RipplerContainer;
import org.jackhuang.hmcl.ui.construct.TwoLineListItem;
import org.jackhuang.hmcl.ui.versions.WorldListItem;
import org.jackhuang.hmcl.util.StringUtils;
import org.jackhuang.hmcl.util.i18n.I18n;

public final class WorldListItemSkin
extends SkinBase<WorldListItem> {
    public WorldListItemSkin(WorldListItem skinnable) {
        super((Control)skinnable);
        World world = skinnable.getWorld();
        BorderPane root = new BorderPane();
        root.getStyleClass().add((Object)"md-list-cell");
        root.setPadding(new Insets(8.0));
        StackPane left = new StackPane();
        FXUtils.installSlowTooltip((Node)left, world.getFile().toString());
        root.setLeft((Node)left);
        left.setPadding(new Insets(0.0, 8.0, 0.0, 0.0));
        ImageView imageView = new ImageView();
        left.getChildren().add((Object)imageView);
        FXUtils.limitSize(imageView, 32.0, 32.0);
        imageView.setImage(world.getIcon() == null ? FXUtils.newBuiltinImage("/assets/img/unknown_server.png") : world.getIcon());
        TwoLineListItem item = new TwoLineListItem();
        root.setCenter((Node)item);
        if (world.getWorldName() != null) {
            item.setTitle(StringUtils.parseColorEscapes(world.getWorldName()));
        }
        item.setSubtitle(I18n.i18n("world.datetime", I18n.formatDateTime(Instant.ofEpochMilli(world.getLastPlayed())), world.getGameVersion() == null ? I18n.i18n("message.unknown") : world.getGameVersion()));
        if (world.getGameVersion() != null) {
            item.getTags().add((Object)world.getGameVersion());
        }
        if (world.isLocked()) {
            item.getTags().add((Object)I18n.i18n("world.locked"));
        }
        HBox right = new HBox(8.0);
        root.setRight((Node)right);
        right.setAlignment(Pos.CENTER_RIGHT);
        JFXButton btnReveal = new JFXButton();
        right.getChildren().add((Object)btnReveal);
        FXUtils.installFastTooltip((Node)btnReveal, I18n.i18n("world.reveal"));
        btnReveal.getStyleClass().add((Object)"toggle-icon4");
        btnReveal.setGraphic(SVG.FOLDER_OPEN.createIcon((Paint)Theme.blackFill(), -1.0));
        btnReveal.setOnAction(event -> skinnable.reveal());
        JFXButton btnExport = new JFXButton();
        right.getChildren().add((Object)btnExport);
        FXUtils.installFastTooltip((Node)btnExport, I18n.i18n("world.export"));
        btnExport.getStyleClass().add((Object)"toggle-icon4");
        btnExport.setGraphic(SVG.OUTPUT.createIcon((Paint)Theme.blackFill(), -1.0));
        btnExport.setOnAction(event -> skinnable.export());
        JFXButton btnBackup = new JFXButton();
        right.getChildren().add((Object)btnBackup);
        FXUtils.installFastTooltip((Node)btnBackup, I18n.i18n("world.backup"));
        btnBackup.getStyleClass().add((Object)"toggle-icon4");
        btnBackup.setGraphic(SVG.ARCHIVE.createIcon((Paint)Theme.blackFill(), -1.0));
        btnBackup.setOnAction(event -> skinnable.showBackupPage());
        JFXButton btnDatapack = new JFXButton();
        right.getChildren().add((Object)btnDatapack);
        FXUtils.installFastTooltip((Node)btnDatapack, I18n.i18n("world.datapack"));
        btnDatapack.getStyleClass().add((Object)"toggle-icon4");
        btnDatapack.setGraphic(SVG.EXTENSION.createIcon((Paint)Theme.blackFill(), -1.0));
        btnDatapack.setOnAction(event -> skinnable.manageDatapacks());
        JFXButton btnInfo = new JFXButton();
        right.getChildren().add((Object)btnInfo);
        FXUtils.installFastTooltip((Node)btnInfo, I18n.i18n("world.info"));
        btnInfo.getStyleClass().add((Object)"toggle-icon4");
        btnInfo.setGraphic(SVG.INFO.createIcon((Paint)Theme.blackFill(), -1.0));
        btnInfo.setOnAction(event -> skinnable.showInfo());
        this.getChildren().setAll((Object[])new Node[]{new RipplerContainer((Node)root)});
    }
}

