/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.LinkedHashMap;

public final class KeyValuePairProperties
extends LinkedHashMap<String, String> {
    public static KeyValuePairProperties load(Path file) throws IOException {
        try (BufferedReader reader = Files.newBufferedReader(file);){
            KeyValuePairProperties keyValuePairProperties = KeyValuePairProperties.load(reader);
            return keyValuePairProperties;
        }
    }

    public static KeyValuePairProperties load(BufferedReader reader) throws IOException {
        String line;
        KeyValuePairProperties result = new KeyValuePairProperties();
        while ((line = reader.readLine()) != null) {
            String value;
            int idx;
            if (line.startsWith("#") || (idx = line.indexOf(61)) <= 0) continue;
            String name = line.substring(0, idx);
            if (line.length() > idx + 2 && line.charAt(idx + 1) == '\"' && line.charAt(line.length() - 1) == '\"') {
                if (line.indexOf(92, idx + 1) < 0) {
                    value = line.substring(idx + 2, line.length() - 1);
                } else {
                    StringBuilder builder = new StringBuilder();
                    int end = line.length() - 1;
                    for (int i = idx + 2; i < end; ++i) {
                        char ch = line.charAt(i);
                        if (ch == '\\' && i < end - 1) {
                            char nextChar = line.charAt(++i);
                            switch (nextChar) {
                                case 'n': {
                                    builder.append('\n');
                                    break;
                                }
                                case 'r': {
                                    builder.append('\r');
                                    break;
                                }
                                case 't': {
                                    builder.append('\t');
                                    break;
                                }
                                case 'f': {
                                    builder.append('\f');
                                    break;
                                }
                                case 'b': {
                                    builder.append('\b');
                                    break;
                                }
                                default: {
                                    builder.append(nextChar);
                                    break;
                                }
                            }
                            continue;
                        }
                        builder.append(ch);
                    }
                    value = builder.toString();
                }
            } else {
                value = line.substring(idx + 1);
            }
            result.put(name, value);
        }
        return result;
    }
}

