/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.jackhuang.hmcl.util.Pair;
import org.jackhuang.hmcl.util.function.ExceptionalBiConsumer;
import org.jackhuang.hmcl.util.function.ExceptionalConsumer;
import org.jackhuang.hmcl.util.function.ExceptionalFunction;
import org.jackhuang.hmcl.util.function.ExceptionalRunnable;
import org.jackhuang.hmcl.util.function.ExceptionalSupplier;

public final class Lang {
    private static Timer timer;
    public static final Function<Throwable, Void> handleUncaught;

    private Lang() {
    }

    public static <T> T requireNonNullElse(T value, T defaultValue) {
        return value != null ? value : defaultValue;
    }

    public static <T> T requireNonNullElseGet(T value, Supplier<? extends T> defaultValue) {
        return value != null ? value : defaultValue.get();
    }

    public static <T, U> U requireNonNullElseGet(T value, Function<? super T, ? extends U> mapper, Supplier<? extends U> defaultValue) {
        return value != null ? mapper.apply(value) : defaultValue.get();
    }

    @SafeVarargs
    public static <K, V> Map<K, V> mapOf(Pair<K, V> ... pairs) {
        return Lang.mapOf(Arrays.asList(pairs));
    }

    public static <K, V> Map<K, V> mapOf(Iterable<Pair<K, V>> pairs) {
        LinkedHashMap<K, V> map = new LinkedHashMap<K, V>();
        for (Pair<K, V> pair : pairs) {
            map.put(pair.getKey(), pair.getValue());
        }
        return map;
    }

    @SafeVarargs
    public static <T> List<T> immutableListOf(T ... elements) {
        return Collections.unmodifiableList(Arrays.asList(elements));
    }

    public static <T extends Comparable<T>> T clamp(T min, T val, T max) {
        if (val.compareTo(min) < 0) {
            return min;
        }
        if (val.compareTo(max) > 0) {
            return max;
        }
        return val;
    }

    public static double clamp(double min, double val, double max) {
        return Math.max(min, Math.min(val, max));
    }

    public static int clamp(int min, int val, int max) {
        return Math.max(min, Math.min(val, max));
    }

    public static boolean test(ExceptionalRunnable<?> r) {
        try {
            r.run();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static <E extends Exception> boolean test(ExceptionalSupplier<Boolean, E> r) {
        try {
            return r.get();
        }
        catch (Exception e) {
            return false;
        }
    }

    public static <T> T ignoringException(ExceptionalSupplier<T, ?> supplier) {
        return Lang.ignoringException(supplier, null);
    }

    public static <T> T ignoringException(ExceptionalSupplier<T, ?> supplier, T defaultValue) {
        try {
            return supplier.get();
        }
        catch (Exception ignore) {
            return defaultValue;
        }
    }

    public static <V> Optional<V> tryCast(Object obj, Class<V> clazz) {
        if (clazz.isInstance(obj)) {
            return Optional.of(clazz.cast(obj));
        }
        return Optional.empty();
    }

    public static <T> T getOrDefault(List<T> a, int index, T defaultValue) {
        return index < 0 || index >= a.size() ? defaultValue : a.get(index);
    }

    public static <T> T merge(T a, T b, BinaryOperator<T> operator) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        return (T)operator.apply(a, b);
    }

    public static <T> List<T> removingDuplicates(List<T> list) {
        LinkedHashSet<T> set = new LinkedHashSet<T>(list.size());
        set.addAll(list);
        return new ArrayList(set);
    }

    public static <T> List<T> merge(Collection<? extends T> a, Collection<? extends T> b) {
        ArrayList<Object> result = new ArrayList<Object>();
        if (a != null) {
            result.addAll(a);
        }
        if (b != null) {
            result.addAll(b);
        }
        return result;
    }

    public static <T> List<T> copyList(List<T> list) {
        return list == null ? null : (list.isEmpty() ? null : new ArrayList<T>(list));
    }

    public static void executeDelayed(Runnable runnable, TimeUnit timeUnit, long timeout, boolean isDaemon) {
        Lang.thread(() -> {
            try {
                timeUnit.sleep(timeout);
                runnable.run();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }, null, isDaemon);
    }

    public static Thread thread(Runnable runnable) {
        return Lang.thread(runnable, null);
    }

    public static Thread thread(Runnable runnable, String name) {
        return Lang.thread(runnable, name, false);
    }

    public static Thread thread(Runnable runnable, String name, boolean isDaemon) {
        Thread thread = new Thread(runnable);
        if (isDaemon) {
            thread.setDaemon(true);
        }
        if (name != null) {
            thread.setName(name);
        }
        thread.start();
        return thread;
    }

    public static ThreadPoolExecutor threadPool(String name, boolean daemon, int threads, long timeout, TimeUnit timeunit) {
        AtomicInteger counter = new AtomicInteger(1);
        ThreadPoolExecutor pool = new ThreadPoolExecutor(threads, threads, timeout, timeunit, new LinkedBlockingQueue<Runnable>(), r -> {
            Thread t = new Thread(r, name + "-" + counter.getAndIncrement());
            t.setDaemon(daemon);
            return t;
        });
        pool.allowCoreThreadTimeOut(true);
        return pool;
    }

    public static int parseInt(Object string, int defaultValue) {
        try {
            return Integer.parseInt(string.toString());
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public static Integer toIntOrNull(Object string) {
        try {
            if (string == null) {
                return null;
            }
            return Integer.parseInt(string.toString());
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static Double toDoubleOrNull(Object string) {
        try {
            if (string == null) {
                return null;
            }
            return Double.parseDouble(string.toString());
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @SafeVarargs
    public static <T> T nonNull(T ... t) {
        for (T a : t) {
            if (a == null) continue;
            return a;
        }
        return null;
    }

    public static <T> T apply(T t, Consumer<T> consumer) {
        consumer.accept(t);
        return t;
    }

    public static void rethrow(Throwable e) {
        if (e == null) {
            return;
        }
        if (!(e instanceof ExecutionException) && !(e instanceof CompletionException)) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new CompletionException(e);
        }
        Lang.rethrow(e.getCause());
    }

    public static Runnable wrap(ExceptionalRunnable<?> runnable) {
        return () -> {
            try {
                runnable.run();
            }
            catch (Exception e) {
                Lang.rethrow(e);
            }
        };
    }

    public static <T> Supplier<T> wrap(ExceptionalSupplier<T, ?> supplier) {
        return () -> {
            try {
                return supplier.get();
            }
            catch (Exception e) {
                Lang.rethrow(e);
                throw new InternalError("Unreachable code");
            }
        };
    }

    public static <T, R> Function<T, R> wrap(ExceptionalFunction<T, R, ?> fn) {
        return t -> {
            try {
                return fn.apply(t);
            }
            catch (Exception e) {
                Lang.rethrow(e);
                throw new InternalError("Unreachable code");
            }
        };
    }

    public static <T> Consumer<T> wrapConsumer(ExceptionalConsumer<T, ?> fn) {
        return t -> {
            try {
                fn.accept(t);
            }
            catch (Exception e) {
                Lang.rethrow(e);
            }
        };
    }

    public static <T, E> BiConsumer<T, E> wrap(ExceptionalBiConsumer<T, E, ?> fn) {
        return (t, e) -> {
            try {
                fn.accept(t, e);
            }
            catch (Exception ex) {
                Lang.rethrow(ex);
            }
        };
    }

    @SafeVarargs
    public static <T> Consumer<T> compose(Consumer<T> ... consumers) {
        return t -> {
            for (Consumer consumer : consumers) {
                consumer.accept(t);
            }
        };
    }

    public static <T> Stream<T> toStream(Optional<T> optional) {
        return optional.map(Stream::of).orElseGet(Stream::empty);
    }

    public static <T> Iterable<T> toIterable(final Enumeration<T> enumeration) {
        if (enumeration == null) {
            throw new NullPointerException();
        }
        return () -> new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return enumeration.hasMoreElements();
            }

            @Override
            public T next() {
                return enumeration.nextElement();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static <T> Iterable<T> toIterable(Stream<T> stream) {
        return stream::iterator;
    }

    public static <T> Iterable<T> toIterable(Iterator<T> iterator) {
        return () -> iterator;
    }

    public static <T, U> void forEachZipped(Iterable<T> i1, Iterable<U> i2, BiConsumer<T, U> action) {
        Iterator<T> it1 = i1.iterator();
        Iterator<U> it2 = i2.iterator();
        while (it1.hasNext() && it2.hasNext()) {
            action.accept(it1.next(), it2.next());
        }
    }

    public static synchronized Timer getTimer() {
        if (timer == null) {
            timer = new Timer(true);
        }
        return timer;
    }

    public static synchronized TimerTask setTimeout(final Runnable runnable, long delayMs) {
        TimerTask task = new TimerTask(){

            @Override
            public void run() {
                runnable.run();
            }
        };
        Lang.getTimer().schedule(task, delayMs);
        return task;
    }

    public static Throwable resolveException(Throwable e) {
        if (e instanceof ExecutionException || e instanceof CompletionException) {
            return Lang.resolveException(e.getCause());
        }
        return e;
    }

    public static <R> R handleUncaughtException(Throwable e) {
        Thread.currentThread().getUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        return null;
    }

    static {
        handleUncaught = e -> {
            Lang.handleUncaughtException(e);
            return null;
        };
    }
}

