/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.util.io;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.jackhuang.hmcl.util.InfiniteSizeList;

public final class CSVTable {
    private final List<List<String>> table = new InfiniteSizeList<List<String>>();

    private CSVTable() {
    }

    public static CSVTable createEmpty() {
        return new CSVTable();
    }

    public String get(int x, int y) {
        List<String> row = this.table.get(y);
        if (row == null) {
            return null;
        }
        return row.get(x);
    }

    public void set(int x, int y, String txt) {
        List<String> row = this.table.get(y);
        if (row == null) {
            row = new InfiniteSizeList<String>(x);
            this.table.set(y, row);
        }
        row.set(x, txt);
    }

    public void write(OutputStream outputStream) throws IOException {
        try (PrintWriter printWriter = new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter(outputStream, StandardCharsets.UTF_8)), false);){
            for (List<String> row : this.table) {
                if (row != null) {
                    for (int j = 0; j < row.size(); ++j) {
                        String txt = row.get(j);
                        if (txt != null) {
                            printWriter.write(this.escape(txt));
                        }
                        if (j == row.size() - 1) continue;
                        printWriter.write(44);
                    }
                }
                printWriter.write(10);
            }
        }
    }

    private String escape(String txt) {
        if (!txt.contains("\"") && !txt.contains(",")) {
            return txt;
        }
        return "\"" + txt.replace("\"", "\"\"") + "\"";
    }
}

