/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.util.io;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;

public final class IOUtils {
    public static final int DEFAULT_BUFFER_SIZE = 8192;

    private IOUtils() {
    }

    public static byte[] readFullyWithoutClosing(InputStream stream) throws IOException {
        ByteArrayOutputStream result = new ByteArrayOutputStream(Math.max(stream.available(), 32));
        IOUtils.copyTo(stream, result);
        return result.toByteArray();
    }

    public static String readFullyAsStringWithClosing(InputStream stream) throws IOException {
        ByteArrayOutputStream result = new ByteArrayOutputStream(Math.max(stream.available(), 32));
        IOUtils.copyTo(stream, result);
        return result.toString("UTF-8");
    }

    public static ByteArrayOutputStream readFully(InputStream stream) throws IOException {
        try (InputStream is = stream;){
            ByteArrayOutputStream result = new ByteArrayOutputStream(Math.max(is.available(), 32));
            IOUtils.copyTo(is, result);
            ByteArrayOutputStream byteArrayOutputStream = result;
            return byteArrayOutputStream;
        }
    }

    public static byte[] readFullyAsByteArray(InputStream stream) throws IOException {
        return IOUtils.readFully(stream).toByteArray();
    }

    public static String readFullyAsString(InputStream stream) throws IOException {
        return IOUtils.readFully(stream).toString("UTF-8");
    }

    public static void copyTo(InputStream src, OutputStream dest) throws IOException {
        IOUtils.copyTo(src, dest, new byte[8192]);
    }

    public static void copyTo(InputStream src, OutputStream dest, byte[] buf) throws IOException {
        int len;
        while ((len = src.read(buf)) != -1) {
            dest.write(buf, 0, len);
        }
    }

    public static InputStream wrapFromGZip(InputStream inputStream) throws IOException {
        return new GZIPInputStream(inputStream);
    }

    public static void closeQuietly(AutoCloseable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void closeQuietly(AutoCloseable closeable, Throwable exception) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (Throwable e) {
            exception.addSuppressed(e);
        }
    }
}

