/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.util.javafx;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.property.Property;
import javafx.beans.value.WritableValue;
import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;
import javafx.collections.ObservableSet;

public final class PropertyUtils {
    private PropertyUtils() {
    }

    public static Map<String, Function<Object, PropertyHandle>> getPropertyHandleFactories(Class<?> type) {
        LinkedHashMap<String, Method> collectionGetMethods = new LinkedHashMap<String, Method>();
        LinkedHashMap<String, Method> propertyMethods = new LinkedHashMap<String, Method>();
        for (Method method2 : type.getMethods()) {
            String propertyName2;
            Class<?> returnType = method2.getReturnType();
            if (method2.getParameterCount() != 0 || returnType.equals(Void.TYPE)) continue;
            String name = method2.getName();
            if (name.endsWith("Property")) {
                propertyName2 = name.substring(0, name.length() - "Property".length());
                if (propertyName2.isEmpty() || !Property.class.isAssignableFrom(returnType)) continue;
                propertyMethods.put(propertyName2, method2);
                continue;
            }
            if (!name.startsWith("get") || (propertyName2 = name.substring("get".length())).isEmpty() || !ObservableList.class.isAssignableFrom(returnType) && !ObservableSet.class.isAssignableFrom(returnType) && !ObservableMap.class.isAssignableFrom(returnType)) continue;
            propertyName2 = Character.toLowerCase(propertyName2.charAt(0)) + propertyName2.substring(1);
            collectionGetMethods.put(propertyName2, method2);
        }
        propertyMethods.keySet().forEach(collectionGetMethods::remove);
        LinkedHashMap<String, Function<Object, PropertyHandle>> result = new LinkedHashMap<String, Function<Object, PropertyHandle>>();
        propertyMethods.forEach((propertyName, method) -> result.put((String)propertyName, instance -> {
            Property returnValue;
            try {
                returnValue = (Property)method.invoke(instance, new Object[0]);
            }
            catch (ReflectiveOperationException e) {
                throw new IllegalStateException(e);
            }
            return new PropertyHandle((WritableValue<Object>)returnValue, (Observable)returnValue);
        }));
        collectionGetMethods.forEach((propertyName, method) -> result.put((String)propertyName, instance -> {
            Object accessor;
            Object returnValue;
            try {
                returnValue = method.invoke(instance, new Object[0]);
            }
            catch (ReflectiveOperationException e) {
                throw new IllegalStateException(e);
            }
            if (returnValue instanceof ObservableList) {
                accessor = new WritableValue<Object>(){

                    public Object getValue() {
                        return returnValue;
                    }

                    public void setValue(Object value) {
                        ((ObservableList)returnValue).setAll((Collection)((List)value));
                    }
                };
            } else if (returnValue instanceof ObservableSet) {
                accessor = new WritableValue<Object>(){

                    public Object getValue() {
                        return returnValue;
                    }

                    public void setValue(Object value) {
                        ObservableSet target = (ObservableSet)returnValue;
                        target.clear();
                        target.addAll((Collection)((Set)value));
                    }
                };
            } else if (returnValue instanceof ObservableMap) {
                accessor = new WritableValue<Object>(){

                    public Object getValue() {
                        return returnValue;
                    }

                    public void setValue(Object value) {
                        ObservableMap target = (ObservableMap)returnValue;
                        target.clear();
                        target.putAll((Map)value);
                    }
                };
            } else {
                throw new IllegalStateException();
            }
            return new PropertyHandle((WritableValue<Object>)accessor, (Observable)returnValue);
        }));
        return result;
    }

    public static void copyProperties(Object from, Object to) {
        Class<?> type = from.getClass();
        while (!type.isInstance(to)) {
            type = type.getSuperclass();
        }
        PropertyUtils.getPropertyHandleFactories(type).forEach((name, factory) -> {
            PropertyHandle src = (PropertyHandle)factory.apply(from);
            PropertyHandle target = (PropertyHandle)factory.apply(to);
            target.accessor.setValue(src.accessor.getValue());
        });
    }

    public static void copyProperties(Object from, Object to, Predicate<String> predicate) {
        Class<?> type = from.getClass();
        while (!type.isInstance(to)) {
            type = type.getSuperclass();
        }
        PropertyUtils.getPropertyHandleFactories(type).forEach((name, factory) -> {
            if (predicate.test((String)name)) {
                PropertyHandle src = (PropertyHandle)factory.apply(from);
                PropertyHandle target = (PropertyHandle)factory.apply(to);
                target.accessor.setValue(src.accessor.getValue());
            }
        });
    }

    public static void attachListener(Object instance, InvalidationListener listener) {
        PropertyUtils.getPropertyHandleFactories(instance.getClass()).forEach((name, factory) -> ((PropertyHandle)factory.apply(instance)).observable.addListener(listener));
    }

    public static final class PropertyHandle {
        public final WritableValue<Object> accessor;
        public final Observable observable;

        public PropertyHandle(WritableValue<Object> accessor, Observable observable) {
            this.accessor = accessor;
            this.observable = observable;
        }
    }
}

