/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.download.game;

import java.io.IOException;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.jackhuang.hmcl.download.AbstractDependencyManager;
import org.jackhuang.hmcl.download.LibraryAnalyzer;
import org.jackhuang.hmcl.download.game.LibraryDownloadTask;
import org.jackhuang.hmcl.game.DefaultGameRepository;
import org.jackhuang.hmcl.game.GameRepository;
import org.jackhuang.hmcl.game.Library;
import org.jackhuang.hmcl.game.Version;
import org.jackhuang.hmcl.task.FileDownloadTask;
import org.jackhuang.hmcl.task.Task;
import org.jackhuang.hmcl.util.DigestUtils;
import org.jackhuang.hmcl.util.io.CompressingUtils;
import org.jackhuang.hmcl.util.io.FileUtils;
import org.jackhuang.hmcl.util.logging.Logger;
import org.jackhuang.hmcl.util.versioning.GameVersionNumber;
import org.jackhuang.hmcl.util.versioning.VersionNumber;
import org.jetbrains.annotations.Nullable;

public final class GameLibrariesTask
extends Task<Void> {
    private final AbstractDependencyManager dependencyManager;
    private final Version version;
    private final boolean integrityCheck;
    private final List<Library> libraries;
    private final List<Task<?>> dependencies = new ArrayList();

    public GameLibrariesTask(AbstractDependencyManager dependencyManager, Version version, boolean integrityCheck) {
        this(dependencyManager, version, integrityCheck, version.resolve(dependencyManager.getGameRepository()).getLibraries());
    }

    public GameLibrariesTask(AbstractDependencyManager dependencyManager, Version version, boolean integrityCheck, List<Library> libraries) {
        this.dependencyManager = dependencyManager;
        this.version = version;
        this.integrityCheck = integrityCheck;
        this.libraries = libraries;
        this.setStage("hmcl.install.libraries");
        this.setSignificance(Task.TaskSignificance.MODERATE);
    }

    @Override
    public List<Task<?>> getDependencies() {
        return this.dependencies;
    }

    public static boolean shouldDownloadLibrary(GameRepository gameRepository, Version version, Library library, boolean integrityCheck) {
        block8: {
            Path file = gameRepository.getLibraryFile(version, library);
            if (!Files.isRegularFile(file, new LinkOption[0])) {
                return true;
            }
            if (!integrityCheck) {
                return false;
            }
            try {
                if (!library.getDownload().validateChecksum(file, true)) {
                    return true;
                }
                if (library.getChecksums() != null && !library.getChecksums().isEmpty() && !LibraryDownloadTask.checksumValid(file, library.getChecksums())) {
                    return true;
                }
                if (!FileUtils.getExtension(file).equals("jar")) break block8;
                try {
                    FileDownloadTask.ZIP_INTEGRITY_CHECK_HANDLER.checkIntegrity(file, file);
                }
                catch (IOException ignored) {
                    return true;
                }
            }
            catch (IOException e) {
                Logger.LOG.warning("Unable to calc hash value of file " + file, e);
            }
        }
        return false;
    }

    private static boolean shouldDownloadFMLLib(FMLLib fmlLib, Path file) {
        if (!Files.isRegularFile(file, new LinkOption[0])) {
            return true;
        }
        try {
            return !DigestUtils.digestToString("SHA-1", file).equalsIgnoreCase(fmlLib.sha1);
        }
        catch (IOException e) {
            Logger.LOG.warning("Unable to calc hash value of file " + file, e);
            return true;
        }
    }

    @Override
    public void execute() throws IOException {
        int progress = 0;
        GameRepository gameRepository = this.dependencyManager.getGameRepository();
        for (Library library : this.libraries) {
            String forgeVersion;
            if (!library.appliesToCurrentEnvironment()) continue;
            if ("net.minecraftforge".equals(library.getGroupId()) && "minecraftforge".equals(library.getArtifactId()) && gameRepository instanceof DefaultGameRepository) {
                DefaultGameRepository defaultGameRepository = (DefaultGameRepository)gameRepository;
                List<FMLLib> fmlLibs = GameLibrariesTask.getFMLLibs(library.getVersion());
                if (fmlLibs != null) {
                    Path libDir = defaultGameRepository.getBaseDirectory().resolve("lib").toAbsolutePath().normalize();
                    for (FMLLib fmlLib : fmlLibs) {
                        Path file;
                        if (!GameLibrariesTask.shouldDownloadFMLLib(fmlLib, file = libDir.resolve(fmlLib.name))) continue;
                        List<URI> uris = this.dependencyManager.getDownloadProvider().injectURLWithCandidates(fmlLib.getDownloadURI());
                        this.dependencies.add(new FileDownloadTask(uris, file).withCounter("hmcl.install.libraries"));
                    }
                }
            }
            Path file = gameRepository.getLibraryFile(this.version, library);
            if ("optifine".equals(library.getGroupId()) && Files.exists(file, new LinkOption[0]) && GameVersionNumber.asGameVersion(gameRepository.getGameVersion(this.version)).compareTo("1.20.4") == 0 && (forgeVersion = (String)LibraryAnalyzer.analyze(this.version, "1.20.4").getVersion(LibraryAnalyzer.LibraryType.FORGE).orElse(null)) != null && LibraryAnalyzer.FORGE_OPTIFINE_BROKEN_RANGE.contains(VersionNumber.asVersion(forgeVersion))) {
                try (FileSystem fs2 = CompressingUtils.createWritableZipFileSystem(file);){
                    Files.deleteIfExists(fs2.getPath("/META-INF/mods.toml", new String[0]));
                }
                catch (IOException e) {
                    throw new IOException("Cannot fix optifine", e);
                }
            }
            if (GameLibrariesTask.shouldDownloadLibrary(gameRepository, this.version, library, this.integrityCheck) && (library.hasDownloadURL() || !"optifine".equals(library.getGroupId()))) {
                this.dependencies.add(new LibraryDownloadTask(this.dependencyManager, file, library).withCounter("hmcl.install.libraries"));
            } else {
                this.dependencyManager.getCacheRepository().tryCacheLibrary(library, file);
            }
            this.updateProgress(++progress, this.libraries.size());
        }
        if (!this.dependencies.isEmpty()) {
            this.getProperties().put("total", this.dependencies.size());
            this.notifyPropertiesChanged();
        }
    }

    @Nullable
    private static List<FMLLib> getFMLLibs(String forgeVersion) {
        if (forgeVersion == null) {
            return null;
        }
        if (forgeVersion.startsWith("7.8.1.")) {
            return List.of(new FMLLib("argo-small-3.2.jar", "58912ea2858d168c50781f956fa5b59f0f7c6b51"), new FMLLib("guava-14.0-rc3.jar", "931ae21fa8014c3ce686aaa621eae565fefb1a6a"), new FMLLib("asm-all-4.1.jar", "054986e962b88d8660ae4566475658469595ef58"), new FMLLib("bcprov-jdk15on-148.jar", "960dea7c9181ba0b17e8bab0c06a43f0a5f04e65"), new FMLLib("deobfuscation_data_1.5.2.zip", "446e55cd986582c70fcf12cb27bc00114c5adfd9"), new FMLLib("scala-library.jar", "458d046151ad179c85429ed7420ffb1eaf6ddf85"));
        }
        return null;
    }

    private record FMLLib(String name, String sha1) {
        public String getDownloadURI() {
            return "https://hmcl-dev.github.io/metadata/fmllibs/" + this.name;
        }
    }
}

