/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.event;

import java.util.Objects;
import org.jackhuang.hmcl.util.ToStringBuilder;

public class Event {
    protected final transient Object source;
    private boolean canceled;
    private Result result = Result.DEFAULT;

    public Event(Object source) {
        Objects.requireNonNull(source);
        this.source = source;
    }

    public Object getSource() {
        return this.source;
    }

    public String toString() {
        return new ToStringBuilder(this).append("source", this.source).toString();
    }

    public final boolean isCanceled() {
        return this.canceled;
    }

    public final void setCanceled(boolean canceled) {
        if (!this.isCancelable()) {
            throw new UnsupportedOperationException("Attempted to cancel a non-cancelable event: " + this.getClass());
        }
        this.canceled = canceled;
    }

    public boolean isCancelable() {
        return false;
    }

    public boolean hasResult() {
        return false;
    }

    public Result getResult() {
        return this.result;
    }

    public void setResult(Result result) {
        if (!this.hasResult()) {
            throw new UnsupportedOperationException("Attempted to set result on a no result event: " + this.getClass() + " of type.");
        }
        this.result = result;
    }

    public static enum Result {
        DENY,
        DEFAULT,
        ALLOW;

    }
}

