/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.game;

import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Stream;
import org.jackhuang.hmcl.Metadata;
import org.jackhuang.hmcl.auth.AuthInfo;
import org.jackhuang.hmcl.game.GameRepository;
import org.jackhuang.hmcl.game.LaunchOptions;
import org.jackhuang.hmcl.game.Version;
import org.jackhuang.hmcl.launch.DefaultLauncher;
import org.jackhuang.hmcl.launch.ProcessListener;
import org.jackhuang.hmcl.setting.ConfigHolder;
import org.jackhuang.hmcl.util.i18n.LocaleUtils;
import org.jackhuang.hmcl.util.io.FileUtils;
import org.jackhuang.hmcl.util.logging.Logger;
import org.jackhuang.hmcl.util.platform.ManagedProcess;
import org.jackhuang.hmcl.util.versioning.GameVersionNumber;

public final class HMCLGameLauncher
extends DefaultLauncher {
    public HMCLGameLauncher(GameRepository repository, Version version, AuthInfo authInfo, LaunchOptions options) {
        this(repository, version, authInfo, options, null);
    }

    public HMCLGameLauncher(GameRepository repository, Version version, AuthInfo authInfo, LaunchOptions options, ProcessListener listener) {
        this(repository, version, authInfo, options, listener, true);
    }

    public HMCLGameLauncher(GameRepository repository, Version version, AuthInfo authInfo, LaunchOptions options, ProcessListener listener, boolean daemon) {
        super(repository, version, authInfo, options, listener, daemon);
    }

    @Override
    protected Map<String, String> getConfigurations() {
        Map<String, String> res = super.getConfigurations();
        res.put("${launcher_name}", "HMCL");
        res.put("${launcher_version}", Metadata.VERSION);
        return res;
    }

    private void generateOptionsTxt() {
        Locale locale;
        if (ConfigHolder.config().isDisableAutoGameOptions()) {
            return;
        }
        Path runDir = this.repository.getRunDirectory(this.version.getId());
        Path optionsFile = runDir.resolve("options.txt");
        Path configFolder = runDir.resolve("config");
        if (Files.exists(optionsFile, new LinkOption[0])) {
            return;
        }
        if (Files.isDirectory(configFolder, new LinkOption[0])) {
            try (Stream<Path> stream = Files.walk(configFolder, 2, FileVisitOption.FOLLOW_LINKS);){
                if (stream.anyMatch(file -> "options.txt".equals(FileUtils.getName(file)))) {
                    return;
                }
            }
            catch (IOException e) {
                Logger.LOG.warning("Failed to visit config folder", e);
            }
        }
        if (LocaleUtils.isEnglish(locale = Locale.getDefault())) {
            return;
        }
        GameVersionNumber gameVersion = GameVersionNumber.asGameVersion(this.repository.getGameVersion(this.version));
        if (gameVersion.compareTo("1.1") < 0) {
            return;
        }
        String lang = HMCLGameLauncher.normalizedLanguageTag(locale, gameVersion);
        if (lang.isEmpty()) {
            return;
        }
        if (gameVersion.compareTo("1.11") >= 0) {
            lang = lang.toLowerCase(Locale.ROOT);
        }
        try {
            Files.createDirectories(optionsFile.getParent(), new FileAttribute[0]);
            Files.writeString(optionsFile, (CharSequence)String.format("lang:%s\n", lang), new OpenOption[0]);
        }
        catch (IOException e) {
            Logger.LOG.warning("Unable to generate options.txt", e);
        }
    }

    private static String normalizedLanguageTag(Locale locale, GameVersionNumber gameVersion) {
        String region = locale.getCountry();
        return switch (LocaleUtils.getISO1Language(locale)) {
            case "es" -> "es_ES";
            case "ja" -> "ja_JP";
            case "ru" -> "ru_RU";
            case "uk" -> "uk_UA";
            case "zh" -> {
                if ("lzh".equals(locale.getLanguage()) && gameVersion.compareTo("1.16") >= 0) {
                    yield "lzh";
                }
                String script = LocaleUtils.getScript(locale);
                if ("Hant".equals(script)) {
                    if (region.equals("HK") || region.equals("MO") && gameVersion.compareTo("1.16") >= 0) {
                        yield "zh_HK";
                    }
                    yield "zh_TW";
                }
                yield "zh_CN";
            }
            default -> "";
        };
    }

    @Override
    public ManagedProcess launch() throws IOException, InterruptedException {
        this.generateOptionsTxt();
        return super.launch();
    }

    @Override
    public void makeLaunchScript(Path scriptFile) throws IOException {
        this.generateOptionsTxt();
        super.makeLaunchScript(scriptFile);
    }
}

