/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.game;

import com.google.gson.JsonParseException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jackhuang.hmcl.download.DefaultDependencyManager;
import org.jackhuang.hmcl.download.LibraryAnalyzer;
import org.jackhuang.hmcl.game.HMCLGameRepository;
import org.jackhuang.hmcl.game.HMCLModpackProvider;
import org.jackhuang.hmcl.game.Version;
import org.jackhuang.hmcl.mod.MinecraftInstanceTask;
import org.jackhuang.hmcl.mod.Modpack;
import org.jackhuang.hmcl.mod.ModpackConfiguration;
import org.jackhuang.hmcl.mod.ModpackInstallTask;
import org.jackhuang.hmcl.setting.Profile;
import org.jackhuang.hmcl.task.Task;
import org.jackhuang.hmcl.util.gson.JsonUtils;
import org.jackhuang.hmcl.util.io.CompressingUtils;

public final class HMCLModpackInstallTask
extends Task<Void> {
    private final Path zipFile;
    private final String name;
    private final HMCLGameRepository repository;
    private final DefaultDependencyManager dependency;
    private final Modpack modpack;
    private final List<Task<?>> dependencies = new ArrayList(1);
    private final List<Task<?>> dependents = new ArrayList(4);

    public HMCLModpackInstallTask(Profile profile, Path zipFile, Modpack modpack, String name) {
        this.dependency = profile.getDependency();
        this.repository = profile.getRepository();
        this.zipFile = zipFile;
        this.name = name;
        this.modpack = modpack;
        Path run = this.repository.getRunDirectory(name);
        Path json = this.repository.getModpackConfiguration(name);
        if (this.repository.hasVersion(name) && Files.notExists(json, new LinkOption[0])) {
            throw new IllegalArgumentException("Version " + name + " already exists");
        }
        this.dependents.add(this.dependency.gameBuilder().name(name).gameVersion(modpack.getGameVersion()).buildAsync());
        this.onDone().register(event -> {
            if (event.isFailed()) {
                this.repository.removeVersionFromDisk(name);
            }
        });
        ModpackConfiguration<Modpack> config = null;
        try {
            if (Files.exists(json, new LinkOption[0])) {
                config = JsonUtils.fromJsonFile(json, ModpackConfiguration.typeOf(Modpack.class));
                if (!HMCLModpackProvider.INSTANCE.getName().equals(config.getType())) {
                    throw new IllegalArgumentException("Version " + name + " is not a HMCL modpack. Cannot update this version.");
                }
            }
        }
        catch (JsonParseException | IOException exception) {
            // empty catch block
        }
        this.dependents.add(new ModpackInstallTask<Modpack>(zipFile, run, modpack.getEncoding(), Collections.singletonList("/minecraft"), it -> !"pack.json".equals(it), config));
        this.dependents.add(new MinecraftInstanceTask<Modpack>(zipFile, modpack.getEncoding(), Collections.singletonList("/minecraft"), modpack, HMCLModpackProvider.INSTANCE, modpack.getName(), modpack.getVersion(), this.repository.getModpackConfiguration(name)).withStage("hmcl.modpack"));
    }

    @Override
    public List<Task<?>> getDependencies() {
        return this.dependencies;
    }

    @Override
    public List<Task<?>> getDependents() {
        return this.dependents;
    }

    @Override
    public void execute() throws Exception {
        String json = CompressingUtils.readTextZipEntry(this.zipFile, "minecraft/pack.json");
        Version originalVersion = JsonUtils.GSON.fromJson(json, Version.class).setId(this.name).setJar(null);
        LibraryAnalyzer analyzer = LibraryAnalyzer.analyze(originalVersion, null);
        Task<Version> libraryTask = Task.supplyAsync(() -> originalVersion);
        for (LibraryAnalyzer.LibraryMark mark : analyzer) {
            if (LibraryAnalyzer.LibraryType.MINECRAFT.getPatchId().equals(mark.getLibraryId())) continue;
            libraryTask = libraryTask.thenComposeAsync((T version) -> this.dependency.installLibraryAsync(this.modpack.getGameVersion(), (Version)version, mark.getLibraryId(), mark.getLibraryVersion()));
        }
        this.dependencies.add(libraryTask.thenComposeAsync(this.repository::saveAsync));
    }
}

