/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.game;

import com.google.gson.JsonParseException;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Path;
import kala.compress.archivers.zip.ZipArchiveReader;
import org.jackhuang.hmcl.download.DefaultDependencyManager;
import org.jackhuang.hmcl.game.DefaultGameRepository;
import org.jackhuang.hmcl.game.HMCLGameRepository;
import org.jackhuang.hmcl.game.HMCLModpackInstallTask;
import org.jackhuang.hmcl.game.HMCLModpackManifest;
import org.jackhuang.hmcl.game.Version;
import org.jackhuang.hmcl.mod.MismatchedModpackTypeException;
import org.jackhuang.hmcl.mod.Modpack;
import org.jackhuang.hmcl.mod.ModpackProvider;
import org.jackhuang.hmcl.mod.ModpackUpdateTask;
import org.jackhuang.hmcl.setting.Profile;
import org.jackhuang.hmcl.task.Task;
import org.jackhuang.hmcl.util.StringUtils;
import org.jackhuang.hmcl.util.gson.JsonUtils;
import org.jackhuang.hmcl.util.io.CompressingUtils;

public final class HMCLModpackProvider
implements ModpackProvider {
    public static final HMCLModpackProvider INSTANCE = new HMCLModpackProvider();

    @Override
    public String getName() {
        return "HMCL";
    }

    @Override
    public Task<?> createCompletionTask(DefaultDependencyManager dependencyManager, String version) {
        return null;
    }

    @Override
    public Task<?> createUpdateTask(DefaultDependencyManager dependencyManager, String name, Path zipFile, Modpack modpack) throws MismatchedModpackTypeException {
        if (!(modpack.getManifest() instanceof HMCLModpackManifest)) {
            throw new MismatchedModpackTypeException(this.getName(), modpack.getManifest().getProvider().getName());
        }
        DefaultGameRepository defaultGameRepository = dependencyManager.getGameRepository();
        if (!(defaultGameRepository instanceof HMCLGameRepository)) {
            throw new IllegalArgumentException("HMCLModpackProvider requires HMCLGameRepository");
        }
        HMCLGameRepository repository = (HMCLGameRepository)defaultGameRepository;
        Profile profile = repository.getProfile();
        return new ModpackUpdateTask(dependencyManager.getGameRepository(), name, new HMCLModpackInstallTask(profile, zipFile, modpack, name));
    }

    @Override
    public Modpack readManifest(ZipArchiveReader file, Path path, Charset encoding) throws IOException, JsonParseException {
        String manifestJson = CompressingUtils.readTextZipEntry(file, "modpack.json");
        Modpack manifest = JsonUtils.fromNonNullJson(manifestJson, HMCLModpack.class).setEncoding(encoding);
        String gameJson = CompressingUtils.readTextZipEntry(file, "minecraft/pack.json");
        Version game = JsonUtils.fromNonNullJson(gameJson, Version.class);
        if (game.getJar() == null) {
            if (StringUtils.isBlank(manifest.getVersion())) {
                throw new JsonParseException("Cannot recognize the game version of modpack " + file + ".");
            }
            manifest.setManifest(HMCLModpackManifest.INSTANCE);
        } else {
            manifest.setManifest(HMCLModpackManifest.INSTANCE).setGameVersion(game.getJar());
        }
        return manifest;
    }

    private static class HMCLModpack
    extends Modpack {
        private HMCLModpack() {
        }

        @Override
        public Task<?> getInstallTask(DefaultDependencyManager dependencyManager, Path zipFile, String name) {
            return new HMCLModpackInstallTask(((HMCLGameRepository)dependencyManager.getGameRepository()).getProfile(), zipFile, this, name);
        }
    }
}

