/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.game;

import com.jfoenix.controls.JFXButton;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.nio.file.AccessDeniedException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.scene.Node;
import javafx.scene.layout.Region;
import javafx.stage.Stage;
import org.jackhuang.hmcl.Launcher;
import org.jackhuang.hmcl.auth.Account;
import org.jackhuang.hmcl.auth.AuthInfo;
import org.jackhuang.hmcl.auth.AuthenticationException;
import org.jackhuang.hmcl.auth.CharacterDeletedException;
import org.jackhuang.hmcl.auth.CredentialExpiredException;
import org.jackhuang.hmcl.auth.authlibinjector.AuthlibInjectorDownloadException;
import org.jackhuang.hmcl.download.DefaultDependencyManager;
import org.jackhuang.hmcl.download.DownloadProvider;
import org.jackhuang.hmcl.download.LibraryAnalyzer;
import org.jackhuang.hmcl.download.MaintainTask;
import org.jackhuang.hmcl.download.game.GameAssetIndexDownloadTask;
import org.jackhuang.hmcl.download.game.GameLibrariesTask;
import org.jackhuang.hmcl.download.game.GameVerificationFixTask;
import org.jackhuang.hmcl.download.game.LibraryDownloadException;
import org.jackhuang.hmcl.download.game.LibraryDownloadTask;
import org.jackhuang.hmcl.game.GameJavaVersion;
import org.jackhuang.hmcl.game.HMCLGameLauncher;
import org.jackhuang.hmcl.game.HMCLGameRepository;
import org.jackhuang.hmcl.game.JavaVersionConstraint;
import org.jackhuang.hmcl.game.LaunchOptions;
import org.jackhuang.hmcl.game.Library;
import org.jackhuang.hmcl.game.Log;
import org.jackhuang.hmcl.game.ModpackHelper;
import org.jackhuang.hmcl.game.NativesDirectoryType;
import org.jackhuang.hmcl.game.Renderer;
import org.jackhuang.hmcl.game.Version;
import org.jackhuang.hmcl.java.JavaManager;
import org.jackhuang.hmcl.java.JavaRuntime;
import org.jackhuang.hmcl.launch.CommandTooLongException;
import org.jackhuang.hmcl.launch.ExecutionPolicyLimitException;
import org.jackhuang.hmcl.launch.NotDecompressingNativesException;
import org.jackhuang.hmcl.launch.PermissionException;
import org.jackhuang.hmcl.launch.ProcessCreationException;
import org.jackhuang.hmcl.launch.ProcessListener;
import org.jackhuang.hmcl.mod.ModpackCompletionException;
import org.jackhuang.hmcl.mod.ModpackConfiguration;
import org.jackhuang.hmcl.mod.ModpackProvider;
import org.jackhuang.hmcl.setting.DownloadProviders;
import org.jackhuang.hmcl.setting.JavaVersionType;
import org.jackhuang.hmcl.setting.LauncherVisibility;
import org.jackhuang.hmcl.setting.Profile;
import org.jackhuang.hmcl.setting.VersionSetting;
import org.jackhuang.hmcl.task.DownloadException;
import org.jackhuang.hmcl.task.Schedulers;
import org.jackhuang.hmcl.task.Task;
import org.jackhuang.hmcl.task.TaskExecutor;
import org.jackhuang.hmcl.task.TaskListener;
import org.jackhuang.hmcl.ui.Controllers;
import org.jackhuang.hmcl.ui.DialogController;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.GameCrashWindow;
import org.jackhuang.hmcl.ui.LogWindow;
import org.jackhuang.hmcl.ui.construct.DialogCloseEvent;
import org.jackhuang.hmcl.ui.construct.MessageDialogPane;
import org.jackhuang.hmcl.ui.construct.PromptDialogPane;
import org.jackhuang.hmcl.ui.construct.TaskExecutorDialogPane;
import org.jackhuang.hmcl.util.CircularArrayList;
import org.jackhuang.hmcl.util.DataSizeUnit;
import org.jackhuang.hmcl.util.Lang;
import org.jackhuang.hmcl.util.Log4jLevel;
import org.jackhuang.hmcl.util.NativePatcher;
import org.jackhuang.hmcl.util.StringUtils;
import org.jackhuang.hmcl.util.TaskCancellationAction;
import org.jackhuang.hmcl.util.i18n.I18n;
import org.jackhuang.hmcl.util.io.FileUtils;
import org.jackhuang.hmcl.util.io.ResponseCodeException;
import org.jackhuang.hmcl.util.logging.Logger;
import org.jackhuang.hmcl.util.platform.Architecture;
import org.jackhuang.hmcl.util.platform.Bits;
import org.jackhuang.hmcl.util.platform.CommandBuilder;
import org.jackhuang.hmcl.util.platform.ManagedProcess;
import org.jackhuang.hmcl.util.platform.OperatingSystem;
import org.jackhuang.hmcl.util.platform.SystemInfo;
import org.jackhuang.hmcl.util.versioning.GameVersionNumber;
import org.jackhuang.hmcl.util.versioning.VersionNumber;

public final class LauncherHelper {
    private final Profile profile;
    private Account account;
    private final String selectedVersion;
    private Path scriptFile;
    private final VersionSetting setting;
    private LauncherVisibility launcherVisibility;
    private boolean showLogs;
    private final TaskExecutorDialogPane launchingStepsPane = new TaskExecutorDialogPane(TaskCancellationAction.NORMAL);
    public static final Queue<WeakReference<ManagedProcess>> PROCESSES = new ConcurrentLinkedQueue<WeakReference<ManagedProcess>>();

    public LauncherHelper(Profile profile, Account account, String selectedVersion) {
        this.profile = Objects.requireNonNull(profile);
        this.account = Objects.requireNonNull(account);
        this.selectedVersion = Objects.requireNonNull(selectedVersion);
        this.setting = profile.getVersionSetting(selectedVersion);
        this.launcherVisibility = this.setting.getLauncherVisibility();
        this.showLogs = this.setting.isShowLogs();
        this.launchingStepsPane.setTitle(I18n.i18n("version.launch"));
    }

    public Account getAccount() {
        return this.account;
    }

    public void setAccount(Account account) {
        this.account = account;
    }

    public void setTestMode() {
        this.launcherVisibility = LauncherVisibility.KEEP;
        this.showLogs = true;
    }

    public void setKeep() {
        this.launcherVisibility = LauncherVisibility.KEEP;
    }

    public void launch() {
        FXUtils.checkFxUserThread();
        Logger.LOG.info("Launching game version: " + this.selectedVersion);
        Controllers.dialog((Region)this.launchingStepsPane);
        this.launch0();
    }

    public void makeLaunchScript(Path scriptFile) {
        this.scriptFile = Objects.requireNonNull(scriptFile);
        this.launch();
    }

    private void launch0() {
        PROCESSES.removeIf(it -> it.get() == null);
        HMCLGameRepository repository = this.profile.getRepository();
        DefaultDependencyManager dependencyManager = this.profile.getDependency();
        AtomicReference<Version> version = new AtomicReference<Version>(MaintainTask.maintain(repository, repository.getResolvedVersion(this.selectedVersion)));
        Optional<String> gameVersion = repository.getGameVersion(version.get());
        boolean integrityCheck = repository.unmarkVersionLaunchedAbnormally(this.selectedVersion);
        CountDownLatch launchingLatch = new CountDownLatch(1);
        ArrayList javaAgents = new ArrayList(0);
        ArrayList javaArguments = new ArrayList(0);
        AtomicReference javaVersionRef = new AtomicReference();
        TaskExecutor executor = LauncherHelper.checkGameState(this.profile, this.setting, version.get()).thenComposeAsync(java -> {
            javaVersionRef.set(Objects.requireNonNull(java));
            version.set(NativePatcher.patchNative(repository, (Version)version.get(), gameVersion.orElse(null), java, this.setting, javaArguments));
            if (this.setting.isNotCheckGame()) {
                return null;
            }
            return Task.allOf(dependencyManager.checkGameCompletionAsync((Version)version.get(), integrityCheck), Task.composeAsync(() -> {
                try {
                    ModpackConfiguration<?> configuration = ModpackHelper.readModpackConfiguration(repository.getModpackConfiguration(this.selectedVersion));
                    ModpackProvider provider = ModpackHelper.getProviderByType(configuration.getType());
                    if (provider == null) {
                        return null;
                    }
                    return provider.createCompletionTask(dependencyManager, this.selectedVersion);
                }
                catch (IOException e) {
                    return null;
                }
            }), Task.composeAsync(() -> {
                Renderer renderer = this.setting.getRenderer();
                if (renderer != Renderer.DEFAULT && OperatingSystem.CURRENT_OS == OperatingSystem.WINDOWS) {
                    Library lib = NativePatcher.getWindowsMesaLoader(java, renderer, OperatingSystem.SYSTEM_VERSION);
                    if (lib == null) {
                        return null;
                    }
                    Path file = dependencyManager.getGameRepository().getLibraryFile((Version)version.get(), lib);
                    if (file.toAbsolutePath().toString().indexOf(61) >= 0) {
                        Logger.LOG.warning("Invalid character '=' in the libraries directory path, unable to attach software renderer loader");
                        return null;
                    }
                    String agent = FileUtils.getAbsolutePath(file) + "=" + renderer.name().toLowerCase(Locale.ROOT);
                    if (GameLibrariesTask.shouldDownloadLibrary(repository, (Version)version.get(), lib, integrityCheck)) {
                        return new LibraryDownloadTask(dependencyManager, file, lib).thenRunAsync(() -> javaAgents.add(agent));
                    }
                    javaAgents.add(agent);
                    return null;
                }
                return null;
            }));
        }).withStage("launch.state.dependencies").thenComposeAsync(() -> gameVersion.map(s -> new GameVerificationFixTask(dependencyManager, (String)s, (Version)version.get())).orElse(null)).thenComposeAsync(() -> LauncherHelper.logIn(this.account).withStage("launch.state.logging_in")).thenComposeAsync(authInfo -> Task.supplyAsync(() -> {
            LaunchOptions launchOptions = repository.getLaunchOptions(this.selectedVersion, (JavaRuntime)javaVersionRef.get(), this.profile.getGameDir(), javaAgents, javaArguments, this.scriptFile != null);
            Logger.LOG.info("Here's the structure of game mod directory:\n" + FileUtils.printFileStructure(repository.getModManager(this.selectedVersion).getModsDirectory(), 10));
            return new HMCLGameLauncher(repository, (Version)version.get(), (AuthInfo)authInfo, launchOptions, this.launcherVisibility == LauncherVisibility.CLOSE ? null : new HMCLProcessListener(repository, (Version)version.get(), (AuthInfo)authInfo, launchOptions, launchingLatch, gameVersion.isPresent()));
        }).thenComposeAsync(launcher -> {
            if (this.scriptFile == null) {
                return Task.supplyAsync(launcher::launch);
            }
            return Task.supplyAsync(() -> {
                launcher.makeLaunchScript(this.scriptFile);
                return null;
            });
        }).thenAcceptAsync(process -> {
            if (this.scriptFile == null) {
                PROCESSES.add(new WeakReference<ManagedProcess>((ManagedProcess)process));
                if (this.launcherVisibility == LauncherVisibility.CLOSE) {
                    Launcher.stopApplication();
                } else {
                    this.launchingStepsPane.setCancel(new TaskCancellationAction(it -> {
                        process.stop();
                        it.fireEvent(new DialogCloseEvent());
                    }));
                }
            } else {
                Platform.runLater(() -> {
                    this.launchingStepsPane.fireEvent(new DialogCloseEvent());
                    Controllers.dialog(I18n.i18n("version.launch_script.success", FileUtils.getAbsolutePath(this.scriptFile)));
                });
            }
        }).withFakeProgress(I18n.i18n("message.doing"), () -> launchingLatch.getCount() == 0L, 6.95).withStage("launch.state.waiting_launching")).withStagesHint(Lang.immutableListOf("launch.state.java", "launch.state.dependencies", "launch.state.logging_in", "launch.state.waiting_launching")).executor();
        this.launchingStepsPane.setExecutor(executor, false);
        executor.addTaskListener(new TaskListener(){

            @Override
            public void onStop(boolean success, TaskExecutor executor) {
                Platform.runLater(() -> {
                    if (!Controllers.isStopped()) {
                        Exception ex;
                        LauncherHelper.this.launchingStepsPane.fireEvent(new DialogCloseEvent());
                        if (!success && (ex = executor.getException()) != null && !(ex instanceof CancellationException)) {
                            Object message;
                            if (ex instanceof ModpackCompletionException) {
                                message = ex.getCause() instanceof FileNotFoundException ? I18n.i18n("modpack.type.curse.not_found") : I18n.i18n("modpack.type.curse.error");
                            } else if (ex instanceof PermissionException) {
                                message = I18n.i18n("launch.failed.executable_permission");
                            } else if (ex instanceof ProcessCreationException) {
                                message = I18n.i18n("launch.failed.creating_process") + "\n" + ex.getLocalizedMessage();
                            } else if (ex instanceof NotDecompressingNativesException) {
                                message = I18n.i18n("launch.failed.decompressing_natives") + "\n" + ex.getLocalizedMessage();
                            } else if (ex instanceof LibraryDownloadException) {
                                message = I18n.i18n("launch.failed.download_library", ((LibraryDownloadException)ex).getLibrary().getName()) + "\n";
                                if (ex.getCause() instanceof ResponseCodeException) {
                                    ResponseCodeException rce = (ResponseCodeException)ex.getCause();
                                    int responseCode = rce.getResponseCode();
                                    String uri = rce.getUri();
                                    message = responseCode == 404 ? (String)message + I18n.i18n("download.code.404", uri) : (String)message + I18n.i18n("download.failed", uri, responseCode);
                                } else {
                                    message = (String)message + StringUtils.getStackTrace(ex.getCause());
                                }
                            } else if (ex instanceof DownloadException) {
                                ResponseCodeException responseCodeException;
                                URI uri = ((DownloadException)ex).getUri();
                                message = ex.getCause() instanceof SocketTimeoutException ? I18n.i18n("install.failed.downloading.timeout", uri) : (ex.getCause() instanceof ResponseCodeException ? (I18n.hasKey("download.code." + (responseCodeException = (ResponseCodeException)ex.getCause()).getResponseCode()) ? I18n.i18n("download.code." + responseCodeException.getResponseCode(), uri) : I18n.i18n("install.failed.downloading.detail", uri) + "\n" + StringUtils.getStackTrace(ex.getCause())) : I18n.i18n("install.failed.downloading.detail", uri) + "\n" + StringUtils.getStackTrace(ex.getCause()));
                            } else if (ex instanceof GameAssetIndexDownloadTask.GameAssetIndexMalformedException) {
                                message = I18n.i18n("assets.index.malformed");
                            } else if (ex instanceof AuthlibInjectorDownloadException) {
                                message = I18n.i18n("account.failed.injector_download_failure");
                            } else if (ex instanceof CharacterDeletedException) {
                                message = I18n.i18n("account.failed.character_deleted");
                            } else if (ex instanceof ResponseCodeException) {
                                ResponseCodeException rce = (ResponseCodeException)ex;
                                int responseCode = rce.getResponseCode();
                                String uri = rce.getUri();
                                message = responseCode == 404 ? I18n.i18n("download.code.404", uri) : I18n.i18n("download.failed", uri, responseCode);
                            } else if (ex instanceof CommandTooLongException) {
                                message = I18n.i18n("launch.failed.command_too_long");
                            } else {
                                if (ex instanceof ExecutionPolicyLimitException) {
                                    Controllers.prompt(new PromptDialogPane.Builder(I18n.i18n("launch.failed.execution_policy"), (result, resolve, reject) -> {
                                        if (CommandBuilder.setExecutionPolicy()) {
                                            Logger.LOG.info("Set the ExecutionPolicy for the scope 'CurrentUser' to 'RemoteSigned'");
                                            resolve.run();
                                        } else {
                                            Logger.LOG.warning("Failed to set ExecutionPolicy");
                                            reject.accept(I18n.i18n("launch.failed.execution_policy.failed_to_set"));
                                        }
                                    }).addQuestion(new PromptDialogPane.Builder.HintQuestion(I18n.i18n("launch.failed.execution_policy.hint"))));
                                    return;
                                }
                                message = ex instanceof AccessDeniedException ? I18n.i18n("exception.access_denied", ((AccessDeniedException)ex).getFile()) : StringUtils.getStackTrace(ex);
                            }
                            Controllers.dialog((String)message, LauncherHelper.this.scriptFile == null ? I18n.i18n("launch.failed") : I18n.i18n("version.launch_script.failed"), MessageDialogPane.MessageType.ERROR);
                        }
                    }
                    LauncherHelper.this.launchingStepsPane.setExecutor(null);
                });
            }
        });
        executor.start();
    }

    private static Task<JavaRuntime> checkGameState(Profile profile, VersionSetting setting, Version version) {
        LibraryAnalyzer analyzer = LibraryAnalyzer.analyze(version, profile.getRepository().getGameVersion(version).orElse(null));
        GameVersionNumber gameVersion = GameVersionNumber.asGameVersion(analyzer.getVersion(LibraryAnalyzer.LibraryType.MINECRAFT));
        Task<JavaRuntime> getJavaTask = Task.supplyAsync(() -> {
            try {
                return setting.getJava(gameVersion, version);
            }
            catch (InterruptedException e) {
                throw new CancellationException();
            }
        });
        Task<JavaRuntime> task = setting.isNotCheckJVM() ? getJavaTask.thenApplyAsync(java -> Lang.requireNonNullElse(java, JavaRuntime.getDefault())) : (setting.getJavaVersionType() == JavaVersionType.AUTO || setting.getJavaVersionType() == JavaVersionType.VERSION ? getJavaTask.thenComposeAsync(Schedulers.javafx(), java -> {
            if (java != null) {
                return Task.completed(java);
            }
            CompletableFuture future = new CompletableFuture();
            Task result = Task.fromCompletableFuture(future);
            Runnable breakAction = () -> future.completeExceptionally(new CancellationException("No accepted java"));
            List<GameJavaVersion> supportedVersions = GameJavaVersion.getSupportedVersions(org.jackhuang.hmcl.util.platform.Platform.SYSTEM_PLATFORM);
            GameJavaVersion targetJavaVersion = null;
            if (setting.getJavaVersionType() == JavaVersionType.VERSION) {
                try {
                    int targetJavaVersionMajor = Integer.parseInt(setting.getJavaVersion());
                    GameJavaVersion minimumJavaVersion = GameJavaVersion.getMinimumJavaVersion(gameVersion);
                    if (minimumJavaVersion != null && targetJavaVersionMajor < minimumJavaVersion.getMajorVersion()) {
                        Controllers.dialog(I18n.i18n("launch.failed.java_version_too_low"), I18n.i18n("message.error"), MessageDialogPane.MessageType.ERROR, breakAction);
                        return result;
                    }
                    targetJavaVersion = GameJavaVersion.get(targetJavaVersionMajor);
                }
                catch (NumberFormatException numberFormatException) {}
            } else {
                targetJavaVersion = version.getJavaVersion();
            }
            if (targetJavaVersion != null && supportedVersions.contains(targetJavaVersion)) {
                LauncherHelper.downloadJava(targetJavaVersion, profile).whenCompleteAsync((downloadedJava, exception) -> {
                    if (exception == null) {
                        future.complete(downloadedJava);
                    } else {
                        Logger.LOG.warning("Failed to download java", (Throwable)exception);
                        Controllers.confirm(I18n.i18n("launch.failed.no_accepted_java"), I18n.i18n("message.warning"), MessageDialogPane.MessageType.WARNING, () -> future.complete(JavaRuntime.getDefault()), breakAction);
                    }
                }, Schedulers.javafx());
            } else {
                Controllers.confirm(I18n.i18n("launch.failed.no_accepted_java"), I18n.i18n("message.warning"), MessageDialogPane.MessageType.WARNING, () -> future.complete(JavaRuntime.getDefault()), breakAction);
            }
            return result;
        }) : getJavaTask.thenComposeAsync(java -> {
            VersionNumber forgeVersion;
            EnumSet<JavaVersionConstraint> violatedMandatoryConstraints = EnumSet.noneOf(JavaVersionConstraint.class);
            EnumSet<JavaVersionConstraint> violatedSuggestedConstraints = EnumSet.noneOf(JavaVersionConstraint.class);
            if (java != null) {
                for (JavaVersionConstraint constraint : JavaVersionConstraint.ALL) {
                    if (!constraint.appliesToVersion(gameVersion, version, (JavaRuntime)java, analyzer) || constraint.checkJava(gameVersion, version, (JavaRuntime)java)) continue;
                    if (constraint.isMandatory()) {
                        violatedMandatoryConstraints.add(constraint);
                        continue;
                    }
                    violatedSuggestedConstraints.add(constraint);
                }
            }
            CompletableFuture<JavaRuntime> future = new CompletableFuture<JavaRuntime>();
            Task result = Task.fromCompletableFuture(future);
            Runnable breakAction = () -> future.completeExceptionally(new CancellationException("Launch operation was cancelled by user"));
            if (java == null || !violatedMandatoryConstraints.isEmpty()) {
                JavaRuntime suggestedJava = JavaManager.findSuitableJava(gameVersion, version);
                if (suggestedJava != null) {
                    FXUtils.runInFX(() -> Controllers.confirm(I18n.i18n("launch.advice.java.auto"), I18n.i18n("message.warning"), () -> {
                        setting.setJavaAutoSelected();
                        future.complete(suggestedJava);
                    }, breakAction));
                    return result;
                }
                if (java == null) {
                    FXUtils.runInFX(() -> Controllers.dialog(I18n.i18n("launch.invalid_java"), I18n.i18n("message.error"), MessageDialogPane.MessageType.ERROR, breakAction));
                    return result;
                }
                GameJavaVersion gameJavaVersion = violatedMandatoryConstraints.contains((Object)JavaVersionConstraint.CLEANROOM_JAVA_21) ? GameJavaVersion.JAVA_21 : (violatedMandatoryConstraints.contains((Object)JavaVersionConstraint.GAME_JSON) ? version.getJavaVersion() : (violatedMandatoryConstraints.contains((Object)JavaVersionConstraint.VANILLA) ? GameJavaVersion.getMinimumJavaVersion(gameVersion) : null));
                if (gameJavaVersion != null) {
                    FXUtils.runInFX(() -> LauncherHelper.downloadJava(gameJavaVersion, profile).whenCompleteAsync((downloadedJava, throwable) -> {
                        if (throwable == null) {
                            setting.setJavaAutoSelected();
                            future.complete((JavaRuntime)downloadedJava);
                        } else {
                            Logger.LOG.warning("Failed to download java", (Throwable)throwable);
                            breakAction.run();
                        }
                    }, Schedulers.javafx()));
                    return result;
                }
                if (violatedMandatoryConstraints.contains((Object)JavaVersionConstraint.VANILLA_LINUX_JAVA_8)) {
                    if (setting.getNativesDirType() == NativesDirectoryType.VERSION_FOLDER) {
                        FXUtils.runInFX(() -> Controllers.dialog(I18n.i18n("launch.advice.vanilla_linux_java_8"), I18n.i18n("message.error"), MessageDialogPane.MessageType.ERROR, breakAction));
                        return result;
                    }
                    violatedMandatoryConstraints.remove((Object)JavaVersionConstraint.VANILLA_LINUX_JAVA_8);
                }
                if (violatedMandatoryConstraints.contains((Object)JavaVersionConstraint.LAUNCH_WRAPPER)) {
                    FXUtils.runInFX(() -> Controllers.dialog(I18n.i18n("launch.advice.java9") + "\n" + I18n.i18n("launch.advice.uncorrected"), I18n.i18n("message.error"), MessageDialogPane.MessageType.ERROR, breakAction));
                    return result;
                }
                if (!violatedMandatoryConstraints.isEmpty()) {
                    FXUtils.runInFX(() -> Controllers.dialog(I18n.i18n("launch.advice.unknown") + "\n" + violatedMandatoryConstraints, I18n.i18n("message.error"), MessageDialogPane.MessageType.ERROR, breakAction));
                    return result;
                }
            }
            ArrayList<String> suggestions = new ArrayList<String>();
            if (Architecture.SYSTEM_ARCH == Architecture.X86_64 && java.getPlatform().getArchitecture() == Architecture.X86) {
                suggestions.add(I18n.i18n("launch.advice.different_platform"));
            }
            if (java.getBits() == Bits.BIT_32 && (double)setting.getMaxMemory() > 1536.0) {
                suggestions.add(I18n.i18n("launch.advice.too_large_memory_for_32bit"));
            }
            block12: for (JavaVersionConstraint violatedSuggestedConstraint : violatedSuggestedConstraints) {
                switch (violatedSuggestedConstraint) {
                    case MODDED_JAVA_7: {
                        suggestions.add(I18n.i18n("launch.advice.java.modded_java_7"));
                        continue block12;
                    }
                    case MODDED_JAVA_8: {
                        if (java.getParsedVersion() < 8) {
                            suggestions.add(I18n.i18n("launch.advice.newer_java"));
                            continue block12;
                        }
                        suggestions.add(I18n.i18n("launch.advice.modded_java", 8, gameVersion));
                        continue block12;
                    }
                    case MODDED_JAVA_16: {
                        String forgePatchVersion = analyzer.getVersion(LibraryAnalyzer.LibraryType.FORGE).orElse(null);
                        if (forgePatchVersion != null && VersionNumber.compare(forgePatchVersion, "37.0.60") < 0) {
                            suggestions.add(I18n.i18n("launch.advice.forge37_0_60"));
                            continue block12;
                        }
                        suggestions.add(I18n.i18n("launch.advice.modded_java", 16, gameVersion));
                        continue block12;
                    }
                    case MODDED_JAVA_17: {
                        suggestions.add(I18n.i18n("launch.advice.modded_java", 17, gameVersion));
                        continue block12;
                    }
                    case MODDED_JAVA_21: {
                        suggestions.add(I18n.i18n("launch.advice.modded_java", 21, gameVersion));
                        continue block12;
                    }
                    case CLEANROOM_JAVA_21: {
                        suggestions.add(I18n.i18n("launch.advice.cleanroom"));
                        continue block12;
                    }
                    case VANILLA_JAVA_8_51: {
                        suggestions.add(I18n.i18n("launch.advice.java8_51_1_13"));
                        continue block12;
                    }
                    case MODLAUNCHER_8: {
                        suggestions.add(I18n.i18n("launch.advice.modlauncher8"));
                        continue block12;
                    }
                    case VANILLA_X86: {
                        if (setting.getNativesDirType() != NativesDirectoryType.VERSION_FOLDER || !org.jackhuang.hmcl.util.platform.Platform.isCompatibleWithX86Java()) continue block12;
                        suggestions.add(I18n.i18n("launch.advice.vanilla_x86.translation"));
                        continue block12;
                    }
                }
                suggestions.add(violatedSuggestedConstraint.name());
            }
            long totalMemorySizeMB = (long)DataSizeUnit.MEGABYTES.convertFromBytes(SystemInfo.getTotalMemorySize());
            if (totalMemorySizeMB > 0L && totalMemorySizeMB < (long)setting.getMaxMemory()) {
                suggestions.add(I18n.i18n("launch.advice.not_enough_space", totalMemorySizeMB));
            }
            boolean hasForge2760 = (forgeVersion = (VersionNumber)analyzer.getVersion(LibraryAnalyzer.LibraryType.FORGE).map(VersionNumber::asVersion).orElse(null)) != null && forgeVersion.compareTo("1.12.2-14.23.5.2760") >= 0 && forgeVersion.compareTo("1.12.2-14.23.5.2773") < 0;
            boolean hasLiteLoader = version.getLibraries().stream().anyMatch(it -> it.is("com.mumfrey", "liteloader"));
            if (hasForge2760 && hasLiteLoader && gameVersion.compareTo("1.12.2") == 0) {
                suggestions.add(I18n.i18n("launch.advice.forge2760_liteloader"));
            }
            boolean hasForge28_2_2 = forgeVersion != null && forgeVersion.compareTo("1.14.4-28.2.2") >= 0;
            boolean hasOptiFine = version.getLibraries().stream().anyMatch(it -> it.is("optifine", "OptiFine"));
            if (hasForge28_2_2 && hasOptiFine && gameVersion.compareTo("1.14.4") == 0) {
                suggestions.add(I18n.i18n("launch.advice.forge28_2_2_optifine"));
            }
            if (suggestions.isEmpty()) {
                if (!future.isDone()) {
                    future.complete((JavaRuntime)java);
                }
            } else {
                String message = suggestions.size() == 1 ? I18n.i18n("launch.advice", suggestions.get(0)) : I18n.i18n("launch.advice.multi", suggestions.stream().map(it -> "\u2192 " + it).collect(Collectors.joining("\n")));
                FXUtils.runInFX(() -> Controllers.confirm(message, I18n.i18n("message.warning"), MessageDialogPane.MessageType.WARNING, () -> future.complete((JavaRuntime)java), breakAction));
            }
            return result;
        }));
        return task.withStage("launch.state.java");
    }

    private static CompletableFuture<JavaRuntime> downloadJava(GameJavaVersion javaVersion, Profile profile) {
        CompletableFuture<JavaRuntime> future = new CompletableFuture<JavaRuntime>();
        Controllers.dialog((Region)new MessageDialogPane.Builder(I18n.i18n("launch.advice.require_newer_java_version", javaVersion.getMajorVersion()), I18n.i18n("message.warning"), MessageDialogPane.MessageType.QUESTION).yesOrNo(() -> {
            DownloadProvider downloadProvider = profile.getDependency().getDownloadProvider();
            Controllers.taskDialog(JavaManager.getDownloadJavaTask(downloadProvider, org.jackhuang.hmcl.util.platform.Platform.SYSTEM_PLATFORM, javaVersion).whenComplete(Schedulers.javafx(), (result, exception) -> {
                if (exception == null) {
                    future.complete((JavaRuntime)result);
                } else {
                    Throwable resolvedException = Lang.resolveException(exception);
                    Logger.LOG.warning("Failed to download java", exception);
                    if (!(resolvedException instanceof CancellationException)) {
                        Controllers.dialog(DownloadProviders.localizeErrorMessage(resolvedException), I18n.i18n("install.failed"));
                    }
                    future.completeExceptionally(new CancellationException());
                }
            }), I18n.i18n("download.java"), new TaskCancellationAction(() -> future.completeExceptionally(new CancellationException())));
        }, () -> future.completeExceptionally(new CancellationException())).build());
        return future;
    }

    private static Task<AuthInfo> logIn(Account account) {
        return Task.composeAsync(() -> {
            try {
                return Task.completed(account.logIn());
            }
            catch (CredentialExpiredException e) {
                Logger.LOG.info("Credential has expired", e);
                return Task.completed(DialogController.logIn(account));
            }
            catch (AuthenticationException e) {
                Logger.LOG.warning("Authentication failed, try skipping refresh", e);
                CompletableFuture future = new CompletableFuture();
                FXUtils.runInFX(() -> {
                    JFXButton loginOfflineButton = new JFXButton(I18n.i18n("account.login.skip"));
                    loginOfflineButton.setOnAction(event -> {
                        try {
                            future.complete(Task.completed(account.playOffline()));
                        }
                        catch (AuthenticationException e2) {
                            future.completeExceptionally(e2);
                        }
                    });
                    JFXButton retryButton = new JFXButton(I18n.i18n("account.login.retry"));
                    retryButton.setOnAction(event -> future.complete(LauncherHelper.logIn(account)));
                    Controllers.dialog((Region)new MessageDialogPane.Builder(I18n.i18n("account.failed.server_disconnected"), I18n.i18n("account.failed"), MessageDialogPane.MessageType.ERROR).addAction((Node)loginOfflineButton).addAction((Node)retryButton).addCancel(() -> future.completeExceptionally(new CancellationException())).build());
                });
                return Task.fromCompletableFuture(future).thenComposeAsync(task -> task);
            }
        });
    }

    private void checkExit() {
        switch (this.launcherVisibility) {
            case HIDE_AND_REOPEN: {
                Platform.runLater(() -> Optional.ofNullable(Controllers.getStage()).ifPresent(Stage::show));
                break;
            }
            case KEEP: {
                break;
            }
            case CLOSE: {
                throw new Error("Never get to here");
            }
            case HIDE: {
                Platform.runLater(() -> {
                    Platform.setImplicitExit((boolean)true);
                    Launcher.stopWithoutPlatform();
                });
            }
        }
    }

    public static void stopManagedProcesses() {
        while (!PROCESSES.isEmpty()) {
            Optional.ofNullable(PROCESSES.poll()).map(Reference::get).ifPresent(ManagedProcess::stop);
        }
    }

    private final class HMCLProcessListener
    implements ProcessListener {
        private final HMCLGameRepository repository;
        private final Version version;
        private final LaunchOptions launchOptions;
        private ManagedProcess process;
        private volatile boolean lwjgl;
        private LogWindow logWindow;
        private final boolean detectWindow;
        private final CircularArrayList<Log> logs;
        private final CountDownLatch launchingLatch;
        private final String forbiddenAccessToken;
        private Thread submitLogThread;
        private LinkedBlockingQueue<Log> logBuffer;

        public HMCLProcessListener(HMCLGameRepository repository, Version version, AuthInfo authInfo, LaunchOptions launchOptions, CountDownLatch launchingLatch, boolean detectWindow) {
            this.repository = repository;
            this.version = version;
            this.launchOptions = launchOptions;
            this.launchingLatch = launchingLatch;
            this.detectWindow = detectWindow;
            this.forbiddenAccessToken = authInfo != null ? authInfo.getAccessToken() : null;
            this.logs = new CircularArrayList(Log.getLogLines() + 1);
        }

        @Override
        public void setProcess(ManagedProcess process) {
            this.process = process;
            String command = new CommandBuilder().addAll(process.getCommands()).toString();
            Logger.LOG.info("Launched process: " + command);
            String classpath = process.getClasspath();
            if (classpath != null) {
                Logger.LOG.info("Process ClassPath: " + classpath);
            }
            if (LauncherHelper.this.showLogs) {
                CountDownLatch logWindowLatch = new CountDownLatch(1);
                Platform.runLater(() -> {
                    this.logWindow = new LogWindow(process, this.logs);
                    this.logWindow.show();
                    logWindowLatch.countDown();
                });
                this.logBuffer = new LinkedBlockingQueue();
                this.submitLogThread = Lang.thread(new Runnable(){
                    private final ArrayList<Log> currentLogs = new ArrayList();
                    private final Semaphore semaphore = new Semaphore(0);

                    private void submitLogs() {
                        if (this.currentLogs.size() == 1) {
                            Log log = this.currentLogs.get(0);
                            Platform.runLater(() -> HMCLProcessListener.this.logWindow.logLine(log));
                        } else {
                            Platform.runLater(() -> {
                                HMCLProcessListener.this.logWindow.logLines(this.currentLogs);
                                this.semaphore.release();
                            });
                            this.semaphore.acquireUninterruptibly();
                        }
                        this.currentLogs.clear();
                    }

                    @Override
                    public void run() {
                        while (true) {
                            try {
                                this.currentLogs.add(HMCLProcessListener.this.logBuffer.take());
                                Thread.sleep(200L);
                            }
                            catch (InterruptedException e) {
                                break;
                            }
                            HMCLProcessListener.this.logBuffer.drainTo(this.currentLogs);
                            this.submitLogs();
                        }
                        do {
                            this.submitLogs();
                        } while (HMCLProcessListener.this.logBuffer.drainTo(this.currentLogs) > 0);
                    }
                }, "Game Log Submitter", true);
                try {
                    logWindowLatch.await();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }

        private void finishLaunch() {
            switch (LauncherHelper.this.launcherVisibility) {
                case HIDE_AND_REOPEN: {
                    Platform.runLater(() -> {
                        if (Controllers.getStage() != null) {
                            Controllers.getStage().hide();
                            this.launchingLatch.countDown();
                        }
                    });
                    break;
                }
                case CLOSE: {
                    break;
                }
                case KEEP: {
                    Platform.runLater(this.launchingLatch::countDown);
                    break;
                }
                case HIDE: {
                    this.launchingLatch.countDown();
                    Platform.runLater(() -> {
                        if (Controllers.getStage() != null) {
                            Controllers.getStage().close();
                            Controllers.shutdown();
                            Schedulers.shutdown();
                            System.gc();
                        }
                    });
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onLog(String log, boolean isErrorStream) {
            Log4jLevel level;
            if (isErrorStream) {
                System.err.println(log);
            } else {
                System.out.println(log);
            }
            log = StringUtils.parseEscapeSequence(log);
            if (this.forbiddenAccessToken != null) {
                log = log.replace(this.forbiddenAccessToken, "<access token>");
            }
            Log4jLevel log4jLevel = level = isErrorStream && !log.startsWith("[authlib-injector]") ? Log4jLevel.ERROR : null;
            if (LauncherHelper.this.showLogs) {
                if (level == null) {
                    level = Lang.requireNonNullElse(Log4jLevel.guessLevel(log), Log4jLevel.INFO);
                }
                this.logBuffer.add(new Log(log, level));
            } else {
                HMCLProcessListener hMCLProcessListener = this;
                synchronized (hMCLProcessListener) {
                    this.logs.addLast(new Log(log, level));
                    if (this.logs.size() > Log.getLogLines()) {
                        this.logs.removeFirst();
                    }
                }
            }
            if (!this.lwjgl) {
                String lowerCaseLog = log.toLowerCase(Locale.ROOT);
                if (!this.detectWindow || lowerCaseLog.contains("lwjgl version") || lowerCaseLog.contains("lwjgl openal")) {
                    HMCLProcessListener hMCLProcessListener = this;
                    synchronized (hMCLProcessListener) {
                        if (!this.lwjgl) {
                            this.lwjgl = true;
                            this.finishLaunch();
                        }
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onExit(int exitCode, ProcessListener.ExitType exitType) {
            if (LauncherHelper.this.showLogs) {
                this.logBuffer.add(new Log(String.format("[HMCL ProcessListener] Minecraft exit with code %d(0x%x), type is %s.", new Object[]{exitCode, exitCode, exitType}), Log4jLevel.INFO));
                this.submitLogThread.interrupt();
                try {
                    this.submitLogThread.join();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
            this.launchingLatch.countDown();
            if (exitType == ProcessListener.ExitType.INTERRUPTED) {
                return;
            }
            if (!this.lwjgl) {
                HMCLProcessListener hMCLProcessListener = this;
                synchronized (hMCLProcessListener) {
                    if (!this.lwjgl) {
                        this.finishLaunch();
                    }
                }
            }
            if (exitType != ProcessListener.ExitType.NORMAL) {
                this.repository.markVersionLaunchedAbnormally(this.version.getId());
                Platform.runLater(() -> new GameCrashWindow(this.process, exitType, this.repository, this.version, this.launchOptions, this.logs).show());
            }
            LauncherHelper.this.checkExit();
        }
    }
}

