/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.java;

import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jackhuang.hmcl.download.DownloadProvider;
import org.jackhuang.hmcl.download.java.mojang.MojangJavaDownloadTask;
import org.jackhuang.hmcl.download.java.mojang.MojangJavaRemoteFiles;
import org.jackhuang.hmcl.game.DownloadInfo;
import org.jackhuang.hmcl.game.GameJavaVersion;
import org.jackhuang.hmcl.java.JavaInfo;
import org.jackhuang.hmcl.java.JavaInfoUtils;
import org.jackhuang.hmcl.java.JavaInstallTask;
import org.jackhuang.hmcl.java.JavaLocalFiles;
import org.jackhuang.hmcl.java.JavaManager;
import org.jackhuang.hmcl.java.JavaManifest;
import org.jackhuang.hmcl.java.JavaRepository;
import org.jackhuang.hmcl.java.JavaRuntime;
import org.jackhuang.hmcl.task.Task;
import org.jackhuang.hmcl.util.gson.JsonUtils;
import org.jackhuang.hmcl.util.io.FileUtils;
import org.jackhuang.hmcl.util.logging.Logger;
import org.jackhuang.hmcl.util.platform.OperatingSystem;
import org.jackhuang.hmcl.util.platform.Platform;
import org.jetbrains.annotations.Nullable;

public final class HMCLJavaRepository
implements JavaRepository {
    public static final String MOJANG_JAVA_PREFIX = "mojang-";
    private final Path root;

    public HMCLJavaRepository(Path root) {
        this.root = root;
    }

    public Path getPlatformRoot(Platform platform) {
        return this.root.resolve(platform.toString());
    }

    @Override
    public Path getJavaDir(Platform platform, String name) {
        return this.getPlatformRoot(platform).resolve(name);
    }

    public Path getJavaDir(Platform platform, GameJavaVersion gameJavaVersion) {
        return this.getJavaDir(platform, MOJANG_JAVA_PREFIX + gameJavaVersion.getComponent());
    }

    @Override
    public Path getManifestFile(Platform platform, String name) {
        return this.getPlatformRoot(platform).resolve(name + ".json");
    }

    public Path getManifestFile(Platform platform, GameJavaVersion gameJavaVersion) {
        return this.getManifestFile(platform, MOJANG_JAVA_PREFIX + gameJavaVersion.getComponent());
    }

    public boolean isInstalled(Platform platform, String name) {
        return Files.exists(this.getManifestFile(platform, name), new LinkOption[0]);
    }

    public boolean isInstalled(Platform platform, GameJavaVersion gameJavaVersion) {
        return this.isInstalled(platform, MOJANG_JAVA_PREFIX + gameJavaVersion.getComponent());
    }

    @Nullable
    public Path getJavaExecutable(Platform platform, String name) {
        Path javaDir = this.getJavaDir(platform, name);
        try {
            return JavaManager.getExecutable(javaDir).toRealPath(new LinkOption[0]);
        }
        catch (IOException ignored) {
            if (platform.getOperatingSystem() == OperatingSystem.MACOS) {
                try {
                    return JavaManager.getMacExecutable(javaDir).toRealPath(new LinkOption[0]);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return null;
        }
    }

    @Nullable
    public Path getJavaExecutable(Platform platform, GameJavaVersion gameJavaVersion) {
        return this.getJavaExecutable(platform, MOJANG_JAVA_PREFIX + gameJavaVersion.getComponent());
    }

    private static void getAllJava(List<JavaRuntime> list, Platform platform, Path platformRoot, boolean isManaged) {
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(platformRoot);){
            for (Path file : stream) {
                try {
                    Path executable;
                    String name = file.getFileName().toString();
                    if (!name.endsWith(".json") || !Files.isRegularFile(file, new LinkOption[0])) continue;
                    Path javaDir = file.resolveSibling(name.substring(0, name.length() - ".json".length()));
                    try {
                        executable = JavaManager.getExecutable(javaDir).toRealPath(new LinkOption[0]);
                    }
                    catch (IOException e) {
                        if (platform.getOperatingSystem() == OperatingSystem.MACOS) {
                            executable = JavaManager.getMacExecutable(javaDir).toRealPath(new LinkOption[0]);
                        }
                        throw e;
                    }
                    if (!Files.isDirectory(javaDir, new LinkOption[0])) continue;
                    JavaManifest manifest = JsonUtils.fromJsonFile(file, JavaManifest.class);
                    list.add(JavaRuntime.of(executable, manifest.getInfo(), isManaged));
                }
                catch (Throwable e) {
                    Logger.LOG.warning("Failed to parse " + file, e);
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public Collection<JavaRuntime> getAllJava(Platform platform) {
        Path platformRoot = this.getPlatformRoot(platform);
        if (!Files.isDirectory(platformRoot, new LinkOption[0])) {
            return Collections.emptyList();
        }
        ArrayList<JavaRuntime> list = new ArrayList<JavaRuntime>();
        HMCLJavaRepository.getAllJava(list, platform, platformRoot, true);
        if (platform.getOperatingSystem() == OperatingSystem.MACOS && Files.isDirectory(platformRoot = this.root.resolve(platform.getOperatingSystem().getMojangName() + "-" + platform.getArchitecture().getCheckedName()), new LinkOption[0])) {
            HMCLJavaRepository.getAllJava(list, platform, platformRoot, false);
        }
        return list;
    }

    @Override
    public Task<JavaRuntime> getDownloadJavaTask(DownloadProvider downloadProvider, Platform platform, GameJavaVersion gameJavaVersion) {
        Path javaDir = this.getJavaDir(platform, gameJavaVersion);
        return new MojangJavaDownloadTask(downloadProvider, javaDir, gameJavaVersion, JavaManager.getMojangJavaPlatform(platform)).thenApplyAsync(result -> {
            Path executable;
            try {
                executable = JavaManager.getExecutable(javaDir).toRealPath(new LinkOption[0]);
            }
            catch (IOException e) {
                if (platform.getOperatingSystem() == OperatingSystem.MACOS) {
                    executable = JavaManager.getMacExecutable(javaDir).toRealPath(new LinkOption[0]);
                }
                throw e;
            }
            JavaInfo info = JavaManager.isCompatible(platform) ? JavaInfoUtils.fromExecutable(executable, false) : new JavaInfo(platform, result.download.getVersion().getName(), null);
            LinkedHashMap<String, Object> update = new LinkedHashMap<String, Object>();
            update.put("provider", "mojang");
            update.put("component", gameJavaVersion.getComponent());
            LinkedHashMap<String, JavaLocalFiles.Local> files = new LinkedHashMap<String, JavaLocalFiles.Local>();
            result.remoteFiles.getFiles().forEach((path, file) -> {
                if (file instanceof MojangJavaRemoteFiles.RemoteFile) {
                    DownloadInfo downloadInfo = ((MojangJavaRemoteFiles.RemoteFile)file).getDownloads().get("raw");
                    if (downloadInfo != null) {
                        files.put((String)path, new JavaLocalFiles.LocalFile(downloadInfo.getSha1(), downloadInfo.getSize()));
                    }
                } else if (file instanceof MojangJavaRemoteFiles.RemoteDirectory) {
                    files.put((String)path, new JavaLocalFiles.LocalDirectory());
                } else if (file instanceof MojangJavaRemoteFiles.RemoteLink) {
                    files.put((String)path, new JavaLocalFiles.LocalLink(((MojangJavaRemoteFiles.RemoteLink)file).getTarget()));
                }
            });
            JavaManifest manifest = new JavaManifest(info, update, files);
            JsonUtils.writeToJsonFile(this.getManifestFile(platform, gameJavaVersion), manifest);
            return JavaRuntime.of(executable, info, true);
        });
    }

    public Task<JavaRuntime> getInstallJavaTask(Platform platform, String name, Map<String, Object> update, Path archiveFile) {
        Path javaDir = this.getJavaDir(platform, name);
        return new JavaInstallTask(javaDir, update, archiveFile).thenApplyAsync(result -> {
            if (!result.getInfo().getPlatform().equals(platform)) {
                throw new IOException("Platform is mismatch: expected " + platform + " but got " + result.getInfo().getPlatform());
            }
            Path executable = javaDir.resolve("bin").resolve(platform.getOperatingSystem().getJavaExecutable()).toRealPath(new LinkOption[0]);
            JsonUtils.writeToJsonFile(this.getManifestFile(platform, name), result);
            return JavaRuntime.of(executable, result.getInfo(), true);
        });
    }

    @Override
    public Task<Void> getUninstallJavaTask(Platform platform, String name) {
        return Task.runAsync(() -> {
            Files.deleteIfExists(this.getManifestFile(platform, name));
            FileUtils.deleteDirectory(this.getJavaDir(platform, name));
        });
    }

    @Override
    public Task<Void> getUninstallJavaTask(JavaRuntime java) {
        return Task.runAsync(() -> {
            Path root = this.getPlatformRoot(java.getPlatform());
            Path relativized = root.relativize(java.getBinary());
            if (relativized.getNameCount() > 1) {
                String name = relativized.getName(0).toString();
                Files.deleteIfExists(this.getManifestFile(java.getPlatform(), name));
                FileUtils.deleteDirectory(this.getJavaDir(java.getPlatform(), name));
            }
        });
    }
}

