/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.java;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.stream.Collectors;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import org.jackhuang.hmcl.Metadata;
import org.jackhuang.hmcl.download.DownloadProvider;
import org.jackhuang.hmcl.download.LibraryAnalyzer;
import org.jackhuang.hmcl.game.GameJavaVersion;
import org.jackhuang.hmcl.game.JavaVersionConstraint;
import org.jackhuang.hmcl.game.Version;
import org.jackhuang.hmcl.java.HMCLJavaRepository;
import org.jackhuang.hmcl.java.JavaInfo;
import org.jackhuang.hmcl.java.JavaInfoUtils;
import org.jackhuang.hmcl.java.JavaRuntime;
import org.jackhuang.hmcl.setting.ConfigHolder;
import org.jackhuang.hmcl.task.Schedulers;
import org.jackhuang.hmcl.task.Task;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.util.CacheRepository;
import org.jackhuang.hmcl.util.Lang;
import org.jackhuang.hmcl.util.io.FileUtils;
import org.jackhuang.hmcl.util.logging.Logger;
import org.jackhuang.hmcl.util.platform.Architecture;
import org.jackhuang.hmcl.util.platform.OperatingSystem;
import org.jackhuang.hmcl.util.platform.Platform;
import org.jackhuang.hmcl.util.platform.UnsupportedPlatformException;
import org.jackhuang.hmcl.util.platform.windows.WinReg;
import org.jackhuang.hmcl.util.versioning.GameVersionNumber;
import org.jetbrains.annotations.Nullable;

public final class JavaManager {
    public static final HMCLJavaRepository REPOSITORY = new HMCLJavaRepository(Metadata.HMCL_GLOBAL_DIRECTORY.resolve("java"));
    public static final HMCLJavaRepository LOCAL_REPOSITORY = new HMCLJavaRepository(Metadata.HMCL_CURRENT_DIRECTORY.resolve("java"));
    private static volatile Map<Path, JavaRuntime> allJava;
    private static final CountDownLatch LATCH;
    private static final ObjectProperty<Collection<JavaRuntime>> allJavaProperty;

    private JavaManager() {
    }

    public static String getMojangJavaPlatform(Platform platform) {
        if (platform.getOperatingSystem() == OperatingSystem.WINDOWS) {
            if (Architecture.SYSTEM_ARCH == Architecture.X86) {
                return "windows-x86";
            }
            if (Architecture.SYSTEM_ARCH == Architecture.X86_64) {
                return "windows-x64";
            }
            if (Architecture.SYSTEM_ARCH == Architecture.ARM64) {
                return "windows-arm64";
            }
        } else if (platform.getOperatingSystem() == OperatingSystem.LINUX) {
            if (Architecture.SYSTEM_ARCH == Architecture.X86) {
                return "linux-i386";
            }
            if (Architecture.SYSTEM_ARCH == Architecture.X86_64) {
                return "linux";
            }
        } else if (platform.getOperatingSystem() == OperatingSystem.MACOS) {
            if (Architecture.SYSTEM_ARCH == Architecture.X86_64) {
                return "mac-os";
            }
            if (Architecture.SYSTEM_ARCH == Architecture.ARM64) {
                return "mac-os-arm64";
            }
        }
        return null;
    }

    public static Path getExecutable(Path javaHome) {
        return javaHome.resolve("bin").resolve(OperatingSystem.CURRENT_OS.getJavaExecutable());
    }

    public static Path getMacExecutable(Path javaHome) {
        return javaHome.resolve("jre.bundle/Contents/Home/bin/java");
    }

    public static boolean isCompatible(Platform platform) {
        if (platform.getOperatingSystem() != OperatingSystem.CURRENT_OS) {
            return false;
        }
        Architecture architecture = platform.getArchitecture();
        if (architecture == Architecture.SYSTEM_ARCH || architecture == Architecture.CURRENT_ARCH) {
            return true;
        }
        switch (OperatingSystem.CURRENT_OS) {
            case WINDOWS: {
                if (Architecture.SYSTEM_ARCH == Architecture.X86_64) {
                    return architecture == Architecture.X86;
                }
                if (Architecture.SYSTEM_ARCH != Architecture.ARM64) break;
                return OperatingSystem.SYSTEM_BUILD_NUMBER >= 21277 && architecture == Architecture.X86_64 || architecture == Architecture.X86;
            }
            case LINUX: {
                if (Architecture.SYSTEM_ARCH != Architecture.X86_64) break;
                return architecture == Architecture.X86;
            }
            case MACOS: {
                if (Architecture.SYSTEM_ARCH != Architecture.ARM64) break;
                return architecture == Architecture.X86_64;
            }
        }
        return false;
    }

    private static Map<Path, JavaRuntime> getAllJavaMap() throws InterruptedException {
        Map<Path, JavaRuntime> map = allJava;
        if (map == null) {
            LATCH.await();
            map = allJava;
        }
        return map;
    }

    private static void updateAllJavaProperty(Map<Path, JavaRuntime> javaRuntimes) {
        Object[] array = javaRuntimes.values().toArray(new JavaRuntime[0]);
        Arrays.sort(array);
        allJavaProperty.set(Arrays.asList(array));
    }

    public static boolean isInitialized() {
        return allJava != null;
    }

    public static Collection<JavaRuntime> getAllJava() throws InterruptedException {
        return JavaManager.getAllJavaMap().values();
    }

    public static ObjectProperty<Collection<JavaRuntime>> getAllJavaProperty() {
        return allJavaProperty;
    }

    public static JavaRuntime getJava(Path executable) throws IOException, InterruptedException {
        executable = executable.toRealPath(new LinkOption[0]);
        JavaRuntime javaRuntime = JavaManager.getAllJavaMap().get(executable);
        if (javaRuntime != null) {
            return javaRuntime;
        }
        JavaInfo info = JavaInfoUtils.fromExecutable(executable, true);
        return JavaRuntime.of(executable, info, false);
    }

    public static void refresh() {
        Task.supplyAsync(JavaManager::searchPotentialJavaExecutables).whenComplete(Schedulers.javafx(), (result, exception) -> {
            if (result != null) {
                LATCH.await();
                allJava = result;
                JavaManager.updateAllJavaProperty(result);
            }
        }).start();
    }

    public static Task<JavaRuntime> getAddJavaTask(Path binary) {
        return Task.supplyAsync("Get Java", () -> JavaManager.getJava(binary)).thenApplyAsync(Schedulers.javafx(), javaRuntime -> {
            if (!JavaManager.isCompatible(javaRuntime.getPlatform())) {
                throw new UnsupportedPlatformException("Incompatible platform: " + javaRuntime.getPlatform());
            }
            String pathString = javaRuntime.getBinary().toString();
            ConfigHolder.globalConfig().getDisabledJava().remove((Object)pathString);
            if (ConfigHolder.globalConfig().getUserJava().add((Object)pathString)) {
                JavaManager.addJava(javaRuntime);
            }
            return javaRuntime;
        });
    }

    public static Task<JavaRuntime> getDownloadJavaTask(DownloadProvider downloadProvider, Platform platform, GameJavaVersion gameJavaVersion) {
        return REPOSITORY.getDownloadJavaTask(downloadProvider, platform, gameJavaVersion).thenApplyAsync(Schedulers.javafx(), java -> {
            JavaManager.addJava(java);
            return java;
        });
    }

    public static Task<JavaRuntime> getInstallJavaTask(Platform platform, String name, Map<String, Object> update, Path archiveFile) {
        return REPOSITORY.getInstallJavaTask(platform, name, update, archiveFile).thenApplyAsync(Schedulers.javafx(), java -> {
            JavaManager.addJava(java);
            return java;
        });
    }

    public static Task<Void> getUninstallJavaTask(JavaRuntime java) {
        Path platformRoot;
        assert (java.isManaged());
        try {
            platformRoot = REPOSITORY.getPlatformRoot(java.getPlatform()).toRealPath(new LinkOption[0]);
        }
        catch (Throwable ignored) {
            return Task.completed(null);
        }
        if (!java.getBinary().startsWith(platformRoot)) {
            return Task.completed(null);
        }
        Path relativized = platformRoot.relativize(java.getBinary());
        if (relativized.getNameCount() > 1) {
            FXUtils.runInFX(() -> {
                try {
                    JavaManager.removeJava(java);
                }
                catch (InterruptedException e) {
                    throw new AssertionError("Unreachable code", e);
                }
            });
            String name = relativized.getName(0).toString();
            return REPOSITORY.getUninstallJavaTask(java.getPlatform(), name);
        }
        return Task.completed(null);
    }

    public static void addJava(JavaRuntime java) throws InterruptedException {
        Map<Path, JavaRuntime> oldMap = JavaManager.getAllJavaMap();
        if (!oldMap.containsKey(java.getBinary())) {
            HashMap<Path, JavaRuntime> newMap = new HashMap<Path, JavaRuntime>(oldMap);
            newMap.put(java.getBinary(), java);
            allJava = newMap;
            JavaManager.updateAllJavaProperty(newMap);
        }
    }

    public static void removeJava(JavaRuntime java) throws InterruptedException {
        JavaManager.removeJava(java.getBinary());
    }

    public static void removeJava(Path realPath) throws InterruptedException {
        Map<Path, JavaRuntime> oldMap = JavaManager.getAllJavaMap();
        if (oldMap.containsKey(realPath)) {
            HashMap<Path, JavaRuntime> newMap = new HashMap<Path, JavaRuntime>(oldMap);
            newMap.remove(realPath);
            allJava = newMap;
            JavaManager.updateAllJavaProperty(newMap);
        }
    }

    private static JavaRuntime chooseJava(@Nullable JavaRuntime java1, JavaRuntime java2) {
        if (java1 == null) {
            return java2;
        }
        if (java1.getParsedVersion() != java2.getParsedVersion()) {
            return java1.getParsedVersion() < java2.getParsedVersion() ? java1 : java2;
        }
        return java1.getVersionNumber().compareTo(java2.getVersionNumber()) >= 0 ? java1 : java2;
    }

    @Nullable
    public static JavaRuntime findSuitableJava(GameVersionNumber gameVersion, Version version) throws InterruptedException {
        return JavaManager.findSuitableJava(JavaManager.getAllJava(), gameVersion, version);
    }

    @Nullable
    public static JavaRuntime findSuitableJava(Collection<JavaRuntime> javaRuntimes, GameVersionNumber gameVersion, Version version) {
        LibraryAnalyzer analyzer = version != null ? LibraryAnalyzer.analyze(version, gameVersion != null ? gameVersion.toString() : null) : null;
        boolean forceX86 = !(Architecture.SYSTEM_ARCH != Architecture.ARM64 || OperatingSystem.CURRENT_OS != OperatingSystem.WINDOWS && OperatingSystem.CURRENT_OS != OperatingSystem.MACOS || gameVersion != null && gameVersion.compareTo("1.6") >= 0);
        JavaRuntime mandatory = null;
        JavaRuntime suggested = null;
        for (JavaRuntime java : javaRuntimes) {
            if (forceX86 ? !java.getArchitecture().isX86() : java.getArchitecture() != Architecture.SYSTEM_ARCH) continue;
            boolean violationMandatory = false;
            boolean violationSuggested = false;
            for (JavaVersionConstraint constraint : JavaVersionConstraint.ALL) {
                if (!constraint.appliesToVersion(gameVersion, version, java, analyzer) || constraint.checkJava(gameVersion, version, java)) continue;
                if (constraint.isMandatory()) {
                    violationMandatory = true;
                    continue;
                }
                violationSuggested = true;
            }
            if (violationMandatory) continue;
            mandatory = JavaManager.chooseJava(mandatory, java);
            if (violationSuggested) continue;
            suggested = JavaManager.chooseJava(suggested, java);
        }
        return suggested != null ? suggested : mandatory;
    }

    public static void initialize() {
        Map<Path, JavaRuntime> allJava = JavaManager.searchPotentialJavaExecutables();
        JavaManager.allJava = allJava;
        LATCH.countDown();
        FXUtils.runInFX(() -> JavaManager.updateAllJavaProperty(allJava));
    }

    private static Map<Path, JavaRuntime> searchPotentialJavaExecutables() {
        Object paths;
        HashMap<Path, JavaRuntime> javaRuntimes = new HashMap<Path, JavaRuntime>();
        JavaManager.searchAllJavaInRepository(javaRuntimes, Platform.SYSTEM_PLATFORM);
        switch (OperatingSystem.CURRENT_OS) {
            case WINDOWS: {
                if (Architecture.SYSTEM_ARCH == Architecture.X86_64) {
                    JavaManager.searchAllJavaInRepository(javaRuntimes, Platform.WINDOWS_X86);
                }
                if (Architecture.SYSTEM_ARCH != Architecture.ARM64) break;
                if (OperatingSystem.SYSTEM_BUILD_NUMBER >= 21277) {
                    JavaManager.searchAllJavaInRepository(javaRuntimes, Platform.WINDOWS_X86_64);
                }
                JavaManager.searchAllJavaInRepository(javaRuntimes, Platform.WINDOWS_X86);
                break;
            }
            case MACOS: {
                if (Architecture.SYSTEM_ARCH != Architecture.ARM64) break;
                JavaManager.searchAllJavaInRepository(javaRuntimes, Platform.MACOS_X86_64);
            }
        }
        switch (OperatingSystem.CURRENT_OS) {
            case WINDOWS: {
                JavaManager.queryJavaInRegistryKey(javaRuntimes, WinReg.HKEY.HKEY_LOCAL_MACHINE, "SOFTWARE\\JavaSoft\\Java Runtime Environment");
                JavaManager.queryJavaInRegistryKey(javaRuntimes, WinReg.HKEY.HKEY_LOCAL_MACHINE, "SOFTWARE\\JavaSoft\\Java Development Kit");
                JavaManager.queryJavaInRegistryKey(javaRuntimes, WinReg.HKEY.HKEY_LOCAL_MACHINE, "SOFTWARE\\JavaSoft\\JRE");
                JavaManager.queryJavaInRegistryKey(javaRuntimes, WinReg.HKEY.HKEY_LOCAL_MACHINE, "SOFTWARE\\JavaSoft\\JDK");
                JavaManager.searchJavaInProgramFiles(javaRuntimes, "ProgramFiles", "C:\\Program Files");
                JavaManager.searchJavaInProgramFiles(javaRuntimes, "ProgramFiles(x86)", "C:\\Program Files (x86)");
                if (Architecture.SYSTEM_ARCH != Architecture.ARM64) break;
                JavaManager.searchJavaInProgramFiles(javaRuntimes, "ProgramFiles(ARM)", "C:\\Program Files (ARM)");
                break;
            }
            case LINUX: {
                JavaManager.searchAllJavaInDirectory(javaRuntimes, Paths.get("/usr/java", new String[0]));
                JavaManager.searchAllJavaInDirectory(javaRuntimes, Paths.get("/usr/lib/jvm", new String[0]));
                JavaManager.searchAllJavaInDirectory(javaRuntimes, Paths.get("/usr/lib32/jvm", new String[0]));
                JavaManager.searchAllJavaInDirectory(javaRuntimes, Paths.get("/usr/lib64/jvm", new String[0]));
                JavaManager.searchAllJavaInDirectory(javaRuntimes, Paths.get(System.getProperty("user.home"), "/.sdkman/candidates/java"));
                break;
            }
            case MACOS: {
                JavaManager.searchJavaInMacJavaVirtualMachines(javaRuntimes, Paths.get("/Library/Java/JavaVirtualMachines", new String[0]));
                JavaManager.searchJavaInMacJavaVirtualMachines(javaRuntimes, Paths.get(System.getProperty("user.home"), "/Library/Java/JavaVirtualMachines"));
                JavaManager.tryAddJavaExecutable(javaRuntimes, Paths.get("/Library/Internet Plug-Ins/JavaAppletPlugin.plugin/Contents/Home/bin/java", new String[0]));
                JavaManager.tryAddJavaExecutable(javaRuntimes, Paths.get("/Applications/Xcode.app/Contents/Applications/Application Loader.app/Contents/MacOS/itms/java/bin/java", new String[0]));
                JavaManager.tryAddJavaExecutable(javaRuntimes, Paths.get("/opt/homebrew/opt/java/bin/java", new String[0]));
                JavaManager.searchAllJavaInDirectory(javaRuntimes, Paths.get("/opt/homebrew/Cellar/openjdk", new String[0]));
                try (DirectoryStream<Path> dirs = Files.newDirectoryStream(Paths.get("/opt/homebrew/Cellar", new String[0]), "openjdk@*");){
                    for (Path dir : dirs) {
                        JavaManager.searchAllJavaInDirectory(javaRuntimes, dir);
                    }
                }
                catch (IOException e) {
                    Logger.LOG.warning("Failed to get subdirectories of /opt/homebrew/Cellar");
                }
                break;
            }
        }
        if (OperatingSystem.CURRENT_OS == OperatingSystem.WINDOWS && Architecture.SYSTEM_ARCH.isX86()) {
            FileUtils.tryGetPath(System.getenv("localappdata"), "Packages\\Microsoft.4297127D64EC6_8wekyb3d8bbwe\\LocalCache\\Local\\runtime").ifPresent(it -> JavaManager.searchAllOfficialJava(javaRuntimes, it, false));
            FileUtils.tryGetPath(Lang.requireNonNullElse(System.getenv("ProgramFiles(x86)"), "C:\\Program Files (x86)"), "Minecraft Launcher\\runtime").ifPresent(it -> JavaManager.searchAllOfficialJava(javaRuntimes, it, false));
        } else if (OperatingSystem.CURRENT_OS == OperatingSystem.LINUX && Architecture.SYSTEM_ARCH == Architecture.X86_64) {
            JavaManager.searchAllOfficialJava(javaRuntimes, Paths.get(System.getProperty("user.home"), ".minecraft/runtime"), false);
        } else if (OperatingSystem.CURRENT_OS == OperatingSystem.MACOS) {
            JavaManager.searchAllOfficialJava(javaRuntimes, Paths.get(System.getProperty("user.home"), "Library/Application Support/minecraft/runtime"), false);
        }
        JavaManager.searchAllOfficialJava(javaRuntimes, CacheRepository.getInstance().getCacheDirectory().resolve("java"), true);
        if (System.getenv("PATH") != null) {
            for (String path : paths = System.getenv("PATH").split(File.pathSeparator)) {
                if (OperatingSystem.CURRENT_OS == OperatingSystem.WINDOWS && path.toLowerCase(Locale.ROOT).contains("\\common files\\oracle\\java\\")) continue;
                try {
                    JavaManager.tryAddJavaExecutable(javaRuntimes, Path.of(path, OperatingSystem.CURRENT_OS.getJavaExecutable()));
                }
                catch (InvalidPathException invalidPathException) {
                    // empty catch block
                }
            }
        }
        if (System.getenv("HMCL_JRES") != null) {
            for (String path : paths = System.getenv("HMCL_JRES").split(File.pathSeparator)) {
                try {
                    JavaManager.tryAddJavaHome(javaRuntimes, Paths.get(path, new String[0]));
                }
                catch (InvalidPathException invalidPathException) {
                    // empty catch block
                }
            }
        }
        JavaManager.searchAllJavaInDirectory(javaRuntimes, Paths.get(System.getProperty("user.home"), ".jdks"));
        for (String javaPath : ConfigHolder.globalConfig().getUserJava()) {
            try {
                JavaManager.tryAddJavaExecutable(javaRuntimes, Paths.get(javaPath, new String[0]));
            }
            catch (InvalidPathException e) {
                Logger.LOG.warning("Invalid Java path: " + javaPath);
            }
        }
        JavaRuntime currentJava = JavaRuntime.CURRENT_JAVA;
        if (currentJava != null && !javaRuntimes.containsKey(currentJava.getBinary()) && !ConfigHolder.globalConfig().getDisabledJava().contains((Object)currentJava.getBinary().toString())) {
            javaRuntimes.put(currentJava.getBinary(), currentJava);
        }
        Logger.LOG.trace(javaRuntimes.values().stream().sorted().map(it -> String.format(" - %s %s (%s, %s): %s", it.isJDK() ? "JDK" : "JRE", it.getVersion(), it.getPlatform().getArchitecture().getDisplayName(), Lang.requireNonNullElse(it.getVendor(), "Unknown"), it.getBinary())).collect(Collectors.joining("\n", "Finished Java lookup, found " + javaRuntimes.size() + "\n", "")));
        return javaRuntimes;
    }

    private static void tryAddJavaHome(Map<Path, JavaRuntime> javaRuntimes, Path javaHome) {
        Path executable = JavaManager.getExecutable(javaHome);
        if (!Files.isRegularFile(executable, new LinkOption[0])) {
            return;
        }
        try {
            executable = executable.toRealPath(new LinkOption[0]);
        }
        catch (IOException e) {
            Logger.LOG.warning("Failed to resolve path " + executable, e);
            return;
        }
        if (javaRuntimes.containsKey(executable) || ConfigHolder.globalConfig().getDisabledJava().contains((Object)executable.toString())) {
            return;
        }
        JavaInfo info = null;
        Path releaseFile = javaHome.resolve("release");
        if (Files.exists(releaseFile, new LinkOption[0])) {
            try {
                info = JavaInfo.fromReleaseFile(releaseFile);
            }
            catch (IOException e) {
                Logger.LOG.warning("Failed to read release file " + releaseFile, e);
            }
        }
        if (info == null) {
            try {
                info = JavaInfoUtils.fromExecutable(executable, false);
            }
            catch (IOException e) {
                Logger.LOG.warning("Failed to lookup Java executable at " + executable, e);
            }
        }
        if (info != null && JavaManager.isCompatible(info.getPlatform())) {
            javaRuntimes.put(executable, JavaRuntime.of(executable, info, false));
        }
    }

    private static void tryAddJavaExecutable(Map<Path, JavaRuntime> javaRuntimes, Path executable) {
        try {
            executable = executable.toRealPath(new LinkOption[0]);
        }
        catch (IOException e) {
            return;
        }
        if (javaRuntimes.containsKey(executable) || ConfigHolder.globalConfig().getDisabledJava().contains((Object)executable.toString())) {
            return;
        }
        JavaInfo info = null;
        try {
            info = JavaInfoUtils.fromExecutable(executable, true);
        }
        catch (IOException e) {
            Logger.LOG.warning("Failed to lookup Java executable at " + executable, e);
        }
        if (info != null && JavaManager.isCompatible(info.getPlatform())) {
            javaRuntimes.put(executable, JavaRuntime.of(executable, info, false));
        }
    }

    private static void tryAddJavaInComponentDir(Map<Path, JavaRuntime> javaRuntimes, String platform, Path component, boolean verify) {
        Path sha1File = component.resolve(platform).resolve(component.getFileName() + ".sha1");
        if (!Files.isRegularFile(sha1File, new LinkOption[0])) {
            return;
        }
        Path dir = component.resolve(platform).resolve(component.getFileName());
        if (verify) {
            try (BufferedReader reader = Files.newBufferedReader(sha1File);){
                String line;
                while ((line = reader.readLine()) != null) {
                    if (line.isEmpty()) continue;
                    int idx = line.indexOf(" /#//");
                    if (idx <= 0) {
                        throw new IOException("Illegal line: " + line);
                    }
                    Path file = dir.resolve(line.substring(0, idx));
                    if (!Files.notExists(file, new LinkOption[0])) continue;
                    throw new NoSuchFileException(file.toAbsolutePath().toString());
                }
            }
            catch (IOException e) {
                Logger.LOG.warning("Failed to verify Java in " + component, e);
                return;
            }
        }
        if (OperatingSystem.CURRENT_OS == OperatingSystem.MACOS) {
            Path macPath = dir.resolve("jre.bundle/Contents/Home");
            if (Files.exists(macPath, new LinkOption[0])) {
                JavaManager.tryAddJavaHome(javaRuntimes, macPath);
                return;
            }
            Logger.LOG.warning("The Java is not in 'jre.bundle/Contents/Home'");
        }
        JavaManager.tryAddJavaHome(javaRuntimes, dir);
    }

    private static void searchAllJavaInRepository(Map<Path, JavaRuntime> javaRuntimes, Platform platform) {
        for (JavaRuntime java : REPOSITORY.getAllJava(platform)) {
            javaRuntimes.put(java.getBinary(), java);
        }
        for (JavaRuntime java : LOCAL_REPOSITORY.getAllJava(platform)) {
            javaRuntimes.put(java.getBinary(), java);
        }
    }

    private static void searchAllOfficialJava(Map<Path, JavaRuntime> javaRuntimes, Path directory, boolean verify) {
        if (!Files.isDirectory(directory, new LinkOption[0])) {
            return;
        }
        String javaPlatform = JavaManager.getMojangJavaPlatform(Platform.SYSTEM_PLATFORM);
        if (javaPlatform != null) {
            JavaManager.searchAllOfficialJava(javaRuntimes, directory, javaPlatform, verify);
        }
        if (OperatingSystem.CURRENT_OS == OperatingSystem.WINDOWS) {
            if (Architecture.SYSTEM_ARCH == Architecture.X86_64) {
                JavaManager.searchAllOfficialJava(javaRuntimes, directory, JavaManager.getMojangJavaPlatform(Platform.WINDOWS_X86), verify);
            } else if (Architecture.SYSTEM_ARCH == Architecture.ARM64) {
                if (OperatingSystem.SYSTEM_BUILD_NUMBER >= 21277) {
                    JavaManager.searchAllOfficialJava(javaRuntimes, directory, JavaManager.getMojangJavaPlatform(Platform.WINDOWS_X86_64), verify);
                }
                JavaManager.searchAllOfficialJava(javaRuntimes, directory, JavaManager.getMojangJavaPlatform(Platform.WINDOWS_X86), verify);
            }
        } else if (OperatingSystem.CURRENT_OS == OperatingSystem.MACOS && Architecture.CURRENT_ARCH == Architecture.ARM64) {
            JavaManager.searchAllOfficialJava(javaRuntimes, directory, JavaManager.getMojangJavaPlatform(Platform.MACOS_X86_64), verify);
        }
    }

    private static void searchAllOfficialJava(Map<Path, JavaRuntime> javaRuntimes, Path directory, String platform, boolean verify) {
        try (DirectoryStream<Path> dir = Files.newDirectoryStream(directory);){
            for (Path component : dir) {
                JavaManager.tryAddJavaInComponentDir(javaRuntimes, platform, component, verify);
            }
        }
        catch (IOException e) {
            Logger.LOG.warning("Failed to list java-runtime directory " + directory, e);
        }
    }

    private static void searchAllJavaInDirectory(Map<Path, JavaRuntime> javaRuntimes, Path directory) {
        if (!Files.isDirectory(directory, new LinkOption[0])) {
            return;
        }
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(directory);){
            for (Path subDir : stream) {
                JavaManager.tryAddJavaHome(javaRuntimes, subDir);
            }
        }
        catch (IOException e) {
            Logger.LOG.warning("Failed to find Java in " + directory, e);
        }
    }

    private static void searchJavaInProgramFiles(Map<Path, JavaRuntime> javaRuntimes, String env, String defaultValue) {
        Path path;
        String programFiles = Lang.requireNonNullElse(System.getenv(env), defaultValue);
        try {
            path = Paths.get(programFiles, new String[0]);
        }
        catch (InvalidPathException ignored) {
            return;
        }
        for (String vendor : new String[]{"Java", "BellSoft", "AdoptOpenJDK", "Zulu", "Microsoft", "Eclipse Foundation", "Semeru"}) {
            JavaManager.searchAllJavaInDirectory(javaRuntimes, path.resolve(vendor));
        }
    }

    private static void searchJavaInMacJavaVirtualMachines(Map<Path, JavaRuntime> javaRuntimes, Path directory) {
        if (!Files.isDirectory(directory, new LinkOption[0])) {
            return;
        }
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(directory);){
            for (Path subDir : stream) {
                JavaManager.tryAddJavaHome(javaRuntimes, subDir.resolve("Contents/Home"));
            }
        }
        catch (IOException e) {
            Logger.LOG.warning("Failed to find Java in " + directory, e);
        }
    }

    private static void queryJavaInRegistryKey(Map<Path, JavaRuntime> javaRuntimes, WinReg.HKEY hkey, String location) {
        WinReg reg = WinReg.INSTANCE;
        if (reg == null) {
            return;
        }
        for (String java : reg.querySubKeys(hkey, location)) {
            Object home;
            if (!reg.querySubKeys(hkey, java).contains(java + "\\MSI") || !((home = reg.queryValue(hkey, java, "JavaHome")) instanceof String)) continue;
            try {
                JavaManager.tryAddJavaHome(javaRuntimes, Paths.get((String)home, new String[0]));
            }
            catch (InvalidPathException e) {
                Logger.LOG.warning("Invalid Java path in system registry: " + home);
            }
        }
    }

    static {
        LATCH = new CountDownLatch(1);
        allJavaProperty = new SimpleObjectProperty();
    }
}

