/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.mod.mcbbs;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import org.jackhuang.hmcl.download.LibraryAnalyzer;
import org.jackhuang.hmcl.game.DefaultGameRepository;
import org.jackhuang.hmcl.game.Library;
import org.jackhuang.hmcl.mod.ModAdviser;
import org.jackhuang.hmcl.mod.Modpack;
import org.jackhuang.hmcl.mod.ModpackExportInfo;
import org.jackhuang.hmcl.mod.curse.CurseManifest;
import org.jackhuang.hmcl.mod.curse.CurseManifestMinecraft;
import org.jackhuang.hmcl.mod.curse.CurseManifestModLoader;
import org.jackhuang.hmcl.mod.mcbbs.McbbsModpackManifest;
import org.jackhuang.hmcl.task.Task;
import org.jackhuang.hmcl.util.DigestUtils;
import org.jackhuang.hmcl.util.StringUtils;
import org.jackhuang.hmcl.util.gson.JsonUtils;
import org.jackhuang.hmcl.util.io.Zipper;
import org.jackhuang.hmcl.util.logging.Logger;

public class McbbsModpackExportTask
extends Task<Void> {
    private final DefaultGameRepository repository;
    private final String version;
    private final ModpackExportInfo info;
    private final Path modpackFile;
    public static final ModpackExportInfo.Options OPTION = new ModpackExportInfo.Options().requireFileApi(true).requireUrl().requireForceUpdate().requireMinMemory().requireAuthlibInjectorServer().requireJavaArguments().requireLaunchArguments().requireOrigins();

    public McbbsModpackExportTask(DefaultGameRepository repository, String version, ModpackExportInfo info, Path modpackFile) {
        this.repository = repository;
        this.version = version;
        this.info = info.validate();
        this.modpackFile = modpackFile;
        this.onDone().register(event -> {
            if (event.isFailed()) {
                try {
                    Files.deleteIfExists(modpackFile);
                }
                catch (IOException e) {
                    Logger.LOG.warning("Failed to delete modpack file: " + modpackFile, e);
                }
            }
        });
    }

    @Override
    public void execute() throws Exception {
        ArrayList<String> blackList = new ArrayList<String>(ModAdviser.MODPACK_BLACK_LIST);
        blackList.add(this.version + ".jar");
        blackList.add(this.version + ".json");
        Logger.LOG.info("Compressing game files without some files in blacklist, including files or directories: usernamecache.json, asm, logs, backups, versions, assets, usercache.json, libraries, crash-reports, launcher_profiles.json, NVIDIA, TCNodeTracker");
        try (Zipper zip = new Zipper(this.modpackFile);){
            Path runDirectory = this.repository.getRunDirectory(this.version);
            ArrayList<McbbsModpackManifest.File> files = new ArrayList<McbbsModpackManifest.File>();
            zip.putDirectory(runDirectory, "overrides", path -> {
                if (Modpack.acceptFile(path, blackList, this.info.getWhitelist())) {
                    Path file = runDirectory.resolve((String)path);
                    if (Files.isRegularFile(file, new LinkOption[0])) {
                        String relativePath = runDirectory.relativize(file).normalize().toString().replace(File.separatorChar, '/');
                        files.add(new McbbsModpackManifest.AddonFile(true, relativePath, DigestUtils.digestToString("SHA-1", file)));
                    }
                    return true;
                }
                return false;
            });
            String gameVersion = this.repository.getGameVersion(this.version).orElseThrow(() -> new IOException("Cannot parse the version of " + this.version));
            LibraryAnalyzer analyzer = LibraryAnalyzer.analyze(this.repository.getResolvedPreservingPatchesVersion(this.version), gameVersion);
            ArrayList<McbbsModpackManifest.Addon> addons = new ArrayList<McbbsModpackManifest.Addon>();
            addons.add(new McbbsModpackManifest.Addon(LibraryAnalyzer.LibraryType.MINECRAFT.getPatchId(), gameVersion));
            analyzer.getVersion(LibraryAnalyzer.LibraryType.FORGE).ifPresent(forgeVersion -> addons.add(new McbbsModpackManifest.Addon(LibraryAnalyzer.LibraryType.FORGE.getPatchId(), (String)forgeVersion)));
            analyzer.getVersion(LibraryAnalyzer.LibraryType.CLEANROOM).ifPresent(cleanroomVersion -> addons.add(new McbbsModpackManifest.Addon(LibraryAnalyzer.LibraryType.CLEANROOM.getPatchId(), (String)cleanroomVersion)));
            analyzer.getVersion(LibraryAnalyzer.LibraryType.NEO_FORGE).ifPresent(neoForgeVersion -> addons.add(new McbbsModpackManifest.Addon(LibraryAnalyzer.LibraryType.NEO_FORGE.getPatchId(), (String)neoForgeVersion)));
            analyzer.getVersion(LibraryAnalyzer.LibraryType.LITELOADER).ifPresent(liteLoaderVersion -> addons.add(new McbbsModpackManifest.Addon(LibraryAnalyzer.LibraryType.LITELOADER.getPatchId(), (String)liteLoaderVersion)));
            analyzer.getVersion(LibraryAnalyzer.LibraryType.OPTIFINE).ifPresent(optifineVersion -> addons.add(new McbbsModpackManifest.Addon(LibraryAnalyzer.LibraryType.OPTIFINE.getPatchId(), (String)optifineVersion)));
            analyzer.getVersion(LibraryAnalyzer.LibraryType.FABRIC).ifPresent(fabricVersion -> addons.add(new McbbsModpackManifest.Addon(LibraryAnalyzer.LibraryType.FABRIC.getPatchId(), (String)fabricVersion)));
            analyzer.getVersion(LibraryAnalyzer.LibraryType.QUILT).ifPresent(quiltVersion -> addons.add(new McbbsModpackManifest.Addon(LibraryAnalyzer.LibraryType.QUILT.getPatchId(), (String)quiltVersion)));
            ArrayList<Library> libraries = new ArrayList<Library>();
            ArrayList<McbbsModpackManifest.Origin> origins = new ArrayList<McbbsModpackManifest.Origin>();
            McbbsModpackManifest.Settings settings = new McbbsModpackManifest.Settings();
            McbbsModpackManifest.LaunchInfo launchInfo = new McbbsModpackManifest.LaunchInfo(this.info.getMinMemory(), this.info.getSupportedJavaVersions(), StringUtils.tokenize(this.info.getLaunchArguments()), StringUtils.tokenize(this.info.getJavaArguments()));
            McbbsModpackManifest mcbbsManifest = new McbbsModpackManifest("minecraftModpack", 2, this.info.getName(), this.info.getVersion(), this.info.getAuthor(), this.info.getDescription(), this.info.getFileApi() == null ? null : StringUtils.removeSuffix(this.info.getFileApi(), "/"), this.info.getUrl(), this.info.isForceUpdate(), origins, addons, libraries, files, settings, launchInfo);
            zip.putTextFile(JsonUtils.GSON.toJson(mcbbsManifest), "mcbbs.packmeta");
            ArrayList<CurseManifestModLoader> modLoaders = new ArrayList<CurseManifestModLoader>();
            analyzer.getVersion(LibraryAnalyzer.LibraryType.FORGE).ifPresent(forgeVersion -> modLoaders.add(new CurseManifestModLoader("forge-" + forgeVersion, true)));
            analyzer.getVersion(LibraryAnalyzer.LibraryType.NEO_FORGE).ifPresent(forgeVersion -> modLoaders.add(new CurseManifestModLoader("neoforge-" + forgeVersion, true)));
            analyzer.getVersion(LibraryAnalyzer.LibraryType.FABRIC).ifPresent(fabricVersion -> modLoaders.add(new CurseManifestModLoader("fabric-" + fabricVersion, true)));
            CurseManifest curseManifest = new CurseManifest("minecraftModpack", 1, this.info.getName(), this.info.getVersion(), this.info.getAuthor(), "overrides", new CurseManifestMinecraft(gameVersion, modLoaders), Collections.emptyList());
            zip.putTextFile(JsonUtils.GSON.toJson(curseManifest), "manifest.json");
        }
    }
}

